/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.models.obj;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import io.github.fabricators_of_create.porting_lib.core.PortingLib;
import io.github.fabricators_of_create.porting_lib.models.UnbakedGeometryHelper;
import io.github.fabricators_of_create.porting_lib.models.geometry.IUnbakedGeometry;
import io.github.fabricators_of_create.porting_lib.models.obj.ObjBakedModel;
import io.github.fabricators_of_create.porting_lib.models.obj.ObjMaterialLibrary;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_1723;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_765;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class ObjModel
implements IUnbakedGeometry<ObjModel>,
class_1100 {
    public static final boolean ENABLED;
    private static final Renderer renderer;
    private static final RenderMaterial diffuseMaterial;
    private static final RenderMaterial defaultMaterial;
    private static final Vector4f COLOR_WHITE;
    private static final class_241[] DEFAULT_COORDS;
    final Map<String, ModelGroup> parts = Maps.newLinkedHashMap();
    private final Set<String> rootComponentNames = Collections.unmodifiableSet(this.parts.keySet());
    private Set<String> allComponentNames;
    final List<Vector3f> positions = Lists.newArrayList();
    final List<class_241> texCoords = Lists.newArrayList();
    final List<Vector3f> normals = Lists.newArrayList();
    final List<Vector4f> colors = Lists.newArrayList();
    public final boolean automaticCulling;
    public final boolean shadeQuads;
    public final boolean flipV;
    public final boolean emissiveAmbient;
    @Nullable
    public final String mtlOverride;
    public final class_2960 modelLocation;

    public ObjModel(ModelSettings settings) {
        this.modelLocation = settings.modelLocation;
        this.automaticCulling = settings.automaticCulling;
        this.shadeQuads = settings.shadeQuads;
        this.flipV = settings.flipV;
        this.emissiveAmbient = settings.emissiveAmbient;
        this.mtlOverride = settings.mtlOverride;
    }

    public Set<String> getRootComponentNames() {
        return this.rootComponentNames;
    }

    public class_1087 bake(class_793 owner, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_806 overrides, class_2960 modelLocation, boolean isGui3d) {
        ImmutableList<Mesh> meshes = this.bakeMeshes(owner, baker, spriteGetter, modelTransform);
        class_1058 particle = spriteGetter.apply(owner.method_24077("particle"));
        return new ObjBakedModel((List<Mesh>)meshes, owner.method_3444(), isGui3d, owner.method_24298().method_24299(), false, owner.method_3443(), overrides, particle);
    }

    @Nullable
    public class_1087 method_4753(@NotNull class_7775 baker, @NotNull Function<class_4730, class_1058> spriteGetter, @NotNull class_3665 modelTransform, @NotNull class_2960 modelLocation) {
        ImmutableList<Mesh> meshes = this.bakeMeshes(null, baker, spriteGetter, modelTransform);
        class_1058 particle = spriteGetter.apply(new class_4730(class_1723.field_21668, class_1047.method_4539()));
        return new ObjBakedModel((List<Mesh>)meshes, false, false, false, false, class_809.field_4301, class_806.field_4292, particle);
    }

    private ImmutableList<Mesh> bakeMeshes(class_793 owner, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform) {
        ImmutableList.Builder bakedMeshes = new ImmutableList.Builder();
        this.parts.values().forEach(part -> {
            MeshBuilder meshBuilder = renderer.meshBuilder();
            part.buildMeshes(owner, meshBuilder, baker, spriteGetter, modelTransform, this.modelLocation);
            bakedMeshes.add((Object)meshBuilder.build());
        });
        return bakedMeshes.build();
    }

    public Set<String> getConfigurableComponentNames() {
        if (this.allComponentNames != null) {
            return this.allComponentNames;
        }
        HashSet<String> names = new HashSet<String>();
        for (ModelGroup group : this.parts.values()) {
            group.addNamesRecursively(names);
        }
        this.allComponentNames = Collections.unmodifiableSet(names);
        return this.allComponentNames;
    }

    private void makeQuad(MeshBuilder builder, int[][] indices, int tintIndex, Vector4f colorTint, Vector4f ambientColor, class_1058 texture, class_4590 transform) {
        boolean needsNormalRecalculation = false;
        for (int[] ints : indices) {
            needsNormalRecalculation |= ints.length < 3;
        }
        Vector3f faceNormal = new Vector3f();
        if (needsNormalRecalculation) {
            Vector3f a = this.positions.get(indices[0][0]);
            Vector3f ab = this.positions.get(indices[1][0]);
            Vector3f ac = this.positions.get(indices[2][0]);
            Vector3f abs = new Vector3f((Vector3fc)ab);
            abs.sub((Vector3fc)a);
            Vector3f acs = new Vector3f((Vector3fc)ac);
            acs.sub((Vector3fc)a);
            abs.cross((Vector3fc)acs);
            abs.normalize();
            faceNormal = abs;
        }
        QuadEmitter quadBaker = builder.getEmitter();
        quadBaker.spriteBake(texture, 0);
        quadBaker.colorIndex(tintIndex);
        int uv2 = 0;
        if (this.emissiveAmbient) {
            int fakeLight = (int)((ambientColor.x() + ambientColor.y() + ambientColor.z()) * 15.0f / 3.0f);
            uv2 = class_765.method_23687((int)fakeLight, (int)fakeLight);
            quadBaker.material(fakeLight == 0 && this.shadeQuads ? defaultMaterial : diffuseMaterial);
        } else {
            quadBaker.material(this.shadeQuads ? defaultMaterial : diffuseMaterial);
        }
        boolean hasTransform = !transform.isIdentity();
        class_4590 transformation = hasTransform ? transform.blockCenterToCorner() : transform;
        Vector4f[] pos = new Vector4f[4];
        Vector3f[] norm = new Vector3f[4];
        for (int i = 0; i < 4; ++i) {
            Vector4f color;
            Vector3f norm0;
            int[] index = indices[Math.min(i, indices.length - 1)];
            Vector4f position = new Vector4f((Vector3fc)this.positions.get(index[0]), 1.0f);
            class_241 texCoord = index.length >= 2 && this.texCoords.size() > 0 ? this.texCoords.get(index[1]) : DEFAULT_COORDS[i];
            Vector3f normal = norm0 = !needsNormalRecalculation && index.length >= 3 && this.normals.size() > 0 ? this.normals.get(index[2]) : faceNormal;
            Vector4f vector4f = color = index.length >= 4 && this.colors.size() > 0 ? this.colors.get(index[3]) : COLOR_WHITE;
            if (hasTransform) {
                normal = new Vector3f((Vector3fc)norm0);
                transformation.transformPosition(position);
                transformation.transformNormal(normal);
            }
            Vector4f tintedColor = new Vector4f(color.x() * colorTint.x(), color.y() * colorTint.y(), color.z() * colorTint.z(), color.w() * colorTint.w());
            quadBaker.pos(i, position.x(), position.y(), position.z());
            int spriteColor = this.encodeQuadColor(tintedColor);
            quadBaker.color(spriteColor, spriteColor, spriteColor, spriteColor);
            quadBaker.uv(i, texture.method_4580((double)(texCoord.field_1343 * 16.0f)), texture.method_4570((double)((this.flipV ? 1.0f - texCoord.field_1342 : texCoord.field_1342) * 16.0f)));
            quadBaker.lightmap(i, uv2);
            quadBaker.normal(i, normal);
            if (i == 0) {
                quadBaker.nominalFace(class_2350.method_10147((float)normal.x(), (float)normal.y(), (float)normal.z()));
            }
            pos[i] = position;
            norm[i] = normal;
        }
        class_2350 cull = null;
        if (this.automaticCulling) {
            if (class_3532.method_15347((float)pos[0].x(), (float)0.0f) && class_3532.method_15347((float)pos[1].x(), (float)0.0f) && class_3532.method_15347((float)pos[2].x(), (float)0.0f) && class_3532.method_15347((float)pos[3].x(), (float)0.0f) && norm[0].x() < 0.0f) {
                cull = class_2350.field_11039;
            } else if (class_3532.method_15347((float)pos[0].x(), (float)1.0f) && class_3532.method_15347((float)pos[1].x(), (float)1.0f) && class_3532.method_15347((float)pos[2].x(), (float)1.0f) && class_3532.method_15347((float)pos[3].x(), (float)1.0f) && norm[0].x() > 0.0f) {
                cull = class_2350.field_11034;
            } else if (class_3532.method_15347((float)pos[0].z(), (float)0.0f) && class_3532.method_15347((float)pos[1].z(), (float)0.0f) && class_3532.method_15347((float)pos[2].z(), (float)0.0f) && class_3532.method_15347((float)pos[3].z(), (float)0.0f) && norm[0].z() < 0.0f) {
                cull = class_2350.field_11043;
            } else if (class_3532.method_15347((float)pos[0].z(), (float)1.0f) && class_3532.method_15347((float)pos[1].z(), (float)1.0f) && class_3532.method_15347((float)pos[2].z(), (float)1.0f) && class_3532.method_15347((float)pos[3].z(), (float)1.0f) && norm[0].z() > 0.0f) {
                cull = class_2350.field_11035;
            } else if (class_3532.method_15347((float)pos[0].y(), (float)0.0f) && class_3532.method_15347((float)pos[1].y(), (float)0.0f) && class_3532.method_15347((float)pos[2].y(), (float)0.0f) && class_3532.method_15347((float)pos[3].y(), (float)0.0f) && norm[0].y() < 0.0f) {
                cull = class_2350.field_11033;
            } else if (class_3532.method_15347((float)pos[0].y(), (float)1.0f) && class_3532.method_15347((float)pos[1].y(), (float)1.0f) && class_3532.method_15347((float)pos[2].y(), (float)1.0f) && class_3532.method_15347((float)pos[3].y(), (float)1.0f) && norm[0].y() > 0.0f) {
                cull = class_2350.field_11036;
            }
        }
        quadBaker.cullFace(cull);
        quadBaker.emit();
    }

    private int encodeQuadColor(Vector4f colorTint) {
        int r = (int)(colorTint.x() * 255.0f);
        int g = (int)(colorTint.y() * 255.0f);
        int b = (int)(colorTint.z() * 255.0f);
        int a = (int)(colorTint.w() * 255.0f);
        return (a & 0xFF) << 24 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF;
    }

    @NotNull
    public Collection<class_2960> method_4755() {
        return List.of();
    }

    public void method_45785(@NotNull Function<class_2960, class_1100> function) {
    }

    static {
        renderer = RendererAccess.INSTANCE.getRenderer();
        boolean bl = ENABLED = renderer != null;
        if (ENABLED) {
            diffuseMaterial = renderer.materialFinder().disableDiffuse(true).find();
            defaultMaterial = renderer.materialById(RenderMaterial.MATERIAL_STANDARD);
        } else {
            PortingLib.LOGGER.error("The Fabric Rendering API is not available. If you have Sodium, install Indium!");
            defaultMaterial = null;
            diffuseMaterial = null;
        }
        COLOR_WHITE = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        DEFAULT_COORDS = new class_241[]{new class_241(0.0f, 0.0f), new class_241(0.0f, 1.0f), new class_241(1.0f, 1.0f), new class_241(1.0f, 0.0f)};
    }

    public record ModelSettings(@NotNull class_2960 modelLocation, boolean automaticCulling, boolean shadeQuads, boolean flipV, boolean emissiveAmbient, @Nullable String mtlOverride) {
    }

    public class ModelGroup
    extends ModelObject {
        final Map<String, ModelObject> parts;

        ModelGroup(String name) {
            super(name);
            this.parts = Maps.newLinkedHashMap();
        }

        @Override
        public void buildMeshes(class_793 owner, MeshBuilder meshBuilder, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_2960 modelLocation) {
            super.buildMeshes(owner, meshBuilder, baker, spriteGetter, modelTransform, modelLocation);
            this.parts.values().stream().filter(part -> owner.isComponentVisible(part.name(), true)).forEach(part -> part.buildMeshes(owner, meshBuilder, baker, spriteGetter, modelTransform, modelLocation));
        }

        @Override
        public Collection<class_4730> getTextures(class_793 owner, Function<class_2960, class_1100> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            HashSet combined = Sets.newHashSet();
            combined.addAll(super.getTextures(owner, modelGetter, missingTextureErrors));
            for (ModelObject part : this.parts.values()) {
                combined.addAll(part.getTextures(owner, modelGetter, missingTextureErrors));
            }
            return combined;
        }

        @Override
        protected void addNamesRecursively(Set<String> names) {
            super.addNamesRecursively(names);
            for (ModelObject object : this.parts.values()) {
                object.addNamesRecursively(names);
            }
        }
    }

    class ModelMesh {
        @Nullable
        public ObjMaterialLibrary.Material mat;
        @Nullable
        public String smoothingGroup;
        public final List<int[][]> faces = Lists.newArrayList();

        public ModelMesh(@Nullable ObjMaterialLibrary.Material currentMat, String currentSmoothingGroup) {
            this.mat = currentMat;
            this.smoothingGroup = currentSmoothingGroup;
        }

        public void buildMesh(@Nullable class_793 owner, MeshBuilder meshBuilder, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform) {
            if (this.mat == null) {
                return;
            }
            class_1058 texture = spriteGetter.apply(UnbakedGeometryHelper.resolveDirtyMaterial((String)this.mat.diffuseColorMap, (class_793)owner));
            int tintIndex = this.mat.diffuseTintIndex;
            Vector4f colorTint = this.mat.diffuseColor;
            class_4590 rootTransform = owner != null ? owner.getRootTransform() : class_4590.method_22931();
            class_4590 transform = rootTransform.isIdentity() ? modelTransform.method_3509() : modelTransform.method_3509().method_22933(rootTransform);
            for (int[][] face : this.faces) {
                ObjModel.this.makeQuad(meshBuilder, face, tintIndex, colorTint, this.mat.ambientColor, texture, transform);
            }
        }
    }

    public class ModelObject {
        public final String name;
        List<ModelMesh> meshes = Lists.newArrayList();

        ModelObject(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public void buildMeshes(@Nullable class_793 owner, MeshBuilder meshBuilder, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_2960 modelLocation) {
            for (ModelMesh mesh : this.meshes) {
                mesh.buildMesh(owner, meshBuilder, spriteGetter, modelTransform);
            }
        }

        public Collection<class_4730> getTextures(class_793 owner, Function<class_2960, class_1100> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return this.meshes.stream().flatMap(mesh -> mesh.mat != null ? Stream.of(UnbakedGeometryHelper.resolveDirtyMaterial((String)mesh.mat.diffuseColorMap, (class_793)owner)) : Stream.of(new class_4730[0])).collect(Collectors.toSet());
        }

        protected void addNamesRecursively(Set<String> names) {
            names.add(this.name());
        }
    }
}

