/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.models;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.fabricators_of_create.porting_lib.models.BakedMeshModel;
import io.github.fabricators_of_create.porting_lib.models.ModelLoader;
import io.github.fabricators_of_create.porting_lib.models.PortingLibModelLoadingRegistry;
import io.github.fabricators_of_create.porting_lib.models.UnbakedGeometryHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import org.jetbrains.annotations.Nullable;

public class ItemLayerModel
implements class_1100 {
    private final class_793 owner;
    @Nullable
    private ImmutableList<class_4730> textures;
    private final Int2ObjectMap<RenderMaterial> layerData;

    private ItemLayerModel(class_793 owner, @Nullable ImmutableList<class_4730> textures, Int2ObjectMap<RenderMaterial> layerData) {
        this.owner = owner;
        this.textures = textures;
        this.layerData = layerData;
    }

    public Collection<class_2960> method_4755() {
        return Collections.emptyList();
    }

    public void method_45785(Function<class_2960, class_1100> modelGetter) {
    }

    @Nullable
    public class_1087 method_4753(class_7775 modelBaker, Function<class_4730, class_1058> spriteGetter, class_3665 modelState, class_2960 modelLocation) {
        if (this.textures == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (this.owner.method_3432("particle")) {
                builder.add((Object)this.owner.method_24077("particle"));
            }
            int i = 0;
            while (this.owner.method_3432("layer" + i)) {
                builder.add((Object)this.owner.method_24077("layer" + i));
                ++i;
            }
            this.textures = builder.build();
        }
        class_1058 particle = spriteGetter.apply(this.owner.method_3432("particle") ? this.owner.method_24077("particle") : (class_4730)this.textures.get(0));
        MeshBuilder meshBuilder = RendererAccess.INSTANCE.getRenderer().meshBuilder();
        for (int i = 0; i < this.textures.size(); ++i) {
            QuadEmitter emitter = meshBuilder.getEmitter();
            class_1058 sprite = spriteGetter.apply((class_4730)this.textures.get(i));
            List unbaked = class_1088.field_5384.method_3480(i, "layer" + i, sprite.method_45851());
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> sprite, (class_3665)modelState, (class_2960)modelLocation);
            for (class_777 quad : quads) {
                emitter.fromVanilla(quad, (RenderMaterial)this.layerData.get(i), quad.method_3358());
                emitter.emit();
            }
        }
        return new BakedMeshModel(this.owner, particle, meshBuilder.build());
    }

    public static final class Loader
    implements ModelLoader {
        public static final Loader INSTANCE = new Loader();

        @Override
        public class_1100 readModel(class_793 parent, JsonObject jsonObject) {
            if (!RendererAccess.INSTANCE.hasRenderer()) {
                throw new JsonParseException("The Fabric Rendering API is not available. If you have Sodium, install Indium!");
            }
            Int2ObjectArrayMap emissiveLayers = new Int2ObjectArrayMap();
            if (jsonObject.has("render_materials")) {
                JsonObject forgeData = jsonObject.get("render_materials").getAsJsonObject();
                this.readLayerData(forgeData, "layers", (Int2ObjectMap<RenderMaterial>)emissiveLayers);
            }
            return new ItemLayerModel(parent, null, (Int2ObjectMap<RenderMaterial>)emissiveLayers);
        }

        public void readLayerData(JsonObject jsonObject, String name, Int2ObjectMap<RenderMaterial> layerData) {
            if (!jsonObject.has(name)) {
                return;
            }
            JsonObject fullbrightLayers = jsonObject.getAsJsonObject(name);
            for (Map.Entry entry : fullbrightLayers.entrySet()) {
                int layer = Integer.parseInt((String)entry.getKey());
                RenderMaterial data = (RenderMaterial)PortingLibModelLoadingRegistry.GSON.fromJson((JsonElement)entry.getValue(), RenderMaterial.class);
                layerData.put(layer, (Object)data);
            }
        }
    }
}

