/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.models.generators;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import io.github.fabricators_of_create.porting_lib.models.generators.CustomLoaderBuilder;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelFile;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelProvider;
import io.github.fabricators_of_create.porting_lib.models.generators.extensions.BlockElementFaceExtensions;
import io.github.fabricators_of_create.porting_lib.models.materials.MaterialData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.class_1047;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_787;
import net.minecraft.class_789;
import net.minecraft.class_793;
import net.minecraft.class_804;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ModelBuilder<T extends ModelBuilder<T>>
extends ModelFile {
    @Nullable
    protected ModelFile parent;
    protected final Map<String, String> textures = new LinkedHashMap<String, String>();
    protected final TransformsBuilder transforms = new TransformsBuilder();
    protected final ExistingFileHelper existingFileHelper;
    protected String renderType = null;
    protected boolean ambientOcclusion = true;
    protected class_793.class_4751 guiLight = null;
    protected final List<ElementBuilder> elements = new ArrayList<ElementBuilder>();
    protected CustomLoaderBuilder<T> customLoader = null;

    protected ModelBuilder(class_2960 outputLocation, ExistingFileHelper existingFileHelper) {
        super(outputLocation);
        this.existingFileHelper = existingFileHelper;
    }

    private T self() {
        return (T)this;
    }

    @Override
    protected boolean exists() {
        return true;
    }

    public T parent(ModelFile parent) {
        Preconditions.checkNotNull((Object)parent, (Object)"Parent must not be null");
        parent.assertExistence();
        this.parent = parent;
        return this.self();
    }

    public T texture(String key, String texture) {
        Preconditions.checkNotNull((Object)key, (Object)"Key must not be null");
        Preconditions.checkNotNull((Object)texture, (Object)"Texture must not be null");
        if (texture.charAt(0) == '#') {
            this.textures.put(key, texture);
            return this.self();
        }
        class_2960 asLoc = texture.contains(":") ? new class_2960(texture) : new class_2960(this.getLocation().method_12836(), texture);
        return this.texture(key, asLoc);
    }

    public T texture(String key, class_2960 texture) {
        Preconditions.checkNotNull((Object)key, (Object)"Key must not be null");
        Preconditions.checkNotNull((Object)texture, (Object)"Texture must not be null");
        Preconditions.checkArgument((boolean)this.existingFileHelper.exists(texture, (ExistingFileHelper.IResourceType)ModelProvider.TEXTURE), (String)"Texture %s does not exist in any known resource pack", (Object)texture);
        this.textures.put(key, texture.toString());
        return this.self();
    }

    public T renderType(String renderType) {
        Preconditions.checkNotNull((Object)renderType, (Object)"Render type must not be null");
        return this.renderType(new class_2960(renderType));
    }

    public T renderType(class_2960 renderType) {
        Preconditions.checkNotNull((Object)renderType, (Object)"Render type must not be null");
        this.renderType = renderType.toString();
        return this.self();
    }

    public TransformsBuilder transforms() {
        return this.transforms;
    }

    public T ao(boolean ao) {
        this.ambientOcclusion = ao;
        return this.self();
    }

    public T guiLight(class_793.class_4751 light) {
        this.guiLight = light;
        return this.self();
    }

    public ElementBuilder element() {
        Preconditions.checkState((this.customLoader == null ? 1 : 0) != 0, (Object)"Cannot use elements and custom loaders at the same time");
        ElementBuilder ret = new ElementBuilder();
        this.elements.add(ret);
        return ret;
    }

    public ElementBuilder element(int index) {
        Preconditions.checkState((this.customLoader == null ? 1 : 0) != 0, (Object)"Cannot use elements and custom loaders at the same time");
        Preconditions.checkElementIndex((int)index, (int)this.elements.size(), (String)"Element index");
        return this.elements.get(index);
    }

    public int getElementCount() {
        return this.elements.size();
    }

    public <L extends CustomLoaderBuilder<T>> L customLoader(BiFunction<T, ExistingFileHelper, L> customLoaderFactory) {
        CustomLoaderBuilder customLoader;
        Preconditions.checkState((this.elements.size() == 0 ? 1 : 0) != 0, (Object)"Cannot use elements and custom loaders at the same time");
        Preconditions.checkNotNull(customLoaderFactory, (Object)"customLoaderFactory must not be null");
        this.customLoader = customLoader = (CustomLoaderBuilder)customLoaderFactory.apply(this.self(), this.existingFileHelper);
        return (L)customLoader;
    }

    @VisibleForTesting
    public JsonObject toJson() {
        Map<class_811, class_804> transforms;
        JsonObject root = new JsonObject();
        if (this.parent != null) {
            root.addProperty("parent", this.parent.getLocation().toString());
        }
        if (!this.ambientOcclusion) {
            root.addProperty("ambientocclusion", Boolean.valueOf(this.ambientOcclusion));
        }
        if (this.guiLight != null) {
            root.addProperty("gui_light", this.guiLight.field_21860);
        }
        if (this.renderType != null) {
            root.addProperty("render_type", this.renderType);
        }
        if (!(transforms = this.transforms.build()).isEmpty()) {
            JsonObject display = new JsonObject();
            for (Map.Entry<class_811, class_804> entry : transforms.entrySet()) {
                JsonObject transform = new JsonObject();
                class_804 vec = entry.getValue();
                if (vec.equals((Object)class_804.field_4284)) continue;
                if (!vec.field_4286.equals((Object)class_804.class_805.field_4290)) {
                    transform.add("translation", (JsonElement)this.serializeVector3f(entry.getValue().field_4286));
                }
                if (!vec.field_4287.equals((Object)class_804.class_805.field_4288)) {
                    transform.add("rotation", (JsonElement)this.serializeVector3f(vec.field_4287));
                }
                if (!vec.field_4285.equals((Object)class_804.class_805.field_4289)) {
                    transform.add("scale", (JsonElement)this.serializeVector3f(entry.getValue().field_4285));
                }
                display.add(entry.getKey().method_15434(), (JsonElement)transform);
            }
            root.add("display", (JsonElement)display);
        }
        if (!this.textures.isEmpty()) {
            JsonObject textures = new JsonObject();
            for (Map.Entry<Object, Object> entry : this.textures.entrySet()) {
                textures.addProperty((String)entry.getKey(), this.serializeLocOrKey((String)entry.getValue()));
            }
            root.add("textures", (JsonElement)textures);
        }
        if (!this.elements.isEmpty()) {
            JsonArray elements = new JsonArray();
            this.elements.stream().map(ElementBuilder::build).forEach(part -> {
                JsonObject partObj = new JsonObject();
                partObj.add("from", (JsonElement)this.serializeVector3f(part.field_4228));
                partObj.add("to", (JsonElement)this.serializeVector3f(part.field_4231));
                if (part.field_4232 != null) {
                    JsonObject rotation = new JsonObject();
                    rotation.add("origin", (JsonElement)this.serializeVector3f(part.field_4232.comp_1118()));
                    rotation.addProperty("axis", part.field_4232.comp_1119().method_15434());
                    rotation.addProperty("angle", (Number)Float.valueOf(part.field_4232.comp_1120()));
                    if (part.field_4232.comp_1121()) {
                        rotation.addProperty("rescale", Boolean.valueOf(part.field_4232.comp_1121()));
                    }
                    partObj.add("rotation", (JsonElement)rotation);
                }
                if (!part.field_4229) {
                    partObj.addProperty("shade", Boolean.valueOf(part.field_4229));
                }
                JsonObject faces = new JsonObject();
                for (class_2350 dir : class_2350.values()) {
                    class_783 face = (class_783)part.field_4230.get(dir);
                    if (face == null) continue;
                    JsonObject faceObj = new JsonObject();
                    faceObj.addProperty("texture", this.serializeLocOrKey(face.field_4224));
                    if (!Arrays.equals(face.field_4227.field_4235, part.method_3401(dir))) {
                        faceObj.add("uv", new Gson().toJsonTree((Object)face.field_4227.field_4235));
                    }
                    if (face.field_4225 != null) {
                        faceObj.addProperty("cullface", face.field_4225.method_15434());
                    }
                    if (face.field_4227.field_4234 != 0) {
                        faceObj.addProperty("rotation", (Number)face.field_4227.field_4234);
                    }
                    if (face.field_4226 != -1) {
                        faceObj.addProperty("tintindex", (Number)face.field_4226);
                    }
                    if (!((BlockElementFaceExtensions)face).port_lib$getRenderMaterial().equals((Object)MaterialData.DEFAULT)) {
                        faceObj.add("render_material", (JsonElement)MaterialData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((BlockElementFaceExtensions)face).port_lib$getRenderMaterial()).result().get());
                    }
                    faces.add(dir.method_15434(), (JsonElement)faceObj);
                }
                if (!part.field_4230.isEmpty()) {
                    partObj.add("faces", (JsonElement)faces);
                }
                elements.add((JsonElement)partObj);
            });
            root.add("elements", (JsonElement)elements);
        }
        if (this.customLoader != null) {
            return this.customLoader.toJson(root);
        }
        return root;
    }

    private String serializeLocOrKey(String tex) {
        if (tex.charAt(0) == '#') {
            return tex;
        }
        return new class_2960(tex).toString();
    }

    private JsonArray serializeVector3f(Vector3f vec) {
        JsonArray ret = new JsonArray();
        ret.add(this.serializeFloat(vec.x()));
        ret.add(this.serializeFloat(vec.y()));
        ret.add(this.serializeFloat(vec.z()));
        return ret;
    }

    private Number serializeFloat(float f) {
        if ((float)((int)f) == f) {
            return (int)f;
        }
        return Float.valueOf(f);
    }

    public class TransformsBuilder {
        private final Map<class_811, io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$TransformsBuilder.TransformVecBuilder> transforms = new LinkedHashMap<class_811, io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$TransformsBuilder.TransformVecBuilder>();

        public io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$TransformsBuilder.TransformVecBuilder transform(class_811 type) {
            Preconditions.checkNotNull((Object)type, (Object)"Perspective cannot be null");
            return this.transforms.computeIfAbsent(type, x$0 -> new TransformVecBuilder((class_811)x$0));
        }

        Map<class_811, class_804> build() {
            return this.transforms.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TransformVecBuilder)e.getValue()).build(), (k1, k2) -> {
                throw new IllegalArgumentException();
            }, LinkedHashMap::new));
        }

        public T end() {
            return ModelBuilder.this.self();
        }

        public class TransformVecBuilder {
            private Vector3f rotation = new Vector3f((Vector3fc)class_804.class_805.field_4288);
            private Vector3f translation = new Vector3f((Vector3fc)class_804.class_805.field_4290);
            private Vector3f scale = new Vector3f((Vector3fc)class_804.class_805.field_4289);
            private Vector3f rightRotation = new Vector3f((Vector3fc)class_804.class_805.field_4288);

            TransformVecBuilder(class_811 type) {
            }

            public io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$TransformsBuilder.TransformVecBuilder rotation(float x, float y, float z) {
                this.rotation = new Vector3f(x, y, z);
                return this;
            }

            public io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$TransformsBuilder.TransformVecBuilder leftRotation(float x, float y, float z) {
                return this.rotation(x, y, z);
            }

            public io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$TransformsBuilder.TransformVecBuilder translation(float x, float y, float z) {
                this.translation = new Vector3f(x, y, z);
                return this;
            }

            public io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$TransformsBuilder.TransformVecBuilder scale(float sc) {
                return this.scale(sc, sc, sc);
            }

            public io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$TransformsBuilder.TransformVecBuilder scale(float x, float y, float z) {
                this.scale = new Vector3f(x, y, z);
                return this;
            }

            public io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$TransformsBuilder.TransformVecBuilder rightRotation(float x, float y, float z) {
                this.rightRotation = new Vector3f(x, y, z);
                return this;
            }

            class_804 build() {
                return new class_804(this.rotation, this.translation, this.scale);
            }

            public TransformsBuilder end() {
                return TransformsBuilder.this;
            }
        }
    }

    public class ElementBuilder {
        private Vector3f from = new Vector3f();
        private Vector3f to = new Vector3f(16.0f, 16.0f, 16.0f);
        private final Map<class_2350, io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$ElementBuilder.FaceBuilder> faces = new LinkedHashMap<class_2350, io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$ElementBuilder.FaceBuilder>();
        private io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$ElementBuilder.RotationBuilder rotation;
        private boolean shade = true;
        private int color = -1;
        private int blockLight = 0;
        private int skyLight = 0;
        private boolean hasAmbientOcclusion = true;

        private void validateCoordinate(float coord, char name) {
            Preconditions.checkArgument((!(coord < -16.0f) && !(coord > 32.0f) ? 1 : 0) != 0, (String)("Position " + name + " out of range, must be within [-16, 32]. Found: %d"), (Object)Float.valueOf(coord));
        }

        private void validatePosition(Vector3f pos) {
            this.validateCoordinate(pos.x(), 'x');
            this.validateCoordinate(pos.y(), 'y');
            this.validateCoordinate(pos.z(), 'z');
        }

        public ElementBuilder from(float x, float y, float z) {
            this.from = new Vector3f(x, y, z);
            this.validatePosition(this.from);
            return this;
        }

        public ElementBuilder to(float x, float y, float z) {
            this.to = new Vector3f(x, y, z);
            this.validatePosition(this.to);
            return this;
        }

        public io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$ElementBuilder.FaceBuilder face(class_2350 dir) {
            Preconditions.checkNotNull((Object)dir, (Object)"Direction must not be null");
            return this.faces.computeIfAbsent(dir, x$0 -> new FaceBuilder((class_2350)x$0));
        }

        public io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$ElementBuilder.RotationBuilder rotation() {
            if (this.rotation == null) {
                this.rotation = new RotationBuilder();
            }
            return this.rotation;
        }

        public ElementBuilder shade(boolean shade) {
            this.shade = shade;
            return this;
        }

        public ElementBuilder allFaces(BiConsumer<class_2350, io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$ElementBuilder.FaceBuilder> action) {
            Arrays.stream(class_2350.values()).forEach(d -> action.accept((class_2350)d, (io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$ElementBuilder.FaceBuilder)this.face((class_2350)d)));
            return this;
        }

        public ElementBuilder faces(BiConsumer<class_2350, io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$ElementBuilder.FaceBuilder> action) {
            this.faces.entrySet().stream().forEach(e -> action.accept((class_2350)e.getKey(), (io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$ElementBuilder.FaceBuilder)((FaceBuilder)e.getValue())));
            return this;
        }

        public ElementBuilder textureAll(String texture) {
            return this.allFaces(this.addTexture(texture));
        }

        public ElementBuilder texture(String texture) {
            return this.faces(this.addTexture(texture));
        }

        public ElementBuilder cube(String texture) {
            return this.allFaces(this.addTexture(texture).andThen((dir, f) -> f.cullface(dir)));
        }

        public ElementBuilder emissivity(int blockLight, int skyLight) {
            this.blockLight = blockLight;
            this.skyLight = skyLight;
            return this;
        }

        public ElementBuilder color(int color) {
            this.color = color;
            return this;
        }

        public ElementBuilder ao(boolean ao) {
            this.hasAmbientOcclusion = ao;
            return this;
        }

        private BiConsumer<class_2350, io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$ElementBuilder.FaceBuilder> addTexture(String texture) {
            return ($, f) -> f.texture(texture);
        }

        class_785 build() {
            Map faces = this.faces.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((FaceBuilder)e.getValue()).build(), (k1, k2) -> {
                throw new IllegalArgumentException();
            }, LinkedHashMap::new));
            return new class_785(this.from, this.to, faces, this.rotation == null ? null : this.rotation.build(), this.shade);
        }

        public T end() {
            return ModelBuilder.this.self();
        }

        public class FaceBuilder {
            private class_2350 cullface;
            private int tintindex = -1;
            private String texture = class_1047.method_4539().toString();
            private float[] uvs;
            private FaceRotation rotation = FaceRotation.ZERO;
            private int color = -1;
            private int blockLight = 0;
            private int skyLight = 0;
            private boolean hasAmbientOcclusion = true;

            FaceBuilder(class_2350 dir) {
            }

            public io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$ElementBuilder.FaceBuilder cullface(@Nullable class_2350 dir) {
                this.cullface = dir;
                return this;
            }

            public io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$ElementBuilder.FaceBuilder tintindex(int index) {
                this.tintindex = index;
                return this;
            }

            public io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$ElementBuilder.FaceBuilder texture(String texture) {
                Preconditions.checkNotNull((Object)texture, (Object)"Texture must not be null");
                this.texture = texture;
                return this;
            }

            public io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$ElementBuilder.FaceBuilder uvs(float u1, float v1, float u2, float v2) {
                this.uvs = new float[]{u1, v1, u2, v2};
                return this;
            }

            public io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$ElementBuilder.FaceBuilder rotation(FaceRotation rot) {
                Preconditions.checkNotNull((Object)((Object)rot), (Object)"Rotation must not be null");
                this.rotation = rot;
                return this;
            }

            public io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$ElementBuilder.FaceBuilder emissivity(int blockLight, int skyLight) {
                this.blockLight = blockLight;
                this.skyLight = skyLight;
                return this;
            }

            public io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$ElementBuilder.FaceBuilder color(int color) {
                this.color = color;
                return this;
            }

            public io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$ElementBuilder.FaceBuilder ao(boolean ao) {
                this.hasAmbientOcclusion = ao;
                return this;
            }

            class_783 build() {
                if (this.texture == null) {
                    throw new IllegalStateException("A model face must have a texture");
                }
                return new class_783(this.cullface, this.tintindex, this.texture, new class_787(this.uvs, this.rotation.rotation));
            }

            public ElementBuilder end() {
                return ElementBuilder.this;
            }
        }

        public class RotationBuilder {
            private Vector3f origin;
            private class_2350.class_2351 axis;
            private float angle;
            private boolean rescale;

            public io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$ElementBuilder.RotationBuilder origin(float x, float y, float z) {
                this.origin = new Vector3f(x, y, z);
                return this;
            }

            public io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$ElementBuilder.RotationBuilder axis(class_2350.class_2351 axis) {
                Preconditions.checkNotNull((Object)axis, (Object)"Axis must not be null");
                this.axis = axis;
                return this;
            }

            public io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$ElementBuilder.RotationBuilder angle(float angle) {
                Preconditions.checkArgument((angle == 0.0f || class_3532.method_15379((float)angle) == 22.5f || class_3532.method_15379((float)angle) == 45.0f ? 1 : 0) != 0, (String)"Invalid rotation %f found, only -45/-22.5/0/22.5/45 allowed", (Object)Float.valueOf(angle));
                this.angle = angle;
                return this;
            }

            public io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder$ElementBuilder.RotationBuilder rescale(boolean rescale) {
                this.rescale = rescale;
                return this;
            }

            class_789 build() {
                return new class_789(this.origin, this.axis, this.angle, this.rescale);
            }

            public ElementBuilder end() {
                return ElementBuilder.this;
            }
        }
    }

    public static enum FaceRotation {
        ZERO(0),
        CLOCKWISE_90(90),
        UPSIDE_DOWN(180),
        COUNTERCLOCKWISE_90(270);

        final int rotation;

        private FaceRotation(int rotation) {
            this.rotation = rotation;
        }
    }
}

