/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.models.builders;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.fabricators_of_create.porting_lib.core.PortingLib;
import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import io.github.fabricators_of_create.porting_lib.models.generators.CustomLoaderBuilder;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder;
import io.github.fabricators_of_create.porting_lib.models.materials.MaterialData;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import net.minecraft.class_2960;

public class ItemLayerModelBuilder<T extends ModelBuilder<T>>
extends CustomLoaderBuilder<T> {
    private final Int2ObjectMap<MaterialData> faceData = new Int2ObjectOpenHashMap();

    public static <T extends ModelBuilder<T>> ItemLayerModelBuilder<T> begin(T parent, ExistingFileHelper existingFileHelper) {
        return new ItemLayerModelBuilder<T>(parent, existingFileHelper);
    }

    protected ItemLayerModelBuilder(T parent, ExistingFileHelper existingFileHelper) {
        super(PortingLib.id((String)"item_layers"), parent, existingFileHelper);
    }

    public ItemLayerModelBuilder<T> emissive(boolean emissive, int ... layers) {
        Preconditions.checkNotNull((Object)layers, (Object)"Layers must not be null");
        Preconditions.checkArgument((layers.length > 0 ? 1 : 0) != 0, (Object)"At least one layer must be specified");
        Preconditions.checkArgument((boolean)Arrays.stream(layers).allMatch(i -> i >= 0), (Object)"All layers must be >= 0");
        for (int i2 : layers) {
            this.faceData.compute(i2, (key, value) -> {
                MaterialData fallback = value == null ? MaterialData.DEFAULT : value;
                return new MaterialData(fallback.color(), emissive, fallback.ambientOcclusion(), fallback.blendMode());
            });
        }
        return this;
    }

    public ItemLayerModelBuilder<T> color(int color, int ... layers) {
        Preconditions.checkNotNull((Object)layers, (Object)"Layers must not be null");
        Preconditions.checkArgument((layers.length > 0 ? 1 : 0) != 0, (Object)"At least one layer must be specified");
        Preconditions.checkArgument((boolean)Arrays.stream(layers).allMatch(i -> i >= 0), (Object)"All layers must be >= 0");
        for (int i2 : layers) {
            this.faceData.compute(i2, (key, value) -> {
                MaterialData fallback = value == null ? MaterialData.DEFAULT : value;
                return new MaterialData(color, fallback.emissive(), fallback.ambientOcclusion(), fallback.blendMode());
            });
        }
        return this;
    }

    public ItemLayerModelBuilder<T> renderType(String renderType, int ... layers) {
        Preconditions.checkNotNull((Object)renderType, (Object)"Render type must not be null");
        class_2960 asLoc = renderType.contains(":") ? new class_2960(renderType) : new class_2960(this.parent.getLocation().method_12836(), renderType);
        return this.renderType(asLoc, layers);
    }

    public ItemLayerModelBuilder<T> renderType(class_2960 renderType, int ... layers) {
        Preconditions.checkNotNull((Object)renderType, (Object)"Render type must not be null");
        Preconditions.checkNotNull((Object)layers, (Object)"Layers must not be null");
        Preconditions.checkArgument((layers.length > 0 ? 1 : 0) != 0, (Object)"At least one layer must be specified");
        Preconditions.checkArgument((boolean)Arrays.stream(layers).allMatch(i -> i >= 0), (Object)"All layers must be >= 0");
        for (int i2 : layers) {
            this.faceData.compute(i2, (key, value) -> {
                MaterialData fallback = value == null ? MaterialData.DEFAULT : value;
                return new MaterialData(fallback.color(), fallback.emissive(), fallback.ambientOcclusion(), renderType);
            });
        }
        return this;
    }

    public JsonObject toJson(JsonObject json) {
        json = super.toJson(json);
        JsonObject forgeData = new JsonObject();
        JsonObject layerObj = new JsonObject();
        for (Int2ObjectMap.Entry entry : this.faceData.int2ObjectEntrySet()) {
            layerObj.add(String.valueOf(entry.getIntKey()), (JsonElement)MaterialData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((MaterialData)entry.getValue())).getOrThrow(false, s -> {}));
        }
        forgeData.add("layers", (JsonElement)layerObj);
        json.add("render_materials", (JsonElement)forgeData);
        return json;
    }
}

