/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.item.impl.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.fabricators_of_create.porting_lib.item.api.client.IItemDecorator;
import io.github.fabricators_of_create.porting_lib.item.api.client.callbacks.ItemDecorationsCallback;
import io.github.fabricators_of_create.porting_lib.item.impl.client.GlStateBackup;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ItemDecoratorHandler {
    private final List<IItemDecorator> itemDecorators;
    private final GlStateBackup stateBackup = new GlStateBackup();
    private static Map<class_1792, ItemDecoratorHandler> DECORATOR_LOOKUP = ImmutableMap.of();
    private static final ItemDecoratorHandler EMPTY = new ItemDecoratorHandler();

    private ItemDecoratorHandler() {
        this.itemDecorators = ImmutableList.of();
    }

    private ItemDecoratorHandler(List<IItemDecorator> itemDecorators) {
        this.itemDecorators = ImmutableList.copyOf(itemDecorators);
    }

    public static void init() {
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            HashMap<class_1792, List<IItemDecorator>> decorators = new HashMap<class_1792, List<IItemDecorator>>();
            ((ItemDecorationsCallback)ItemDecorationsCallback.EVENT.invoker()).registerDecorators(decorators);
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            decorators.forEach((item, itemDecorators) -> builder.put(item, (Object)new ItemDecoratorHandler((List<IItemDecorator>)itemDecorators)));
            DECORATOR_LOOKUP = builder.build();
        });
    }

    public static ItemDecoratorHandler of(class_1799 stack) {
        return DECORATOR_LOOKUP.getOrDefault(stack.method_7909(), EMPTY);
    }

    public void render(class_332 guiGraphics, class_327 font, class_1799 stack, int xOffset, int yOffset) {
        ItemDecoratorHandler.backupGlState(this.stateBackup);
        this.resetRenderState();
        for (IItemDecorator itemDecorator : this.itemDecorators) {
            if (!itemDecorator.render(guiGraphics, font, stack, xOffset, yOffset)) continue;
            this.resetRenderState();
        }
        ItemDecoratorHandler.restoreGlState(this.stateBackup);
    }

    private void resetRenderState() {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    public static void backupGlState(GlStateBackup state) {
        RenderSystem.assertOnRenderThread();
        ItemDecoratorHandler._backupGlState(state);
    }

    public static void restoreGlState(GlStateBackup state) {
        RenderSystem.assertOnRenderThread();
        ItemDecoratorHandler._restoreGlState(state);
    }

    public static void _backupGlState(GlStateBackup state) {
        state.blendEnabled = GlStateManager.BLEND.field_5045.field_5051;
        state.blendSrcRgb = GlStateManager.BLEND.field_5049;
        state.blendDestRgb = GlStateManager.BLEND.field_5048;
        state.blendSrcAlpha = GlStateManager.BLEND.field_5047;
        state.blendDestAlpha = GlStateManager.BLEND.field_5046;
        state.depthEnabled = GlStateManager.DEPTH.field_5074.field_5051;
        state.depthMask = GlStateManager.DEPTH.field_5076;
        state.depthFunc = GlStateManager.DEPTH.field_5075;
        state.cullEnabled = GlStateManager.CULL.field_5072.field_5051;
        state.polyOffsetFillEnabled = GlStateManager.POLY_OFFSET.field_5123.field_5051;
        state.polyOffsetLineEnabled = GlStateManager.POLY_OFFSET.field_5121.field_5051;
        state.polyOffsetFactor = GlStateManager.POLY_OFFSET.field_5124;
        state.polyOffsetUnits = GlStateManager.POLY_OFFSET.field_5122;
        state.colorLogicEnabled = GlStateManager.COLOR_LOGIC.field_5058.field_5051;
        state.colorLogicOp = GlStateManager.COLOR_LOGIC.field_5059;
        state.stencilFuncFunc = GlStateManager.STENCIL.field_5149.field_5148;
        state.stencilFuncRef = GlStateManager.STENCIL.field_5149.field_16203;
        state.stencilFuncMask = GlStateManager.STENCIL.field_5149.field_5147;
        state.stencilMask = GlStateManager.STENCIL.field_5153;
        state.stencilFail = GlStateManager.STENCIL.field_5152;
        state.stencilZFail = GlStateManager.STENCIL.field_5151;
        state.stencilZPass = GlStateManager.STENCIL.field_5150;
        state.scissorEnabled = GlStateManager.SCISSOR.field_26840.field_5051;
        state.colorMaskRed = GlStateManager.COLOR_MASK.field_5063;
        state.colorMaskGreen = GlStateManager.COLOR_MASK.field_5062;
        state.colorMaskBlue = GlStateManager.COLOR_MASK.field_5061;
        state.colorMaskAlpha = GlStateManager.COLOR_MASK.field_5060;
    }

    public static void _restoreGlState(GlStateBackup state) {
        GlStateManager.BLEND.field_5045.method_4470(state.blendEnabled);
        GlStateManager._blendFuncSeparate((int)state.blendSrcRgb, (int)state.blendDestRgb, (int)state.blendSrcAlpha, (int)state.blendDestAlpha);
        GlStateManager.DEPTH.field_5074.method_4470(state.depthEnabled);
        GlStateManager._depthMask((boolean)state.depthMask);
        GlStateManager._depthFunc((int)state.depthFunc);
        GlStateManager.CULL.field_5072.method_4470(state.cullEnabled);
        GlStateManager.POLY_OFFSET.field_5123.method_4470(state.polyOffsetFillEnabled);
        GlStateManager.POLY_OFFSET.field_5121.method_4470(state.polyOffsetLineEnabled);
        GlStateManager._polygonOffset((float)state.polyOffsetFactor, (float)state.polyOffsetUnits);
        GlStateManager.COLOR_LOGIC.field_5058.method_4470(state.colorLogicEnabled);
        GlStateManager._logicOp((int)state.colorLogicOp);
        GlStateManager._stencilFunc((int)state.stencilFuncFunc, (int)state.stencilFuncRef, (int)state.stencilFuncMask);
        GlStateManager._stencilMask((int)state.stencilMask);
        GlStateManager._stencilOp((int)state.stencilFail, (int)state.stencilZFail, (int)state.stencilZPass);
        GlStateManager.SCISSOR.field_26840.method_4470(state.scissorEnabled);
        GlStateManager._colorMask((boolean)state.colorMaskRed, (boolean)state.colorMaskGreen, (boolean)state.colorMaskBlue, (boolean)state.colorMaskAlpha);
    }
}

