/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.entity.events;

import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public abstract class PlayerEvents
extends LivingEntityEvents {
    public static final Event<PlayerBreakSpeed> BREAK_SPEED = EventFactory.createArrayBacked(PlayerBreakSpeed.class, callbacks -> event -> {
        for (PlayerBreakSpeed e : callbacks) {
            e.setBreakSpeed(event);
        }
    });
    public static final Event<PlayerXpPickUp> PICKUP_XP = EventFactory.createArrayBacked(PlayerXpPickUp.class, callbacks -> event -> {
        for (PlayerXpPickUp e : callbacks) {
            e.onPlayerPicksUpXp(event);
        }
    });
    public static final Event<PlayerXpChange> XP_CHANGE = EventFactory.createArrayBacked(PlayerXpChange.class, callbacks -> event -> {
        for (PlayerXpChange e : callbacks) {
            e.onPlayerXpChange(event);
        }
    });
    public static final Event<PlayerLoggedInOrOut> LOGGED_IN = EventFactory.createArrayBacked(PlayerLoggedInOrOut.class, callbacks -> player -> {
        for (PlayerLoggedInOrOut e : callbacks) {
            e.handleConnection(player);
        }
    });
    public static final Event<PlayerLoggedInOrOut> LOGGED_OUT = EventFactory.createArrayBacked(PlayerLoggedInOrOut.class, callbacks -> player -> {
        for (PlayerLoggedInOrOut e : callbacks) {
            e.handleConnection(player);
        }
    });
    private final class_1657 entityPlayer;

    public PlayerEvents(class_1657 player) {
        super((class_1309)player);
        this.entityPlayer = player;
    }

    public class_1657 getPlayer() {
        return this.entityPlayer;
    }

    public class_1657 getEntity() {
        return this.entityPlayer;
    }

    @FunctionalInterface
    public static interface PlayerLoggedInOrOut {
        public void handleConnection(class_1657 var1);
    }

    @FunctionalInterface
    public static interface PlayerXpChange {
        public void onPlayerXpChange(XpChange var1);
    }

    public static class XpChange
    extends PlayerEvents {
        private int amount;

        public XpChange(class_1657 player, int amount) {
            super(player);
            this.amount = amount;
        }

        public int getAmount() {
            return this.amount;
        }

        public void setAmount(int amount) {
            this.amount = amount;
        }

        public void sendEvent() {
            ((PlayerXpChange)XP_CHANGE.invoker()).onPlayerXpChange(this);
        }
    }

    @FunctionalInterface
    public static interface PlayerXpPickUp {
        public void onPlayerPicksUpXp(PickupXp var1);
    }

    public static class PickupXp
    extends PlayerEvents {
        private final class_1303 orb;

        public PickupXp(class_1657 player, class_1303 orb) {
            super(player);
            this.orb = orb;
        }

        public class_1303 getOrb() {
            return this.orb;
        }

        public void sendEvent() {
            ((PlayerXpPickUp)PICKUP_XP.invoker()).onPlayerPicksUpXp(this);
        }
    }

    @FunctionalInterface
    public static interface PlayerBreakSpeed {
        public void setBreakSpeed(BreakSpeed var1);
    }

    public static class BreakSpeed
    extends PlayerEvents {
        private final class_2680 state;
        private final float originalSpeed;
        private float newSpeed = 0.0f;
        private final class_2338 pos;

        public BreakSpeed(class_1657 player, class_2680 state, float original, class_2338 pos) {
            super(player);
            this.state = state;
            this.originalSpeed = original;
            this.setNewSpeed(original);
            this.pos = pos != null ? pos : new class_2338(0, -1, 0);
        }

        public class_2680 getState() {
            return this.state;
        }

        public float getOriginalSpeed() {
            return this.originalSpeed;
        }

        public float getNewSpeed() {
            return this.newSpeed;
        }

        public void setNewSpeed(float newSpeed) {
            this.newSpeed = newSpeed;
        }

        public class_2338 getPos() {
            return this.pos;
        }

        public void sendEvent() {
            ((PlayerBreakSpeed)BREAK_SPEED.invoker()).setBreakSpeed(this);
        }
    }
}

