/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.entity;

import com.mojang.logging.LogUtils;
import io.github.fabricators_of_create.porting_lib.entity.IEntityAdditionalSpawnData;
import io.github.fabricators_of_create.porting_lib.entity.MultiPartEntity;
import io.github.fabricators_of_create.porting_lib.entity.PartEntity;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingAttackEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2960;
import net.minecraft.class_8042;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

public class PortingLibEntity
implements ModInitializer {
    public static final Logger LOGGER = LogUtils.getLogger();

    public void onInitialize() {
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            PartEntity<?>[] parts;
            MultiPartEntity partEntity;
            if (entity instanceof MultiPartEntity && (partEntity = (MultiPartEntity)entity).isMultipartEntity() && (parts = partEntity.getParts()) != null) {
                for (PartEntity<?> part : parts) {
                    world.getPartEntityMap().put(part.method_5628(), part);
                }
            }
        });
        ServerEntityEvents.ENTITY_UNLOAD.register((entity, world) -> {
            PartEntity<?>[] parts;
            MultiPartEntity partEntity;
            if (entity instanceof MultiPartEntity && (partEntity = (MultiPartEntity)entity).isMultipartEntity() && (parts = partEntity.getParts()) != null) {
                for (PartEntity<?> part : parts) {
                    world.getPartEntityMap().remove(part.method_5628());
                }
            }
        });
        ServerEntityEvents.EQUIPMENT_CHANGE.register((livingEntity, equipmentSlot, previousStack, currentStack) -> ((LivingEntityEvents.EquipmentChange)LivingEntityEvents.EQUIPMENT_CHANGE.invoker()).onEquipmentChange(livingEntity, equipmentSlot, previousStack, currentStack));
        LivingEntityEvents.LivingJumpEvent.JUMP.register(event -> ((LivingEntityEvents.Jump)LivingEntityEvents.JUMP.invoker()).onLivingEntityJump(event.getEntity()));
        LivingEntityEvents.LivingVisibilityEvent.VISIBILITY.register(event -> ((LivingEntityEvents.Visibility)LivingEntityEvents.VISIBILITY.invoker()).getEntityVisibilityMultiplier(event.getEntity(), event.getLookingEntity(), event.getVisibilityModifier()));
        LivingEntityEvents.LivingTickEvent.TICK.register(event -> {
            if (!event.isCanceled()) {
                ((LivingEntityEvents.Tick)LivingEntityEvents.TICK.invoker()).onLivingEntityTick(event.getEntity());
            }
        });
        LivingAttackEvent.ATTACK.register(event -> ((LivingEntityEvents.Attack)LivingEntityEvents.ATTACK.invoker()).onAttack(event.getEntity(), event.getSource(), event.getAmount()));
    }

    public static class_2596<class_2602> getEntitySpawningPacket(class_1297 entity) {
        return PortingLibEntity.getEntitySpawningPacket(entity, (class_2596<class_2602>)new class_2604(entity));
    }

    @ApiStatus.Internal
    public static class_2596<class_2602> getEntitySpawningPacket(class_1297 entity, class_2596<class_2602> base) {
        if (entity instanceof IEntityAdditionalSpawnData) {
            IEntityAdditionalSpawnData extra = (IEntityAdditionalSpawnData)entity;
            class_2540 buf = PacketByteBufs.create();
            buf.method_10804(entity.method_5628());
            extra.writeSpawnData(buf);
            class_2596 extraPacket = ServerPlayNetworking.createS2CPacket((class_2960)IEntityAdditionalSpawnData.EXTRA_DATA_PACKET, (class_2540)buf);
            return new class_8042(List.of(base, extraPacket));
        }
        return base;
    }
}

