/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.entity.mixin.common;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import io.github.fabricators_of_create.porting_lib.core.event.BaseEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.CriticalHitEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.EntityInteractCallback;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingAttackEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingDeathEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.PlayerEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.PlayerTickEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.living.LivingDamageEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.living.LivingHurtEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.player.AttackEntityEvent;
import io.github.fabricators_of_create.porting_lib.entity.extensions.PlayerExtension;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class}, priority=500)
public abstract class PlayerMixin
extends class_1309
implements PlayerExtension {
    private final ThreadLocal<class_2338> pl$destroySpeedContext = new ThreadLocal();

    protected PlayerMixin(class_1299<? extends class_1309> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void port_lib$playerStartTickEvent(CallbackInfo ci) {
        ((PlayerTickEvents.Start)PlayerTickEvents.START.invoker()).onStartOfPlayerTick((class_1657)this);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void port_lib$playerEndTickEvent(CallbackInfo ci) {
        ((PlayerTickEvents.End)PlayerTickEvents.END.invoker()).onEndOfPlayerTick((class_1657)this);
    }

    @Inject(method={"interactOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;interact(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;")}, cancellable=true)
    public void port_lib$onEntityInteract(class_1297 entityToInteractOn, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_1269 cancelResult = ((EntityInteractCallback)EntityInteractCallback.EVENT.invoker()).onEntityInteract((class_1657)this, hand, entityToInteractOn);
        if (cancelResult != null) {
            cir.setReturnValue((Object)cancelResult);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void port_lib$attackEvent(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingAttackEvent event = new LivingAttackEvent(this, source, amount);
        event.sendEvent();
        if (event.isCanceled()) {
            cir.setReturnValue((Object)false);
        }
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"), argsOnly=true)
    private float port_lib$onHurt(float amount, class_1282 source, float amount2) {
        return ((LivingEntityEvents.ActuallyHurt)LivingEntityEvents.HURT.invoker()).onHurt(source, this, amount);
    }

    @ModifyVariable(method={"giveExperiencePoints"}, at=@At(value="HEAD"))
    private int port_lib$xpChange(int experience) {
        PlayerEvents.XpChange xpChange = new PlayerEvents.XpChange((class_1657)this, experience);
        xpChange.sendEvent();
        return xpChange.getAmount();
    }

    @ModifyVariable(method={"attack"}, slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;isSprinting()Z", ordinal=1), to=@At(value="CONSTANT", args={"floatValue=1.5F"})), at=@At(value="STORE", opcode=54), index=8)
    private boolean modifyResult(boolean value, @Share(value="original") LocalBooleanRef vanilla) {
        vanilla.set(value);
        return true;
    }

    @ModifyVariable(method={"attack"}, at=@At(value="CONSTANT", args={"floatValue=1.5F"}), index=8)
    private boolean modifyVanillaResult(boolean value, @Share(value="original") LocalBooleanRef vanilla) {
        return vanilla.get();
    }

    @ModifyExpressionValue(method={"attack"}, at={@At(value="CONSTANT", args={"floatValue=1.5F"})})
    private float getCriticalDamageMultiplier(float original, class_1297 target, @Share(value="original") LocalBooleanRef vanilla) {
        boolean vanillaCritical = vanilla.get();
        CriticalHitEvent hitResult = new CriticalHitEvent((class_1657)this, target, original, vanillaCritical);
        hitResult.sendEvent();
        if (hitResult.getResult() == BaseEvent.Result.ALLOW || vanillaCritical && hitResult.getResult() == BaseEvent.Result.DEFAULT) {
            vanilla.set(true);
            return hitResult.getDamageModifier();
        }
        return 1.0f;
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")}, cancellable=true)
    private void playerAttackEntityEvent(class_1297 target, CallbackInfo ci) {
        AttackEntityEvent event = new AttackEntityEvent((class_1657)this, target);
        event.sendEvent();
        if (event.isCanceled()) {
            ci.cancel();
        }
    }

    @Inject(method={"die"}, at={@At(value="HEAD")}, cancellable=true)
    private void onLivingDeath(class_1282 cause, CallbackInfo ci) {
        LivingDeathEvent event = new LivingDeathEvent(this, cause);
        event.sendEvent();
        if (event.isCanceled()) {
            ci.cancel();
        }
    }

    @ModifyVariable(method={"actuallyHurt"}, at=@At(value="LOAD", ordinal=0), index=2)
    private float livingHurtEvent(float value, class_1282 pDamageSource, @Share(value="hurt") LocalRef<LivingHurtEvent> eventRef) {
        LivingHurtEvent event = new LivingHurtEvent(this, pDamageSource, value);
        eventRef.set((Object)event);
        event.sendEvent();
        if (event.isCanceled()) {
            return 0.0f;
        }
        return event.getAmount();
    }

    @Inject(method={"actuallyHurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getDamageAfterArmorAbsorb(Lnet/minecraft/world/damagesource/DamageSource;F)F")}, cancellable=true)
    private void shouldCancelHurt(class_1282 damageSource, float f, CallbackInfo ci, @Share(value="hurt") LocalRef<LivingHurtEvent> eventRef) {
        if (((LivingHurtEvent)((Object)eventRef.get())).getAmount() <= 0.0f) {
            ci.cancel();
        }
    }

    @ModifyVariable(method={"actuallyHurt"}, at=@At(value="LOAD", ordinal=5), index=2)
    private float livingDamageEvent(float value, class_1282 pDamageSource) {
        LivingDamageEvent event = new LivingDamageEvent(this, pDamageSource, value);
        event.sendEvent();
        if (event.isCanceled()) {
            return 0.0f;
        }
        return event.getAmount();
    }

    @Override
    public void setDigSpeedContext(@Nullable class_2338 pos) {
        this.pl$destroySpeedContext.set(pos);
    }

    @ModifyReturnValue(method={"getDestroySpeed"}, at={@At(value="RETURN")})
    private float breakspeedEvent(float original, class_2680 state) {
        PlayerEvents.BreakSpeed breakSpeed = new PlayerEvents.BreakSpeed((class_1657)this, state, original, this.pl$destroySpeedContext.get());
        breakSpeed.sendEvent();
        this.pl$destroySpeedContext.remove();
        return breakSpeed.getNewSpeed();
    }
}

