/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.entity.events;

import com.google.common.base.Preconditions;
import io.github.fabricators_of_create.porting_lib.core.event.BaseEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.PlayerEvents;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerInteractionEvents
extends PlayerEvents {
    public static final Event<PlayerLeftClickBlock> LEFT_CLICK_BLOCK = EventFactory.createArrayBacked(PlayerLeftClickBlock.class, callbacks -> event -> {
        for (PlayerLeftClickBlock e : callbacks) {
            e.onLeftClickBlock(event);
        }
    });
    public static final Event<PlayerLeftClickEmpty> LEFT_CLICK_EMPTY = EventFactory.createArrayBacked(PlayerLeftClickEmpty.class, callbacks -> event -> {
        for (PlayerLeftClickEmpty e : callbacks) {
            e.onLeftClickEmpty(event);
        }
    });
    private final class_1268 hand;
    private final class_2338 pos;
    @Nullable
    private final class_2350 face;
    private class_1269 cancellationResult = class_1269.field_5811;

    private PlayerInteractionEvents(class_1657 player, class_1268 hand, class_2338 pos, @Nullable class_2350 face) {
        super((class_1657)Preconditions.checkNotNull((Object)player, (Object)"Null player in PlayerInteractEvent!"));
        this.hand = (class_1268)Preconditions.checkNotNull((Object)hand, (Object)"Null hand in PlayerInteractEvent!");
        this.pos = (class_2338)Preconditions.checkNotNull((Object)pos, (Object)"Null position in PlayerInteractEvent!");
        this.face = face;
    }

    @NotNull
    public class_1268 getHand() {
        return this.hand;
    }

    @NotNull
    public class_1799 getItemStack() {
        return this.getEntity().method_5998(this.hand);
    }

    @NotNull
    public class_2338 getPos() {
        return this.pos;
    }

    @Nullable
    public class_2350 getFace() {
        return this.face;
    }

    public class_1937 getLevel() {
        return this.getEntity().method_37908();
    }

    public class_1269 getCancellationResult() {
        return this.cancellationResult;
    }

    public void setCancellationResult(class_1269 result) {
        this.cancellationResult = result;
    }

    @FunctionalInterface
    public static interface PlayerLeftClickEmpty {
        public void onLeftClickEmpty(LeftClickEmpty var1);
    }

    public static class LeftClickEmpty
    extends PlayerInteractionEvents {
        public LeftClickEmpty(class_1657 player) {
            super(player, class_1268.field_5808, player.method_24515(), null);
        }

        public void sendEvent() {
            ((PlayerLeftClickEmpty)LEFT_CLICK_EMPTY.invoker()).onLeftClickEmpty(this);
        }
    }

    @FunctionalInterface
    public static interface PlayerLeftClickBlock {
        public void onLeftClickBlock(LeftClickBlock var1);
    }

    public static class LeftClickBlock
    extends PlayerInteractionEvents {
        private BaseEvent.Result useBlock = BaseEvent.Result.DEFAULT;
        private BaseEvent.Result useItem = BaseEvent.Result.DEFAULT;

        public LeftClickBlock(class_1657 player, class_2338 pos, class_2350 face) {
            super(player, class_1268.field_5808, pos, face);
        }

        public BaseEvent.Result getUseBlock() {
            return this.useBlock;
        }

        public BaseEvent.Result getUseItem() {
            return this.useItem;
        }

        public void setUseBlock(BaseEvent.Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(BaseEvent.Result triggerItem) {
            this.useItem = triggerItem;
        }

        public void setCanceled(boolean canceled) {
            super.setCanceled(canceled);
            if (canceled) {
                this.useBlock = BaseEvent.Result.DENY;
                this.useItem = BaseEvent.Result.DENY;
            }
        }

        public void sendEvent() {
            ((PlayerLeftClickBlock)LEFT_CLICK_BLOCK.invoker()).onLeftClickBlock(this);
        }
    }
}

