/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.mojang.logging.LogUtils;
import io.github.fabricators_of_create.porting_lib.config.ConfigEvents;
import io.github.fabricators_of_create.porting_lib.config.ConfigType;
import io.github.fabricators_of_create.porting_lib.config.ModConfig;
import java.nio.file.Path;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ConfigTracker {
    public static final Logger LOGGER = LogUtils.getLogger();
    static final Marker CONFIG = MarkerFactory.getMarker((String)"CONFIG");
    public static final ConfigTracker INSTANCE = new ConfigTracker();
    private final ConcurrentHashMap<String, ModConfig> fileMap = new ConcurrentHashMap();
    private final EnumMap<ConfigType, Set<ModConfig>> configSets = new EnumMap(ConfigType.class);
    private final ConcurrentHashMap<String, Map<ConfigType, ModConfig>> configsByMod = new ConcurrentHashMap();

    private ConfigTracker() {
        this.configSets.put(ConfigType.CLIENT, Collections.synchronizedSet(new LinkedHashSet()));
        this.configSets.put(ConfigType.COMMON, Collections.synchronizedSet(new LinkedHashSet()));
        this.configSets.put(ConfigType.SERVER, Collections.synchronizedSet(new LinkedHashSet()));
    }

    void trackConfig(ModConfig config) {
        if (this.fileMap.containsKey(config.getFileName())) {
            LOGGER.error(CONFIG, "Detected config file conflict {} between {} and {}", new Object[]{config.getFileName(), this.fileMap.get(config.getFileName()).getModId(), config.getModId()});
            throw new RuntimeException("Config conflict detected!");
        }
        this.fileMap.put(config.getFileName(), config);
        this.configSets.get((Object)config.getType()).add(config);
        this.configsByMod.computeIfAbsent(config.getModId(), k -> new EnumMap(ConfigType.class)).put(config.getType(), config);
        LOGGER.debug(CONFIG, "Config file {} for {} tracking", (Object)config.getFileName(), (Object)config.getModId());
    }

    public void loadConfigs(ConfigType type, Path configBasePath) {
        LOGGER.debug(CONFIG, "Loading configs type {}", (Object)type);
        this.configSets.get((Object)type).forEach(config -> this.openConfig((ModConfig)config, configBasePath));
    }

    public void unloadConfigs(ConfigType type, Path configBasePath) {
        LOGGER.debug(CONFIG, "Unloading configs type {}", (Object)type);
        this.configSets.get((Object)type).forEach(config -> this.closeConfig((ModConfig)config, configBasePath));
    }

    private void openConfig(ModConfig config, Path configBasePath) {
        LOGGER.trace(CONFIG, "Loading config file type {} at {} for {}", new Object[]{config.getType(), config.getFileName(), config.getModId()});
        CommentedFileConfig configData = config.reader(configBasePath).apply(config);
        config.setConfigData((CommentedConfig)configData);
        ((ConfigEvents)ConfigEvents.LOADING.invoker()).onModConfigEvent(config);
        config.save();
    }

    private void closeConfig(ModConfig config, Path configBasePath) {
        if (config.getConfigData() != null) {
            LOGGER.trace(CONFIG, "Closing config file type {} at {} for {}", new Object[]{config.getType(), config.getFileName(), config.getModId()});
            config.unload(configBasePath);
            ((ConfigEvents)ConfigEvents.UNLOADING.invoker()).onModConfigEvent(config);
            config.save();
            config.setConfigData(null);
        }
    }

    public void loadDefaultServerConfigs() {
        this.configSets.get((Object)ConfigType.SERVER).forEach(modConfig -> {
            CommentedConfig commentedConfig = CommentedConfig.inMemory();
            modConfig.getSpec().correct(commentedConfig);
            modConfig.setConfigData(commentedConfig);
            ((ConfigEvents)ConfigEvents.LOADING.invoker()).onModConfigEvent((ModConfig)modConfig);
        });
    }

    public String getConfigFileName(String modId, ConfigType type) {
        return Optional.ofNullable(this.configsByMod.getOrDefault(modId, Collections.emptyMap()).getOrDefault((Object)type, null)).map(ModConfig::getFullPath).map(Object::toString).orElse(null);
    }

    public Map<ConfigType, Set<ModConfig>> configSets() {
        return this.configSets;
    }

    public ConcurrentHashMap<String, ModConfig> fileMap() {
        return this.fileMap;
    }
}

