/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.config;

import com.mojang.logging.LogUtils;
import io.github.fabricators_of_create.porting_lib.config.ConfigTracker;
import io.github.fabricators_of_create.porting_lib.config.ConfigType;
import io.github.fabricators_of_create.porting_lib.config.ModConfig;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class PortingLibConfig
implements ModInitializer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_5218 SERVERCONFIG = new class_5218("serverconfig");
    public static final class_2960 CONFIG_SYNC = new class_2960("porting_lib_config", "config_sync");

    private Path getServerConfigPath(MinecraftServer server) {
        Path serverConfig = server.method_27050(SERVERCONFIG);
        PortingLibConfig.getOrCreateDirectory(serverConfig, "serverconfig");
        return serverConfig;
    }

    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> ConfigTracker.INSTANCE.loadConfigs(ConfigType.SERVER, this.getServerConfigPath(server)));
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> ConfigTracker.INSTANCE.unloadConfigs(ConfigType.SERVER, this.getServerConfigPath(server)));
        ServerLoginConnectionEvents.QUERY_START.register((handler, server, sender, synchronizer) -> synchronizer.waitFor((Future)server.method_20493(() -> {
            Map<String, byte[]> configData = ConfigTracker.INSTANCE.configSets().get((Object)ConfigType.SERVER).stream().collect(Collectors.toMap(ModConfig::getFileName, mc -> {
                try {
                    return Files.readAllBytes(mc.getFullPath());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }));
            configData.forEach((key, value) -> {
                class_2540 buf = PacketByteBufs.create();
                buf.method_10814(key);
                buf.method_10813(value);
                sender.sendPacket(CONFIG_SYNC, buf);
            });
        })));
    }

    private static Path getOrCreateDirectory(Path dirPath, String dirLabel) {
        if (!Files.isDirectory(dirPath.getParent(), new LinkOption[0])) {
            PortingLibConfig.getOrCreateDirectory(dirPath.getParent(), "parent of " + dirLabel);
        }
        if (!Files.isDirectory(dirPath, new LinkOption[0])) {
            LOGGER.debug("Making {} directory : {}", (Object)dirLabel, (Object)dirPath);
            try {
                Files.createDirectory(dirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                if (e instanceof FileAlreadyExistsException) {
                    LOGGER.error("Failed to create {} directory - there is a file in the way", (Object)dirLabel);
                } else {
                    LOGGER.error("Problem with creating {} directory (Permissions?)", (Object)dirLabel, (Object)e);
                }
                throw new RuntimeException("Problem creating directory", e);
            }
            LOGGER.debug("Created {} directory : {}", (Object)dirLabel, (Object)dirPath);
        } else {
            LOGGER.debug("Found existing {} directory : {}", (Object)dirLabel, (Object)dirPath);
        }
        return dirPath;
    }
}

