/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.chunk.loading;

import com.mojang.datafixers.util.Pair;
import io.github.fabricators_of_create.porting_lib.chunk.loading.extensions.ForcedChunksSavedDataExtension;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1932;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class PortingLibChunkManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final class_3230<TicketOwner<class_2338>> BLOCK = class_3230.method_14291((String)"forge:block", Comparator.comparing(info -> info));
    private static final class_3230<TicketOwner<class_2338>> BLOCK_TICKING = class_3230.method_14291((String)"forge:block_ticking", Comparator.comparing(info -> info));
    private static final class_3230<TicketOwner<UUID>> ENTITY = class_3230.method_14291((String)"forge:entity", Comparator.comparing(info -> info));
    private static final class_3230<TicketOwner<UUID>> ENTITY_TICKING = class_3230.method_14291((String)"forge:entity_ticking", Comparator.comparing(info -> info));
    private static final Map<String, LoadingValidationCallback> callbacks = new HashMap<String, LoadingValidationCallback>();

    public static void setForcedChunkLoadingCallback(String modId, LoadingValidationCallback callback) {
        if (FabricLoader.getInstance().isModLoaded(modId)) {
            callbacks.put(modId, callback);
        } else {
            LOGGER.warn("A mod attempted to set the forced chunk validation loading callback for an unloaded mod of id: {}", (Object)modId);
        }
    }

    public static boolean hasForcedChunks(class_3218 level) {
        class_1932 data = (class_1932)level.method_17983().method_20786(class_1932::method_32350, "chunks");
        if (data == null) {
            return false;
        }
        return !data.method_8375().isEmpty() || !data.getBlockForcedChunks().isEmpty() || !data.getEntityForcedChunks().isEmpty();
    }

    public static boolean forceChunk(class_3218 level, String modId, class_2338 owner, int chunkX, int chunkZ, boolean add, boolean ticking) {
        return PortingLibChunkManager.forceChunk(level, modId, owner, chunkX, chunkZ, add, ticking, ticking ? BLOCK_TICKING : BLOCK, ForcedChunksSavedDataExtension::getBlockForcedChunks);
    }

    public static boolean forceChunk(class_3218 level, String modId, class_1297 owner, int chunkX, int chunkZ, boolean add, boolean ticking) {
        return PortingLibChunkManager.forceChunk(level, modId, owner.method_5667(), chunkX, chunkZ, add, ticking);
    }

    public static boolean forceChunk(class_3218 level, String modId, UUID owner, int chunkX, int chunkZ, boolean add, boolean ticking) {
        return PortingLibChunkManager.forceChunk(level, modId, owner, chunkX, chunkZ, add, ticking, ticking ? ENTITY_TICKING : ENTITY, ForcedChunksSavedDataExtension::getEntityForcedChunks);
    }

    private static <T extends Comparable<? super T>> boolean forceChunk(class_3218 level, String modId, T owner, int chunkX, int chunkZ, boolean add, boolean ticking, class_3230<TicketOwner<T>> type, Function<class_1932, TicketTracker<T>> ticketGetter) {
        boolean success;
        if (!FabricLoader.getInstance().isModLoaded(modId)) {
            LOGGER.warn("A mod attempted to force a chunk for an unloaded mod of id: {}", (Object)modId);
            return false;
        }
        class_1932 saveData = (class_1932)level.method_17983().method_17924(class_1932::method_32350, class_1932::new, "chunks");
        class_1923 pos = new class_1923(chunkX, chunkZ);
        long chunk = pos.method_8324();
        TicketTracker<T> tickets = ticketGetter.apply(saveData);
        TicketOwner<T> ticketOwner = new TicketOwner<T>(modId, owner);
        if (add) {
            success = tickets.add(ticketOwner, chunk, ticking);
            if (success) {
                level.method_8497(chunkX, chunkZ);
            }
        } else {
            success = tickets.remove(ticketOwner, chunk, ticking);
        }
        if (success) {
            saveData.method_78(true);
            PortingLibChunkManager.forceChunk(level, pos, type, ticketOwner, add, ticking);
        }
        return success;
    }

    private static <T extends Comparable<? super T>> void forceChunk(class_3218 level, class_1923 pos, class_3230<TicketOwner<T>> type, TicketOwner<T> owner, boolean add, boolean ticking) {
        if (add) {
            level.method_14178().addRegionTicket(type, pos, 2, owner, ticking);
        } else {
            level.method_14178().removeRegionTicket(type, pos, 2, owner, ticking);
        }
    }

    public static void reinstatePersistentChunks(class_3218 level, class_1932 saveData) {
        if (!callbacks.isEmpty()) {
            Map blockTickets = PortingLibChunkManager.gatherTicketsByModId(saveData.getBlockForcedChunks());
            Map entityTickets = PortingLibChunkManager.gatherTicketsByModId(saveData.getEntityForcedChunks());
            for (Map.Entry<String, LoadingValidationCallback> entry : callbacks.entrySet()) {
                String modId = entry.getKey();
                boolean hasBlockTicket = blockTickets.containsKey(modId);
                boolean hasEntityTicket = entityTickets.containsKey(modId);
                if (!hasBlockTicket && !hasEntityTicket) continue;
                Map<class_2338, Pair<LongSet, LongSet>> ownedBlockTickets = hasBlockTicket ? Collections.unmodifiableMap(blockTickets.get(modId)) : Collections.emptyMap();
                Map<UUID, Pair<LongSet, LongSet>> ownedEntityTickets = hasEntityTicket ? Collections.unmodifiableMap(entityTickets.get(modId)) : Collections.emptyMap();
                entry.getValue().validateTickets(level, new TicketHelper(saveData, modId, ownedBlockTickets, ownedEntityTickets));
            }
        }
        PortingLibChunkManager.reinstatePersistentChunks(level, BLOCK, saveData.getBlockForcedChunks().chunks, false);
        PortingLibChunkManager.reinstatePersistentChunks(level, BLOCK_TICKING, saveData.getBlockForcedChunks().tickingChunks, true);
        PortingLibChunkManager.reinstatePersistentChunks(level, ENTITY, saveData.getEntityForcedChunks().chunks, false);
        PortingLibChunkManager.reinstatePersistentChunks(level, ENTITY_TICKING, saveData.getEntityForcedChunks().tickingChunks, true);
    }

    private static <T extends Comparable<? super T>> Map<String, Map<T, Pair<LongSet, LongSet>>> gatherTicketsByModId(TicketTracker<T> tickets) {
        HashMap<String, Map<T, Pair<LongSet, LongSet>>> modSortedOwnedChunks = new HashMap<String, Map<T, Pair<LongSet, LongSet>>>();
        PortingLibChunkManager.gatherTicketsByModId(tickets.chunks, Pair::getFirst, modSortedOwnedChunks);
        PortingLibChunkManager.gatherTicketsByModId(tickets.tickingChunks, Pair::getSecond, modSortedOwnedChunks);
        return modSortedOwnedChunks;
    }

    private static <T extends Comparable<? super T>> void gatherTicketsByModId(Map<TicketOwner<T>, LongSet> tickets, Function<Pair<LongSet, LongSet>, LongSet> typeGetter, Map<String, Map<T, Pair<LongSet, LongSet>>> modSortedOwnedChunks) {
        for (Map.Entry<TicketOwner<T>, LongSet> entry : tickets.entrySet()) {
            Pair pair = modSortedOwnedChunks.computeIfAbsent(entry.getKey().modId, modId -> new HashMap()).computeIfAbsent(entry.getKey().owner, owner -> new Pair((Object)new LongOpenHashSet(), (Object)new LongOpenHashSet()));
            typeGetter.apply((Pair<LongSet, LongSet>)pair).addAll((LongCollection)entry.getValue());
        }
    }

    private static <T extends Comparable<? super T>> void reinstatePersistentChunks(class_3218 level, class_3230<TicketOwner<T>> type, Map<TicketOwner<T>, LongSet> tickets, boolean ticking) {
        for (Map.Entry<TicketOwner<T>, LongSet> entry : tickets.entrySet()) {
            LongIterator longIterator = entry.getValue().iterator();
            while (longIterator.hasNext()) {
                long chunk = (Long)longIterator.next();
                PortingLibChunkManager.forceChunk(level, new class_1923(chunk), type, entry.getKey(), true, ticking);
            }
        }
    }

    public static void writeForgeForcedChunks(class_2487 nbt, TicketTracker<class_2338> blockForcedChunks, TicketTracker<UUID> entityForcedChunks) {
        if (!blockForcedChunks.isEmpty() || !entityForcedChunks.isEmpty()) {
            HashMap<String, Long2ObjectMap<class_2487>> forcedEntries = new HashMap<String, Long2ObjectMap<class_2487>>();
            PortingLibChunkManager.writeForcedChunkOwners(forcedEntries, blockForcedChunks, "Blocks", 10, (T pos, class_2499 forcedBlocks) -> forcedBlocks.add((Object)class_2512.method_10692((class_2338)pos)));
            PortingLibChunkManager.writeForcedChunkOwners(forcedEntries, entityForcedChunks, "Entities", 11, (T uuid, class_2499 forcedEntities) -> forcedEntities.add((Object)class_2512.method_25929((UUID)uuid)));
            class_2499 forcedChunks = new class_2499();
            for (Map.Entry entry : forcedEntries.entrySet()) {
                class_2487 forcedEntry = new class_2487();
                forcedEntry.method_10582("Mod", (String)entry.getKey());
                class_2499 modForced = new class_2499();
                modForced.addAll((Collection)((Long2ObjectMap)entry.getValue()).values());
                forcedEntry.method_10566("ModForced", (class_2520)modForced);
                forcedChunks.add((Object)forcedEntry);
            }
            nbt.method_10566("ForgeForced", (class_2520)forcedChunks);
        }
    }

    private static <T extends Comparable<? super T>> void writeForcedChunkOwners(Map<String, Long2ObjectMap<class_2487>> forcedEntries, TicketTracker<T> tracker, String listKey, int listType, BiConsumer<T, class_2499> ownerWriter) {
        PortingLibChunkManager.writeForcedChunkOwners(forcedEntries, tracker.chunks, listKey, listType, ownerWriter);
        PortingLibChunkManager.writeForcedChunkOwners(forcedEntries, tracker.tickingChunks, "Ticking" + listKey, listType, ownerWriter);
    }

    private static <T extends Comparable<? super T>> void writeForcedChunkOwners(Map<String, Long2ObjectMap<class_2487>> forcedEntries, Map<TicketOwner<T>, LongSet> forcedChunks, String listKey, int listType, BiConsumer<T, class_2499> ownerWriter) {
        for (Map.Entry<TicketOwner<T>, LongSet> entry : forcedChunks.entrySet()) {
            Long2ObjectMap modForced = forcedEntries.computeIfAbsent(entry.getKey().modId, modId -> new Long2ObjectOpenHashMap());
            LongIterator longIterator = entry.getValue().iterator();
            while (longIterator.hasNext()) {
                long chunk = (Long)longIterator.next();
                class_2487 modEntry = (class_2487)modForced.computeIfAbsent(chunk, chunkPos -> {
                    class_2487 baseEntry = new class_2487();
                    baseEntry.method_10544("Chunk", chunkPos);
                    return baseEntry;
                });
                class_2499 ownerList = modEntry.method_10554(listKey, listType);
                ownerWriter.accept(entry.getKey().owner, ownerList);
                modEntry.method_10566(listKey, (class_2520)ownerList);
            }
        }
    }

    public static void readForgeForcedChunks(class_2487 nbt, TicketTracker<class_2338> blockForcedChunks, TicketTracker<UUID> entityForcedChunks) {
        class_2499 forcedChunks = nbt.method_10554("ForgeForced", 10);
        for (int i = 0; i < forcedChunks.size(); ++i) {
            class_2487 forcedEntry = forcedChunks.method_10602(i);
            String modId = forcedEntry.method_10558("Mod");
            if (FabricLoader.getInstance().isModLoaded(modId)) {
                class_2499 modForced = forcedEntry.method_10554("ModForced", 10);
                for (int j = 0; j < modForced.size(); ++j) {
                    class_2487 modEntry = modForced.method_10602(j);
                    long chunkPos = modEntry.method_10537("Chunk");
                    PortingLibChunkManager.readBlockForcedChunks(modId, chunkPos, modEntry, "Blocks", blockForcedChunks.chunks);
                    PortingLibChunkManager.readBlockForcedChunks(modId, chunkPos, modEntry, "TickingBlocks", blockForcedChunks.tickingChunks);
                    PortingLibChunkManager.readEntityForcedChunks(modId, chunkPos, modEntry, "Entities", entityForcedChunks.chunks);
                    PortingLibChunkManager.readEntityForcedChunks(modId, chunkPos, modEntry, "TickingEntities", entityForcedChunks.tickingChunks);
                }
                continue;
            }
            LOGGER.warn("Found chunk loading data for mod {} which is currently not available or active - it will be removed from the level save.", (Object)modId);
        }
    }

    private static void readBlockForcedChunks(String modId, long chunkPos, class_2487 modEntry, String key, Map<TicketOwner<class_2338>, LongSet> blockForcedChunks) {
        class_2499 forcedBlocks = modEntry.method_10554(key, 10);
        for (int k = 0; k < forcedBlocks.size(); ++k) {
            blockForcedChunks.computeIfAbsent(new TicketOwner<class_2338>(modId, class_2512.method_10691((class_2487)forcedBlocks.method_10602(k))), owner -> new LongOpenHashSet()).add(chunkPos);
        }
    }

    private static void readEntityForcedChunks(String modId, long chunkPos, class_2487 modEntry, String key, Map<TicketOwner<UUID>, LongSet> entityForcedChunks) {
        class_2499 forcedEntities = modEntry.method_10554(key, 11);
        for (class_2520 uuid : forcedEntities) {
            entityForcedChunks.computeIfAbsent(new TicketOwner<UUID>(modId, class_2512.method_25930((class_2520)uuid)), owner -> new LongOpenHashSet()).add(chunkPos);
        }
    }

    public static class TicketTracker<T extends Comparable<? super T>> {
        private final Map<TicketOwner<T>, LongSet> chunks = new HashMap<TicketOwner<T>, LongSet>();
        private final Map<TicketOwner<T>, LongSet> tickingChunks = new HashMap<TicketOwner<T>, LongSet>();

        public Map<TicketOwner<T>, LongSet> getChunks() {
            return Collections.unmodifiableMap(this.chunks);
        }

        public Map<TicketOwner<T>, LongSet> getTickingChunks() {
            return Collections.unmodifiableMap(this.tickingChunks);
        }

        public boolean isEmpty() {
            return this.chunks.isEmpty() && this.tickingChunks.isEmpty();
        }

        private Map<TicketOwner<T>, LongSet> getTickets(boolean ticking) {
            return ticking ? this.tickingChunks : this.chunks;
        }

        private boolean remove(TicketOwner<T> owner, long chunk, boolean ticking) {
            LongSet ticketChunks;
            Map<TicketOwner<T>, LongSet> tickets = this.getTickets(ticking);
            if (tickets.containsKey(owner) && (ticketChunks = tickets.get(owner)).remove(chunk)) {
                if (ticketChunks.isEmpty()) {
                    tickets.remove(owner);
                }
                return true;
            }
            return false;
        }

        private boolean add(TicketOwner<T> owner, long chunk, boolean ticking) {
            return this.getTickets(ticking).computeIfAbsent(owner, o -> new LongOpenHashSet()).add(chunk);
        }
    }

    public static class TicketOwner<T extends Comparable<? super T>>
    implements Comparable<TicketOwner<T>> {
        private final String modId;
        private final T owner;

        private TicketOwner(String modId, T owner) {
            this.modId = modId;
            this.owner = owner;
        }

        @Override
        public int compareTo(TicketOwner<T> other) {
            int res = this.modId.compareTo(other.modId);
            return res == 0 ? this.owner.compareTo(other.owner) : res;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TicketOwner that = (TicketOwner)o;
            return Objects.equals(this.modId, that.modId) && Objects.equals(this.owner, that.owner);
        }

        public int hashCode() {
            return Objects.hash(this.modId, this.owner);
        }
    }

    @FunctionalInterface
    public static interface LoadingValidationCallback {
        public void validateTickets(class_3218 var1, TicketHelper var2);
    }

    public static class TicketHelper {
        private final Map<class_2338, Pair<LongSet, LongSet>> blockTickets;
        private final Map<UUID, Pair<LongSet, LongSet>> entityTickets;
        private final class_1932 saveData;
        private final String modId;

        private TicketHelper(class_1932 saveData, String modId, Map<class_2338, Pair<LongSet, LongSet>> blockTickets, Map<UUID, Pair<LongSet, LongSet>> entityTickets) {
            this.saveData = saveData;
            this.modId = modId;
            this.blockTickets = blockTickets;
            this.entityTickets = entityTickets;
        }

        public Map<class_2338, Pair<LongSet, LongSet>> getBlockTickets() {
            return this.blockTickets;
        }

        public Map<UUID, Pair<LongSet, LongSet>> getEntityTickets() {
            return this.entityTickets;
        }

        public void removeAllTickets(class_2338 owner) {
            this.removeAllTickets(this.saveData.getBlockForcedChunks(), owner);
        }

        public void removeAllTickets(UUID owner) {
            this.removeAllTickets(this.saveData.getEntityForcedChunks(), owner);
        }

        private <T extends Comparable<? super T>> void removeAllTickets(TicketTracker<T> tickets, T owner) {
            TicketOwner<T> ticketOwner = new TicketOwner<T>(this.modId, owner);
            if (tickets.chunks.containsKey(ticketOwner) || tickets.tickingChunks.containsKey(ticketOwner)) {
                tickets.chunks.remove(ticketOwner);
                tickets.tickingChunks.remove(ticketOwner);
                this.saveData.method_78(true);
            }
        }

        public void removeTicket(class_2338 owner, long chunk, boolean ticking) {
            this.removeTicket(this.saveData.getBlockForcedChunks(), owner, chunk, ticking);
        }

        public void removeTicket(UUID owner, long chunk, boolean ticking) {
            this.removeTicket(this.saveData.getEntityForcedChunks(), owner, chunk, ticking);
        }

        private <T extends Comparable<? super T>> void removeTicket(TicketTracker<T> tickets, T owner, long chunk, boolean ticking) {
            if (tickets.remove(new TicketOwner<T>(this.modId, owner), chunk, ticking)) {
                this.saveData.method_78(true);
            }
        }
    }
}

