/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.minecraft.class_161;
import net.minecraft.class_2444;

public class ConditionalAdvancement {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<ConditionJsonProvider[]> conditions = new ArrayList<ConditionJsonProvider[]>();
        private List<Supplier<JsonElement>> advancements = new ArrayList<Supplier<JsonElement>>();
        private List<ConditionJsonProvider> currentConditions = new ArrayList<ConditionJsonProvider>();
        private boolean locked = false;

        public Builder addCondition(ConditionJsonProvider condition) {
            if (this.locked) {
                throw new IllegalStateException("Attempted to modify finished builder");
            }
            this.currentConditions.add(condition);
            return this;
        }

        public Builder addAdvancement(Consumer<Consumer<class_161.class_162>> callable) {
            if (this.locked) {
                throw new IllegalStateException("Attempted to modify finished builder");
            }
            callable.accept(this::addAdvancement);
            return this;
        }

        public Builder addAdvancement(class_161.class_162 advancement) {
            return this.addAdvancement(() -> ((class_161.class_162)advancement).method_698());
        }

        public Builder addAdvancement(class_2444 fromRecipe) {
            return this.addAdvancement(() -> ((class_2444)fromRecipe).method_10415());
        }

        private Builder addAdvancement(Supplier<JsonElement> jsonSupplier) {
            if (this.locked) {
                throw new IllegalStateException("Attempted to modify finished builder");
            }
            if (this.currentConditions.isEmpty()) {
                throw new IllegalStateException("Can not add a advancement with no conditions.");
            }
            this.conditions.add(this.currentConditions.toArray(new ConditionJsonProvider[this.currentConditions.size()]));
            this.advancements.add(jsonSupplier);
            this.currentConditions.clear();
            return this;
        }

        public JsonObject write() {
            if (!this.locked) {
                if (!this.currentConditions.isEmpty()) {
                    throw new IllegalStateException("Invalid builder state: Orphaned conditions");
                }
                if (this.advancements.isEmpty()) {
                    throw new IllegalStateException("Invalid builder state: No Advancements");
                }
                this.locked = true;
            }
            JsonObject json = new JsonObject();
            JsonArray array = new JsonArray();
            json.add("advancements", (JsonElement)array);
            for (int x = 0; x < this.conditions.size(); ++x) {
                JsonObject holder = new JsonObject();
                JsonArray conds = new JsonArray();
                for (ConditionJsonProvider c : this.conditions.get(x)) {
                    conds.add((JsonElement)c.toJson());
                }
                holder.add("fabric:load_conditions", (JsonElement)conds);
                holder.add("advancement", this.advancements.get(x).get());
                array.add((JsonElement)holder);
            }
            return json;
        }
    }
}

