/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.util.client;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import io.github.fabricators_of_create.porting_lib.item.ArmorTextureItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_572;
import org.jetbrains.annotations.ApiStatus;

public class ClientHooks {
    public static final Map<String, class_2960> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    public static final List<String> MODS_TO_WRAP = new ArrayList<String>();
    @ApiStatus.Internal
    public static class_1921 RENDER_TYPE = null;

    public static String getArmorTexture(class_1297 entity, class_1799 armor, String _default, class_1304 slot, String type) {
        String result = null;
        class_1792 class_17922 = armor.method_7909();
        if (class_17922 instanceof ArmorTextureItem) {
            ArmorTextureItem armorTextureItem = (ArmorTextureItem)class_17922;
            result = armorTextureItem.getArmorTexture(armor, entity, slot, type);
        }
        return result != null ? result : _default;
    }

    public static class_2960 getArmorResource(class_1297 entity, class_1799 stack, class_1304 slot, @Nullable String type) {
        class_1738 item = (class_1738)stack.method_7909();
        String texture = item.method_7686().method_7694();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, slot == class_1304.field_6172 ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
        class_2960 resourcelocation = ARMOR_LOCATION_CACHE.get(s1 = ClientHooks.getArmorTexture(entity, stack, s1, slot, type));
        if (resourcelocation == null) {
            resourcelocation = new class_2960(s1);
            ARMOR_LOCATION_CACHE.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    public static void setPartVisibility(class_572<?> armorModel, class_1304 slot) {
        armorModel.method_2805(false);
        switch (slot) {
            case field_6169: {
                armorModel.field_3398.field_3665 = true;
                armorModel.field_3394.field_3665 = true;
                break;
            }
            case field_6174: {
                armorModel.field_3391.field_3665 = true;
                armorModel.field_3401.field_3665 = true;
                armorModel.field_27433.field_3665 = true;
                break;
            }
            case field_6172: {
                armorModel.field_3391.field_3665 = true;
                armorModel.field_3392.field_3665 = true;
                armorModel.field_3397.field_3665 = true;
                break;
            }
            case field_6166: {
                armorModel.field_3392.field_3665 = true;
                armorModel.field_3397.field_3665 = true;
            }
        }
    }

    public static void wrapModTooltips(String modid) {
        MODS_TO_WRAP.add(modid);
    }

    public static List<class_5684> gatherTooltipComponents(class_1799 stack, List<? extends class_5348> textElements, Optional<class_5632> itemComponent, int mouseX, int screenWidth, int screenHeight, class_327 font) {
        List elements = textElements.stream().map(Either::left).collect(Collectors.toCollection(ArrayList::new));
        itemComponent.ifPresent(c -> elements.add(1, Either.right((Object)c)));
        int tooltipTextWidth = elements.stream().mapToInt(either -> (Integer)either.map(arg_0 -> ((class_327)font).method_27525(arg_0), component -> 0)).max().orElse(0);
        boolean needsWrap = false;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        int tooltipTextWidthF = tooltipTextWidth;
        if (needsWrap) {
            return elements.stream().flatMap(either -> (Stream)either.map(text -> font.method_1728(text, tooltipTextWidthF).stream().map(class_5684::method_32662), component -> Stream.of(class_5684.method_32663((class_5632)component)))).toList();
        }
        return elements.stream().map(either -> (class_5684)either.map(text -> class_5684.method_32662((class_5481)(text instanceof class_2561 ? ((class_2561)text).method_30937() : class_2477.method_10517().method_30934(text))), class_5684::method_32663)).toList();
    }

    public static void setRenderType(class_1921 renderType) {
        RENDER_TYPE = renderType;
    }
}

