/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.asm;

import java.lang.reflect.Modifier;
import java.util.ListIterator;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ASMUtils {
    public static String mapC(String intermediaryName) {
        return FabricLoader.getInstance().getMappingResolver().mapClassName("intermediary", "net.minecraft." + intermediaryName);
    }

    public static String mapM(String name) {
        int firstDot = name.indexOf(46);
        if (firstDot == -1 || firstDot == name.length() - 1) {
            throw new IllegalStateException("Invalid method name: " + name);
        }
        String className = name.substring(0, firstDot);
        String methodAndDescriptor = name.substring(firstDot + 1);
        int openParenthesis = methodAndDescriptor.indexOf(40);
        if (openParenthesis == -1) {
            throw new IllegalStateException("descriptor not found: " + methodAndDescriptor);
        }
        String method = methodAndDescriptor.substring(0, openParenthesis);
        String descriptor = methodAndDescriptor.substring(openParenthesis);
        if (descriptor.contains(".")) {
            throw new IllegalStateException("descriptor should be in slash format");
        }
        return FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft." + className, method, descriptor);
    }

    public static String mapF(String name) {
        int firstDot = name.indexOf(46);
        if (firstDot == -1 || firstDot == name.length() - 1) {
            throw new IllegalStateException("Invalid field name: " + name);
        }
        String className = name.substring(0, firstDot);
        String fieldAndDescriptor = name.substring(firstDot + 1);
        int colon = fieldAndDescriptor.indexOf(58);
        if (colon == -1) {
            throw new IllegalStateException("descriptor not found: " + fieldAndDescriptor);
        }
        String fieldName = fieldAndDescriptor.substring(0, colon);
        String descriptor = fieldAndDescriptor.substring(colon + 1);
        if (descriptor.contains(".")) {
            throw new IllegalStateException("descriptor should be in slash format");
        }
        return FabricLoader.getInstance().getMappingResolver().mapFieldName("intermediary", "net.minecraft." + className, fieldName, descriptor);
    }

    public static AbstractInsnNode findFirstInstruction(MethodNode method, int opCode) {
        return ASMUtils.findFirstInstructionAfter(method, opCode, 0);
    }

    public static AbstractInsnNode findFirstInstructionAfter(MethodNode method, int opCode, int startIndex) {
        for (int i = Math.max(0, startIndex); i < method.instructions.size(); ++i) {
            AbstractInsnNode ain = method.instructions.get(i);
            if (ain.getOpcode() != opCode) continue;
            return ain;
        }
        return null;
    }

    public static AbstractInsnNode findFirstInstructionBefore(MethodNode method, int opCode, int startIndex) {
        for (int i = Math.max(method.instructions.size() - 1, startIndex); i >= 0; --i) {
            AbstractInsnNode ain = method.instructions.get(i);
            if (ain.getOpcode() != opCode) continue;
            return ain;
        }
        return null;
    }

    public static MethodInsnNode findFirstMethodCall(MethodNode method, MethodType type, String owner, String name, String descriptor) {
        return ASMUtils.findFirstMethodCallAfter(method, type, owner, name, descriptor, 0);
    }

    public static MethodInsnNode findFirstMethodCallAfter(MethodNode method, MethodType type, String owner, String name, String descriptor, int startIndex) {
        for (int i = Math.max(0, startIndex); i < method.instructions.size(); ++i) {
            AbstractInsnNode node = method.instructions.get(i);
            if (!(node instanceof MethodInsnNode) || node.getOpcode() != type.toOpcode()) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)node;
            if (!methodInsnNode.owner.equals(owner) || !methodInsnNode.name.equals(name) || !methodInsnNode.desc.equals(descriptor)) continue;
            return methodInsnNode;
        }
        return null;
    }

    public static MethodInsnNode findFirstMethodCallBefore(MethodNode method, MethodType type, String owner, String name, String descriptor, int startIndex) {
        for (int i = Math.min(method.instructions.size() - 1, startIndex); i >= 0; --i) {
            AbstractInsnNode node = method.instructions.get(i);
            if (!(node instanceof MethodInsnNode) || node.getOpcode() != type.toOpcode()) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)node;
            if (!methodInsnNode.owner.equals(owner) || !methodInsnNode.name.equals(name) || !methodInsnNode.desc.equals(descriptor)) continue;
            return methodInsnNode;
        }
        return null;
    }

    public static boolean insertInsnList(MethodNode method, MethodType type, String owner, String name, String desc, InsnList list, InsertMode mode) {
        ListIterator nodeIterator = method.instructions.iterator();
        int opcode = type.toOpcode();
        while (nodeIterator.hasNext()) {
            AbstractInsnNode next = (AbstractInsnNode)nodeIterator.next();
            if (next.getOpcode() != opcode) continue;
            MethodInsnNode castedNode = (MethodInsnNode)next;
            if (!castedNode.owner.equals(owner) || !castedNode.name.equals(name) || !castedNode.desc.equals(desc)) continue;
            if (mode == InsertMode.INSERT_BEFORE) {
                method.instructions.insertBefore(next, list);
            } else {
                method.instructions.insert(next, list);
            }
            if (mode == InsertMode.REMOVE_ORIGINAL) {
                nodeIterator.remove();
            }
            return true;
        }
        return false;
    }

    public static InsnList listOf(AbstractInsnNode ... nodes) {
        InsnList list = new InsnList();
        for (AbstractInsnNode node : nodes) {
            list.add(node);
        }
        return list;
    }

    public static void redirectFieldToMethod(ClassNode classNode, String fieldName, @Nullable String methodName) {
        MethodNode foundMethod = null;
        FieldNode foundField = null;
        for (FieldNode fieldNode : classNode.fields) {
            if (!Objects.equals(fieldNode.name, fieldName)) continue;
            if (foundField == null) {
                foundField = fieldNode;
                continue;
            }
            throw new IllegalStateException("Found multiple fields with name " + fieldName);
        }
        if (foundField == null) {
            throw new IllegalStateException("No field with name " + fieldName + " found");
        }
        if (!Modifier.isPrivate(foundField.access) || Modifier.isStatic(foundField.access)) {
            throw new IllegalStateException("Field " + fieldName + " is not private and an instance field");
        }
        String methodSignature = "()" + foundField.desc;
        for (MethodNode methodNode : classNode.methods) {
            if (!Objects.equals(methodNode.desc, methodSignature)) continue;
            if (foundMethod == null && Objects.equals(methodNode.name, methodName)) {
                foundMethod = methodNode;
                continue;
            }
            if (foundMethod == null && methodName == null) {
                foundMethod = methodNode;
                continue;
            }
            if (foundMethod == null || methodName != null && !Objects.equals(methodNode.name, methodName)) continue;
            throw new IllegalStateException("Found duplicate method with signature " + methodSignature);
        }
        if (foundMethod == null) {
            throw new IllegalStateException("Unable to find method " + methodSignature);
        }
        for (MethodNode methodNode : classNode.methods) {
            if (methodNode == foundMethod || Objects.equals(methodNode.desc, methodSignature)) continue;
            ListIterator iterator = methodNode.instructions.iterator();
            while (iterator.hasNext()) {
                AbstractInsnNode insnNode = (AbstractInsnNode)iterator.next();
                if (insnNode.getOpcode() != 180) continue;
                FieldInsnNode fieldInsnNode = (FieldInsnNode)insnNode;
                if (!Objects.equals(fieldInsnNode.name, fieldName)) continue;
                iterator.remove();
                MethodInsnNode replace = new MethodInsnNode(182, classNode.name, foundMethod.name, foundMethod.desc, false);
                iterator.add(replace);
            }
        }
    }

    public static enum MethodType {
        VIRTUAL,
        SPECIAL,
        STATIC,
        INTERFACE;


        public int toOpcode() {
            return 182 + this.ordinal();
        }
    }

    public static enum InsertMode {
        REMOVE_ORIGINAL,
        INSERT_BEFORE,
        INSERT_AFTER;

    }
}

