/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.virtualentity.api.tracker;

import eu.pb4.polymer.common.impl.entity.InternalEntityHelpers;
import eu.pb4.polymer.virtualentity.api.tracker.DataTrackerLike;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.Nullable;

public final class SimpleDataTracker
implements DataTrackerLike {
    private final Int2ObjectMap<Entry<?>> entries = new Int2ObjectOpenHashMap();
    private boolean dirty;

    public SimpleDataTracker(class_1299<?> baseEntity) {
        Int2ObjectMap entries = InternalEntityHelpers.getExampleTrackedDataOfEntityType(baseEntity);
        for (Int2ObjectMap.Entry x : entries.int2ObjectEntrySet()) {
            this.entries.put(x.getIntKey(), new Entry<Object>(((class_2945.class_2946)x.getValue()).method_12797(), ((class_2945.class_2946)x.getValue()).method_12794()));
        }
    }

    @Override
    public <T> T get(class_2940<T> data) {
        Entry<T> entry = this.getEntry(data);
        return entry != null ? (T)entry.get() : null;
    }

    @Nullable
    private <T> Entry<T> getEntry(class_2940<T> data) {
        Entry x = (Entry)this.entries.get(data.method_12713());
        if (x.data != data) {
            return null;
        }
        return x;
    }

    @Override
    public <T> void set(class_2940<T> key, T value, boolean forceDirty) {
        Entry<T> entry = this.getEntry(key);
        if (entry != null && (forceDirty || ObjectUtils.notEqual(value, entry.get()))) {
            entry.set(value);
            entry.setDirty(true);
            this.dirty = true;
        }
    }

    @Override
    public <T> void setDirty(class_2940<T> key, boolean isDirty) {
        Entry<T> entry = this.getEntry(key);
        if (entry != null) {
            entry.setDirty(isDirty);
            this.dirty |= isDirty;
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    @Nullable
    public List<class_2945.class_7834<?>> getDirtyEntries() {
        ArrayList list = null;
        if (this.dirty) {
            for (Entry entry : this.entries.values()) {
                if (!entry.isDirty()) continue;
                entry.setDirty(false);
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(entry.toSerialized());
            }
        }
        this.dirty = false;
        return list;
    }

    @Override
    @Nullable
    public List<class_2945.class_7834<?>> getChangedEntries() {
        ArrayList list = null;
        for (Entry entry : this.entries.values()) {
            if (entry.isUnchanged()) continue;
            if (list == null) {
                list = new ArrayList();
            }
            list.add(entry.toSerialized());
        }
        return list;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public static class Entry<T> {
        final class_2940<T> data;
        T value;
        private final T initialValue;
        private boolean dirty;

        public Entry(class_2940<T> data, T value) {
            this.data = data;
            this.initialValue = value;
            this.value = value;
        }

        public class_2940<T> getData() {
            return this.data;
        }

        public void set(T value) {
            this.value = value;
        }

        public T get() {
            return this.value;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        public boolean isUnchanged() {
            return this.initialValue.equals(this.value);
        }

        public class_2945.class_7834<T> toSerialized() {
            return class_2945.class_7834.method_46360(this.data, this.value);
        }
    }
}

