/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.virtualentity.api.elements;

import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.elements.AbstractElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import eu.pb4.polymer.virtualentity.api.tracker.DataTrackerLike;
import eu.pb4.polymer.virtualentity.api.tracker.EntityTrackedData;
import eu.pb4.polymer.virtualentity.api.tracker.SimpleDataTracker;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2684;
import net.minecraft.class_2739;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import org.jetbrains.annotations.Nullable;

public abstract class GenericEntityElement
extends AbstractElement {
    protected final DataTrackerLike dataTracker = this.createDataTracker();
    private final int id = VirtualEntityUtils.requestEntityId();
    private final UUID uuid = UUID.randomUUID();
    private float pitch;
    private float yaw;
    private boolean isRotationDirty;

    protected DataTrackerLike createDataTracker() {
        return new SimpleDataTracker(this.getEntityType());
    }

    public boolean isDirty() {
        return this.isRotationDirty || this.dataTracker.isDirty();
    }

    public boolean isRotationDirty() {
        return this.isRotationDirty;
    }

    public void setPitch(float pitch) {
        if (this.pitch != pitch) {
            this.pitch = pitch;
            this.isRotationDirty = true;
        }
    }

    public void setYaw(float yaw) {
        if (this.yaw != yaw) {
            this.yaw = yaw;
            this.isRotationDirty = true;
        }
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    @Override
    public IntList getEntityIds() {
        return IntList.of((int)this.id);
    }

    public final UUID getUuid() {
        return this.uuid;
    }

    public final int getEntityId() {
        return this.id;
    }

    @Override
    public void setOffset(class_243 offset) {
        class_2596<class_2602> x;
        super.setOffset(offset);
        if (this.getHolder() != null && (x = VirtualEntityUtils.createMovePacket(this.id, this.getHolder().getPos().method_1019(this.getOffset()), this.getHolder().getPos().method_1019(offset), false, 0.0f, 0.0f)) != null) {
            this.getHolder().sendPacket(x);
        }
    }

    protected abstract class_1299<? extends class_1297> getEntityType();

    @Override
    public void startWatching(class_3222 player, Consumer<class_2596<class_2602>> packetConsumer) {
        packetConsumer.accept(this.createSpawnPacket(player));
        this.sendChangedTrackerEntries(player, packetConsumer);
    }

    protected class_2596<class_2602> createSpawnPacket(class_3222 player) {
        class_243 pos = this.getHolder().getPos().method_1019(this.getOffset());
        return new class_2604(this.id, this.uuid, pos.field_1352, pos.field_1351, pos.field_1350, this.pitch, this.yaw, this.getEntityType(), 0, class_243.field_1353, (double)this.yaw);
    }

    protected void sendChangedTrackerEntries(class_3222 player, Consumer<class_2596<class_2602>> packetConsumer) {
        List<class_2945.class_7834<?>> changed = this.dataTracker.getChangedEntries();
        if (changed != null) {
            packetConsumer.accept((class_2596<class_2602>)new class_2739(this.id, changed));
        }
    }

    @Override
    public void notifyMove(class_243 oldPos, class_243 newPos, class_243 delta) {
        class_2596<class_2602> x = VirtualEntityUtils.createMovePacket(this.id, oldPos.method_1019(this.getOffset()), newPos.method_1019(this.getOffset()), this.isRotationDirty, this.yaw, this.pitch);
        if (x != null) {
            this.getHolder().sendPacket(x);
        }
        this.isRotationDirty = false;
    }

    @Override
    public void stopWatching(class_3222 player, Consumer<class_2596<class_2602>> packetConsumer) {
    }

    @Override
    public void tick() {
        this.sendTrackerUpdates();
        this.sendRotationUpdates();
    }

    protected void sendTrackerUpdates() {
        List<class_2945.class_7834<?>> dirty;
        if (this.dataTracker.isDirty() && (dirty = this.dataTracker.getDirtyEntries()) != null) {
            this.getHolder().sendPacket((class_2596<class_2602>)new class_2739(this.id, dirty));
        }
    }

    protected void sendRotationUpdates() {
        if (this.isRotationDirty) {
            int i = class_3532.method_15375((float)(this.yaw * 256.0f / 360.0f));
            int j = class_3532.method_15375((float)(this.pitch * 256.0f / 360.0f));
            this.getHolder().sendPacket((class_2596<class_2602>)new class_2684.class_2687(this.id, (byte)i, (byte)j, false));
            this.isRotationDirty = false;
        }
    }

    public DataTrackerLike getDataTracker() {
        return this.dataTracker;
    }

    public class_4050 getPose() {
        return this.dataTracker.get(EntityTrackedData.POSE);
    }

    public void setPose(class_4050 pose) {
        this.dataTracker.set(EntityTrackedData.POSE, pose);
    }

    public void setOnFire(boolean onFire) {
        this.setFlag(EntityTrackedData.ON_FIRE_FLAG_INDEX, onFire);
    }

    protected boolean getFlag(int index) {
        return (this.dataTracker.get(EntityTrackedData.FLAGS) & 1 << index) != 0;
    }

    protected void setFlag(int index, boolean value) {
        byte b = this.dataTracker.get(EntityTrackedData.FLAGS);
        if (value) {
            this.dataTracker.set(EntityTrackedData.FLAGS, (byte)(b | 1 << index));
        } else {
            this.dataTracker.set(EntityTrackedData.FLAGS, (byte)(b & ~(1 << index)));
        }
    }

    public boolean isSneaking() {
        return this.getFlag(EntityTrackedData.SNEAKING_FLAG_INDEX);
    }

    public void setSneaking(boolean sneaking) {
        this.setFlag(EntityTrackedData.SNEAKING_FLAG_INDEX, sneaking);
    }

    public boolean isSprinting() {
        return this.getFlag(EntityTrackedData.SPRINTING_FLAG_INDEX);
    }

    public void setSprinting(boolean sprinting) {
        this.setFlag(EntityTrackedData.SPRINTING_FLAG_INDEX, sprinting);
    }

    public boolean isGlowing() {
        return this.getFlag(EntityTrackedData.GLOWING_FLAG_INDEX);
    }

    public final void setGlowing(boolean glowing) {
        this.setFlag(EntityTrackedData.GLOWING_FLAG_INDEX, glowing);
    }

    public boolean isInvisible() {
        return this.getFlag(EntityTrackedData.INVISIBLE_FLAG_INDEX);
    }

    public void setInvisible(boolean invisible) {
        this.setFlag(EntityTrackedData.INVISIBLE_FLAG_INDEX, invisible);
    }

    public int getAir() {
        return this.dataTracker.get(EntityTrackedData.AIR);
    }

    public void setAir(int air) {
        this.dataTracker.set(EntityTrackedData.AIR, air);
    }

    public int getFrozenTicks() {
        return this.dataTracker.get(EntityTrackedData.FROZEN_TICKS);
    }

    public void setFrozenTicks(int frozenTicks) {
        this.dataTracker.set(EntityTrackedData.FROZEN_TICKS, frozenTicks);
    }

    @Nullable
    public class_2561 getCustomName() {
        return this.dataTracker.get(EntityTrackedData.CUSTOM_NAME).orElse(null);
    }

    public void setCustomName(@Nullable class_2561 name) {
        this.dataTracker.set(EntityTrackedData.CUSTOM_NAME, Optional.ofNullable(name));
    }

    public boolean isCustomNameVisible() {
        return Boolean.TRUE == this.dataTracker.get(EntityTrackedData.NAME_VISIBLE);
    }

    public void setCustomNameVisible(boolean visible) {
        this.dataTracker.set(EntityTrackedData.NAME_VISIBLE, visible);
    }

    public boolean isSilent() {
        return Boolean.TRUE == this.dataTracker.get(EntityTrackedData.SILENT);
    }

    public void setSilent(boolean silent) {
        this.dataTracker.set(EntityTrackedData.SILENT, silent);
    }

    public boolean hasNoGravity() {
        return Boolean.TRUE == this.dataTracker.get(EntityTrackedData.NO_GRAVITY);
    }

    public void setNoGravity(boolean noGravity) {
        this.dataTracker.set(EntityTrackedData.NO_GRAVITY, noGravity);
    }

    @Override
    public VirtualElement.InteractionHandler getInteractionHandler(class_3222 player) {
        return VirtualElement.InteractionHandler.EMPTY;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.uuid);
    }
}

