/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.virtualentity.api.elements;

import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.elements.AbstractElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import eu.pb4.polymer.virtualentity.mixin.accessors.EntityTrackerEntryAccessor;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2716;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import org.jetbrains.annotations.Nullable;

public class EntityElement<T extends class_1297>
extends AbstractElement {
    private final T entity;
    private final class_3231 entry;

    public EntityElement(T entity, class_3218 world) {
        this(entity, world, VirtualElement.InteractionHandler.EMPTY);
    }

    public EntityElement(T entity, class_3218 world, VirtualElement.InteractionHandler handler) {
        this.entity = entity;
        this.entry = new class_3231(world, this.entity, 1, false, this::sendPacket);
        this.setInteractionHandler(handler);
    }

    private void sendPacket(class_2596<?> packet) {
        if (this.getHolder() != null) {
            this.getHolder().sendPacket(packet);
        }
    }

    public EntityElement(class_1299<T> entityType, class_3218 world) {
        this(entityType.method_5883((class_1937)world), world);
    }

    public EntityElement(class_1299<T> entityType, class_3218 world, VirtualElement.InteractionHandler handler) {
        this(entityType.method_5883((class_1937)world), world);
    }

    public T entity() {
        return this.entity;
    }

    @Override
    public IntList getEntityIds() {
        return IntList.of((int)this.entity.method_5628());
    }

    @Override
    public void setHolder(@Nullable ElementHolder holder) {
        super.setHolder(holder);
        if (holder != null) {
            class_243 pos = holder.getPos().method_1019(this.getOffset());
            this.entity.method_23327(pos.field_1352, pos.field_1351, pos.field_1350);
        }
    }

    @Override
    public void setOffset(class_243 vec3d) {
        super.setOffset(vec3d);
        if (this.getHolder() != null) {
            class_243 pos = this.getHolder().getPos().method_1019(vec3d);
            this.entity.method_23327(pos.field_1352, pos.field_1351, pos.field_1350);
        }
    }

    @Override
    public void startWatching(class_3222 player, Consumer<class_2596<class_2602>> packetConsumer) {
        this.entry.method_18757(player, packetConsumer);
    }

    @Override
    public void stopWatching(class_3222 player, Consumer<class_2596<class_2602>> packetConsumer) {
        packetConsumer.accept((class_2596<class_2602>)new class_2716(new int[]{this.entity.method_5628()}));
    }

    @Override
    public void notifyMove(class_243 oldPos, class_243 currentPos, class_243 delta) {
        if (this.getHolder() != null) {
            class_243 pos = currentPos.method_1019(this.getOffset());
            this.entity.method_23327(pos.field_1352, pos.field_1351, pos.field_1350);
        }
    }

    @Override
    public void setInitialPosition(class_243 pos) {
        pos = pos.method_1019(this.getOffset());
        this.entity.method_33574(pos);
        ((EntityTrackerEntryAccessor)this.entry).getTrackedPos().method_43494(pos);
    }

    @Override
    public void tick() {
        this.entry.method_18756();
    }
}

