/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.virtualentity.api.attachment;

import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.ManualAttachment;
import eu.pb4.polymer.virtualentity.impl.HolderAttachmentHolder;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;

public class ChunkAttachment
implements HolderAttachment {
    private final ElementHolder holder;
    private final class_2818 chunk;
    private final class_243 pos;
    private final boolean autoTick;

    public ChunkAttachment(ElementHolder holder, class_2818 chunk, class_243 position, boolean autoTick) {
        this.chunk = chunk;
        this.pos = position;
        this.holder = holder;
        this.attach();
        this.autoTick = autoTick;
    }

    protected void attach() {
        ((HolderAttachmentHolder)this.chunk).polymerVE$addHolder(this);
        this.holder.setAttachment(this);
    }

    public static HolderAttachment of(ElementHolder holder, class_3218 world, class_2338 pos) {
        return ChunkAttachment.of(holder, world, class_243.method_24953((class_2382)pos));
    }

    public static HolderAttachment ofTicking(ElementHolder holder, class_3218 world, class_2338 pos) {
        return ChunkAttachment.ofTicking(holder, world, class_243.method_24953((class_2382)pos));
    }

    public static HolderAttachment of(ElementHolder holder, class_3218 world, class_243 pos) {
        class_2791 chunk = world.method_22350(class_2338.method_49638((class_2374)pos));
        if (chunk instanceof class_2818) {
            class_2818 chunk1 = (class_2818)chunk;
            return new ChunkAttachment(holder, chunk1, pos, false);
        }
        CommonImpl.LOGGER.warn("Some mod tried to attach to chunk at " + class_2338.method_49638((class_2374)pos).method_23854() + ", but it isn't loaded!", (Throwable)new NullPointerException());
        return new ManualAttachment(holder, world, () -> pos);
    }

    public static HolderAttachment ofTicking(ElementHolder holder, class_3218 world, class_243 pos) {
        class_2791 chunk = world.method_22350(class_2338.method_49638((class_2374)pos));
        if (chunk instanceof class_2818) {
            class_2818 chunk1 = (class_2818)chunk;
            return new ChunkAttachment(holder, chunk1, pos, true);
        }
        CommonImpl.LOGGER.warn("Some mod tried to attach to chunk at " + class_2338.method_49638((class_2374)pos).method_23854() + ", but it isn't loaded!", (Throwable)new NullPointerException());
        return new ManualAttachment(holder, world, () -> pos);
    }

    @Override
    public ElementHolder holder() {
        return this.holder;
    }

    @Override
    public void destroy() {
        if (this.holder.getAttachment() == this) {
            this.holder.setAttachment(null);
        }
        ((HolderAttachmentHolder)this.chunk).polymerVE$removeHolder(this);
    }

    @Override
    public void tick() {
        if (this.autoTick) {
            this.holder().tick();
        }
    }

    @Override
    public boolean shouldTick() {
        return this.autoTick;
    }

    @Override
    public void updateCurrentlyTracking(Collection<class_3244> currentlyTracking) {
        ArrayList<class_3244> watching = new ArrayList<class_3244>();
        for (class_3222 class_32222 : ((class_3215)this.chunk.method_12200().method_8398()).field_17254.method_17210(this.chunk.method_12004(), false)) {
            class_3244 networkHandler = class_32222.field_13987;
            watching.add(networkHandler);
        }
        for (class_3244 class_32442 : currentlyTracking) {
            if (watching.contains(class_32442)) continue;
            this.holder.stopWatching(class_32442);
        }
        for (class_3244 class_32443 : watching) {
            this.holder.startWatching(class_32443.method_32311().field_13987);
        }
    }

    @Override
    public void updateTracking(class_3244 tracking) {
        if (tracking.field_14140.method_29504() || !VirtualEntityUtils.isPlayerTracking(tracking.method_32311(), this.chunk)) {
            VirtualEntityUtils.wrapCallWithContext(this.getWorld(), () -> this.stopWatching(tracking));
        }
    }

    @Override
    public class_243 getPos() {
        return this.pos;
    }

    @Override
    public class_3218 getWorld() {
        return (class_3218)this.chunk.method_12200();
    }
}

