/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.virtualentity.api.attachment;

import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.ChunkAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.impl.HolderAttachmentHolder;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class BlockBoundAttachment
extends ChunkAttachment {
    public static final HolderAttachment.UpdateType BLOCK_STATE_UPDATE = HolderAttachment.UpdateType.of("BlockState");
    private final class_2338 blockPos;
    private class_2680 blockState;

    @ApiStatus.Internal
    public BlockBoundAttachment(ElementHolder holder, class_2818 chunk, class_2680 state, class_2338 blockPos, class_243 position, boolean autoTick) {
        super(holder, chunk, position, autoTick);
        this.blockPos = blockPos;
        this.blockState = state;
        this.attach();
    }

    @Override
    protected void attach() {
        if (this.blockPos != null) {
            super.attach();
        }
    }

    public class_2338 getBlockPos() {
        return this.blockPos;
    }

    @ApiStatus.Internal
    public void setBlockState(class_2680 blockState) {
        this.blockState = blockState;
        if (this == this.holder().getAttachment()) {
            this.holder().notifyUpdate(BLOCK_STATE_UPDATE);
        }
    }

    public class_2680 getBlockState() {
        return this.blockState;
    }

    @Nullable
    public static BlockBoundAttachment get(class_1937 world, class_2338 pos) {
        BlockBoundAttachment blockBoundAttachment;
        class_2791 chunk = world.method_22350(pos);
        if (chunk instanceof class_2818) {
            class_2818 worldChunk = (class_2818)chunk;
            blockBoundAttachment = BlockBoundAttachment.get(worldChunk, pos);
        } else {
            blockBoundAttachment = null;
        }
        return blockBoundAttachment;
    }

    @Nullable
    public static BlockBoundAttachment get(class_2818 chunk, class_2338 pos) {
        return ((HolderAttachmentHolder)chunk).polymerVE$getPosHolder(pos);
    }

    @Nullable
    public static BlockBoundAttachment get(ElementHolder holder) {
        BlockBoundAttachment blockBoundAttachment;
        HolderAttachment holderAttachment = holder.getAttachment();
        return holderAttachment instanceof BlockBoundAttachment ? (blockBoundAttachment = (BlockBoundAttachment)holderAttachment) : null;
    }
}

