/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.virtualentity.api;

import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.virtualentity.impl.EntityExt;
import eu.pb4.polymer.virtualentity.impl.VirtualEntityImplUtils;
import eu.pb4.polymer.virtualentity.impl.compat.ImmersivePortalsUtils;
import eu.pb4.polymer.virtualentity.mixin.EntityPassengersSetS2CPacketAccessor;
import eu.pb4.polymer.virtualentity.mixin.accessors.EntityAccessor;
import eu.pb4.polymer.virtualentity.mixin.accessors.EntityPositionS2CPacketAccessor;
import eu.pb4.polymer.virtualentity.mixin.accessors.ThreadedAnvilChunkStorageAccessor;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2684;
import net.minecraft.class_2752;
import net.minecraft.class_2777;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3898;
import net.minecraft.class_4076;
import org.jetbrains.annotations.Nullable;

public final class VirtualEntityUtils {
    private VirtualEntityUtils() {
    }

    public static int requestEntityId() {
        return EntityAccessor.getCURRENT_ID().incrementAndGet();
    }

    public static void addVirtualPassenger(class_1297 entity, int passengerId) {
        ((EntityExt)entity).polymerVE$getVirtualRidden().add(passengerId);
        ((EntityExt)entity).polymerVE$markVirtualRiddenDirty();
    }

    public static void addVirtualPassenger(class_1297 entity, int ... passengerId) {
        for (int i : passengerId) {
            ((EntityExt)entity).polymerVE$getVirtualRidden().add(i);
        }
        ((EntityExt)entity).polymerVE$markVirtualRiddenDirty();
    }

    public static void removeVirtualPassenger(class_1297 entity, int passengerId) {
        ((EntityExt)entity).polymerVE$getVirtualRidden().removeInt(passengerId);
        ((EntityExt)entity).polymerVE$markVirtualRiddenDirty();
    }

    public static void removeVirtualPassenger(class_1297 entity, int ... passengerId) {
        for (int i : passengerId) {
            ((EntityExt)entity).polymerVE$getVirtualRidden().removeInt(i);
        }
        ((EntityExt)entity).polymerVE$markVirtualRiddenDirty();
    }

    @Nullable
    public static class_2596<class_2602> createMovePacket(int id, class_243 oldPos, class_243 newPos, boolean rotate, float yaw, float pitch) {
        boolean bl5;
        int i = class_3532.method_15375((float)(yaw * 256.0f / 360.0f));
        int j = class_3532.method_15375((float)(pitch * 256.0f / 360.0f));
        boolean bl2 = oldPos.method_1020(newPos).method_1027() >= 7.62939453125E-6;
        long l = Math.round(newPos.field_1352 * 4096.0);
        long m = Math.round(newPos.field_1351 * 4096.0);
        long n = Math.round(newPos.field_1350 * 4096.0);
        boolean bl = bl5 = l < -32768L || l > 32767L || m < -32768L || m > 32767L || n < -32768L || n > 32767L;
        if (!bl5) {
            if (!bl2 || !rotate) {
                if (bl2) {
                    return new class_2684.class_2685(id, (short)l, (short)m, (short)n, false);
                }
                if (rotate) {
                    return new class_2684.class_2687(id, (byte)i, (byte)j, false);
                }
            } else {
                return new class_2684.class_2686(id, (short)l, (short)m, (short)n, (byte)i, (byte)j, false);
            }
            return null;
        }
        return VirtualEntityUtils.createSimpleMovePacket(id, newPos, (byte)i, (byte)j);
    }

    public static class_2596<class_2602> createSimpleMovePacket(int id, class_243 newPos, byte yaw, byte pitch) {
        class_2777 packet = VirtualEntityImplUtils.createUnsafe(class_2777.class);
        EntityPositionS2CPacketAccessor accessor = (EntityPositionS2CPacketAccessor)packet;
        accessor.setId(id);
        accessor.setX(newPos.field_1352);
        accessor.setY(newPos.field_1351);
        accessor.setZ(newPos.field_1350);
        accessor.setOnGround(false);
        accessor.setPitch(pitch);
        accessor.setYaw(yaw);
        return packet;
    }

    public static class_2752 createRidePacket(int id, IntList list) {
        return VirtualEntityUtils.createRidePacket(id, list.toIntArray());
    }

    public static class_2752 createRidePacket(int id, int[] list) {
        class_2752 packet = VirtualEntityImplUtils.createUnsafe(class_2752.class);
        ((EntityPassengersSetS2CPacketAccessor)packet).setId(id);
        ((EntityPassengersSetS2CPacketAccessor)packet).setPassengerIds(list);
        return packet;
    }

    public static boolean isPlayerTracking(class_3222 player, class_2818 chunk) {
        if (CompatStatus.IMMERSIVE_PORTALS) {
            return ImmersivePortalsUtils.isPlayerTracking(player, chunk);
        }
        if (player.method_37908() != chunk.method_12200()) {
            return false;
        }
        class_3898 tacs = ((class_3218)chunk.method_12200()).method_14178().field_17254;
        class_4076 section = player.method_14232();
        return class_3898.method_39975((int)chunk.method_12004().field_9181, (int)chunk.method_12004().field_9180, (int)section.method_10263(), (int)section.method_10260(), (int)((ThreadedAnvilChunkStorageAccessor)tacs).getWatchDistance());
    }

    public static void wrapCallWithContext(class_3218 world, Runnable call) {
        if (CompatStatus.IMMERSIVE_PORTALS) {
            ImmersivePortalsUtils.callRedirected(world, call);
        } else {
            call.run();
        }
    }
}

