/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.resourcepack.mixin.compat.polymc;

import eu.pb4.polymer.resourcepack.api.PolymerArmorModel;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import io.github.theepicblock.polymc.api.resource.ModdedResources;
import io.github.theepicblock.polymc.api.resource.PolyMcResourcePack;
import io.github.theepicblock.polymc.api.resource.TextureAsset;
import io.github.theepicblock.polymc.impl.misc.logging.SimpleLogger;
import io.github.theepicblock.polymc.impl.poly.item.ArmorColorManager;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import net.minecraft.class_1741;
import net.minecraft.class_2960;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;

@Pseudo
@Mixin(value={ArmorColorManager.class}, remap=false)
public class polymc_ArmorColorManagerMixin {
    @Shadow
    @Final
    private Object2IntArrayMap<class_1741> material2Color;

    @Overwrite
    public void addToResourcePack(ModdedResources moddedResources, PolyMcResourcePack pack, SimpleLogger logger) {
        if (this.material2Color.isEmpty()) {
            return;
        }
        for (int layer = 1; layer <= 2; ++layer) {
            for (class_1741 material : this.material2Color.keySet()) {
                try {
                    String texturePath = "models/armor/" + material.method_7694() + "_layer_" + layer;
                    TextureAsset texture = moddedResources.getTexture("minecraft", texturePath);
                    if (texture == null) {
                        logger.warn("Couldn't find armor texture for " + material.method_7694() + ", it won't display correctly when worn");
                        continue;
                    }
                    BufferedImage moddedImage = ImageIO.read(texture.getTexture());
                    if (moddedImage == null) {
                        logger.warn("Couldn't read layer " + layer + " armor texture for " + material.method_7694());
                        continue;
                    }
                    pack.setTexture("minecraft", texturePath, moddedResources.getTexture("minecraft", texturePath));
                }
                catch (Throwable e) {
                    logger.error("Couldn't read armor texture " + material.method_7694() + " (layer #" + layer + ")");
                    e.printStackTrace();
                }
            }
        }
    }

    @Overwrite
    public boolean hasColor(int c) {
        return PolymerResourcePackUtils.isColorTaken(c);
    }

    @Overwrite
    public int getColorForMaterial(class_1741 material) {
        if (!this.material2Color.containsKey((Object)material)) {
            PolymerArmorModel color = PolymerResourcePackUtils.requestArmor(new class_2960("minecraft", material.method_7694()));
            this.material2Color.put((Object)material, color.color());
        }
        return this.material2Color.getInt((Object)material);
    }
}

