/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.resourcepack.impl.generation;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.common.api.events.SimpleEvent;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.api.PolymerArmorModel;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import eu.pb4.polymer.resourcepack.impl.ArmorTextureMetadata;
import eu.pb4.polymer.resourcepack.impl.generation.InternalRPBuilder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DefaultRPBuilder
implements InternalRPBuilder {
    public static final Gson GSON = CommonImpl.GSON;
    public final SimpleEvent<Consumer<List<String>>> buildEvent = new SimpleEvent();
    private final Map<class_1792, JsonArray[]> customModels = new HashMap<class_1792, JsonArray[]>();
    private final TreeMap<String, byte[]> fileMap = new TreeMap();
    private final List<PolymerArmorModel> armors = new ArrayList<PolymerArmorModel>();
    private final Path outputPath;
    private final List<ModContainer> modsList = new ArrayList<ModContainer>();
    private final Map<class_2960, List<PolymerModelData>> customModelData = new HashMap<class_2960, List<PolymerModelData>>();
    private FileSystem clientJar = null;
    private final Map<String, JsonArray> atlasDefinitions = new HashMap<String, JsonArray>();

    public DefaultRPBuilder(Path outputPath) {
        outputPath.getParent().toFile().mkdirs();
        this.outputPath = outputPath;
        try {
            if (outputPath.toFile().exists()) {
                Files.deleteIfExists(outputPath);
            }
        }
        catch (Exception e) {
            CommonImpl.LOGGER.warn("Couldn't remove " + outputPath + " file!");
            e.printStackTrace();
        }
    }

    private static Path getSelfPath(String path) {
        return ((ModContainer)FabricLoader.getInstance().getModContainer("polymer-resource-pack").get()).getPath(path);
    }

    @Override
    public boolean addData(String path, byte[] data) {
        try {
            String[] split;
            if (path.endsWith(".json") && (split = path.split("/")).length > 3 && split[0].equals("assets") && split[2].equals("atlases")) {
                return this.addAtlasFile(path, data);
            }
            this.fileMap.put(path, data);
            return true;
        }
        catch (Exception e) {
            CommonImpl.LOGGER.error("Something went wrong while adding raw data to path: " + path);
            e.printStackTrace();
            return false;
        }
    }

    private boolean addAtlasFile(String path, byte[] data) {
        try {
            JsonElement decode = JsonParser.parseString((String)new String(data, StandardCharsets.UTF_8));
            if (decode instanceof JsonObject) {
                JsonObject obj = (JsonObject)decode;
                JsonArray list = obj.getAsJsonArray("sources");
                this.atlasDefinitions.computeIfAbsent(path, x -> new JsonArray()).addAll(list);
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean copyFromPath(Path basePath, boolean override) {
        try {
            if (Files.isSymbolicLink(basePath)) {
                basePath = Files.readSymbolicLink(basePath);
            }
            if (Files.isDirectory(basePath, new LinkOption[0])) {
                Path finalBasePath = basePath;
                Files.walk(basePath, new FileVisitOption[0]).forEach(file -> {
                    Path relative = finalBasePath.relativize((Path)file);
                    String path = relative.toString().replace("\\", "/");
                    if ((override || !this.fileMap.containsKey(path)) && Files.isRegularFile(file, new LinkOption[0])) {
                        try {
                            this.addData(path, Files.readAllBytes(file));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
                return true;
            }
            if (Files.isRegularFile(basePath, new LinkOption[0])) {
                try (FileSystem fs = FileSystems.newFileSystem(basePath, Collections.emptyMap());){
                    fs.getRootDirectories().forEach(this::copyFromPath);
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            CommonImpl.LOGGER.error("Something went wrong while copying data from: " + basePath);
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean copyAssets(String modId) {
        Optional mod = FabricLoader.getInstance().getModContainer(modId);
        if (mod.isPresent()) {
            ModContainer container = (ModContainer)mod.get();
            this.modsList.add(container);
            try {
                for (Path rootPaths : container.getRootPaths()) {
                    Path assets = rootPaths.resolve("assets");
                    if (!Files.exists(assets, new LinkOption[0])) continue;
                    Files.walk(assets, new FileVisitOption[0]).forEach(file -> {
                        Path relative = assets.relativize((Path)file);
                        String path = relative.toString().replace("\\", "/");
                        if (Files.isRegularFile(file, new LinkOption[0])) {
                            try {
                                this.addData("assets/" + path, Files.readAllBytes(file));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                return true;
            }
            catch (Exception e) {
                CommonImpl.LOGGER.error("Something went wrong while copying assets of mod: " + modId);
                e.printStackTrace();
                return false;
            }
        }
        CommonImpl.LOGGER.warn("Tried to copy assets from non existing mod " + modId);
        return false;
    }

    @Override
    public boolean addCustomModelData(PolymerModelData cmdInfo) {
        try {
            JsonArray jsonArray = this.getCustomModels(cmdInfo.item(), OverridePlace.CUSTOM_MODEL_DATA);
            this.customModelData.computeIfAbsent(class_7923.field_41178.method_10221((Object)cmdInfo.item()), x -> new ArrayList()).add(cmdInfo);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("model", CommonImplUtils.shortId((class_2960)cmdInfo.modelPath()));
            JsonObject predicateObject = new JsonObject();
            predicateObject.addProperty("custom_model_data", (Number)cmdInfo.value());
            jsonObject.add("predicate", (JsonElement)predicateObject);
            jsonArray.add((JsonElement)jsonObject);
            JsonObject modelObject = null;
            String modelPath = AssetPaths.model(cmdInfo.modelPath().method_12836(), cmdInfo.modelPath().method_12832() + ".json");
            if (this.fileMap.containsKey(modelPath)) {
                modelObject = JsonParser.parseString((String)new String(this.fileMap.get(modelPath), StandardCharsets.UTF_8)).getAsJsonObject();
            }
            if (modelObject != null && modelObject.has("overrides")) {
                JsonArray array = modelObject.getAsJsonArray("overrides");
                for (JsonElement element : array) {
                    JsonObject jsonObject2 = element.getAsJsonObject();
                    jsonObject2.get("predicate").getAsJsonObject().addProperty("custom_model_data", (Number)cmdInfo.value());
                    jsonArray.add((JsonElement)jsonObject2);
                }
            }
            return true;
        }
        catch (Exception e) {
            CommonImpl.LOGGER.error(String.format("Something went wrong while adding custom model data (%s) of %s for model %s", cmdInfo.value(), class_7923.field_41178.method_10221((Object)cmdInfo.item()), cmdInfo.modelPath().toString()));
            e.printStackTrace();
            return false;
        }
    }

    public JsonArray getCustomModels(class_1792 item, OverridePlace place) {
        JsonArray json;
        if (!this.customModels.containsKey(item)) {
            JsonArray[] places = new JsonArray[OverridePlace.values().length];
            this.customModels.put(item, places);
        }
        if ((json = this.customModels.get(item)[place.ordinal()]) == null) {
            this.customModels.get((Object)item)[place.ordinal()] = json = new JsonArray();
        }
        return json;
    }

    @Override
    public boolean addArmorModel(PolymerArmorModel armorModel) {
        return this.armors.add(armorModel);
    }

    @Override
    public byte[] getData(String path) {
        return this.fileMap.get(path);
    }

    @Override
    @Nullable
    public byte[] getDataOrVanilla(String path) {
        if (this.fileMap.containsKey(path)) {
            return this.fileMap.get(path);
        }
        return this.getVanillaData(path);
    }

    @Nullable
    private byte[] getVanillaData(String path) {
        try {
            InputStream stream = this.getVanillaStream(path);
            if (stream != null) {
                return stream.readAllBytes();
            }
        }
        catch (Throwable e) {
            CommonImpl.LOGGER.warn("Error occurred while getting data from vanilla jar!", e);
        }
        return null;
    }

    @Nullable
    private InputStream getVanillaStream(String path) {
        try {
            Path entry;
            if (this.clientJar == null) {
                this.clientJar = FileSystems.newFileSystem(PolymerCommonUtils.getClientJar());
            }
            if (Files.exists(entry = this.clientJar.getPath(path, new String[0]), new LinkOption[0])) {
                return Files.newInputStream(entry, new OpenOption[0]);
            }
        }
        catch (Exception e) {
            CommonImpl.LOGGER.warn("Error occurred while getting data from vanilla jar!", (Throwable)e);
        }
        return null;
    }

    @Override
    public CompletableFuture<Boolean> buildResourcePack() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                void var6_30;
                ArrayList<Object> credits = new ArrayList<Object>();
                credits.add("");
                credits.add("  +-----------+");
                credits.add("  |           |");
                credits.add("  |   #   #   |");
                credits.add("  |           |");
                credits.add("  |   #   #   |");
                credits.add("  |    ###    |");
                credits.add("  |           |");
                credits.add("  |           |");
                credits.add("  +-----------+");
                credits.add("");
                credits.add("Generated with Polymer " + CommonImpl.VERSION);
                credits.add("");
                credits.add("Vanilla assets by Mojang Studios");
                credits.add("");
                credits.add("Used mod assets: ");
                for (ModContainer entry : this.modsList) {
                    credits.add(" - " + entry.getMetadata().getName() + " (" + entry.getMetadata().getId() + ")");
                }
                credits.add("");
                this.buildEvent.invoke(c -> c.accept(credits));
                boolean bool = true;
                JsonObject jsonObject = new JsonObject();
                ArrayList<Map.Entry<class_2960, List<PolymerModelData>>> arrayList = new ArrayList<Map.Entry<class_2960, List<PolymerModelData>>>(this.customModelData.entrySet());
                arrayList.sort(Comparator.comparing(e -> (class_2960)e.getKey()));
                for (Map.Entry<class_2960, List<PolymerModelData>> entry : arrayList) {
                    JsonObject jsonObject2 = new JsonObject();
                    for (PolymerModelData polymerModelData : entry.getValue()) {
                        jsonObject2.addProperty(CommonImplUtils.shortId((class_2960)polymerModelData.modelPath()), (Number)polymerModelData.value());
                    }
                    jsonObject.add(CommonImplUtils.shortId((class_2960)entry.getKey()), (JsonElement)jsonObject2);
                }
                this.fileMap.put("assets/polymer/items.json", GSON.toJson((JsonElement)jsonObject).getBytes(StandardCharsets.UTF_8));
                for (class_1792 class_17922 : this.customModels.keySet()) {
                    class_2960 id = class_7923.field_41178.method_10221((Object)class_17922);
                    try {
                        class_2960 itemId = class_7923.field_41178.method_10221((Object)class_17922);
                        String baseModelPath = "assets/" + itemId.method_12836() + "/models/item/" + itemId.method_12832() + ".json";
                        JsonObject jsonObject2 = JsonParser.parseString((String)new String(this.getDataOrVanilla(baseModelPath), StandardCharsets.UTF_8)).getAsJsonObject();
                        if (jsonObject2.has("overrides")) {
                            this.getCustomModels(class_17922, OverridePlace.EXISTING).addAll(jsonObject2.getAsJsonArray("overrides"));
                        }
                        JsonArray jsonArray = new JsonArray();
                        for (JsonArray models : this.customModels.get(class_17922)) {
                            if (models == null) continue;
                            jsonArray.addAll(models);
                        }
                        jsonObject2.add("overrides", (JsonElement)jsonArray);
                        this.fileMap.put(baseModelPath, jsonObject2.toString().getBytes(StandardCharsets.UTF_8));
                    }
                    catch (Exception exception) {
                        CommonImpl.LOGGER.error("Something went wrong while saving model of " + id);
                        exception.printStackTrace();
                        bool = false;
                    }
                }
                for (Map.Entry entry : this.atlasDefinitions.entrySet()) {
                    JsonObject obj = new JsonObject();
                    obj.add("sources", (JsonElement)entry.getValue());
                    this.fileMap.put((String)entry.getKey(), obj.toString().getBytes(StandardCharsets.UTF_8));
                }
                if (this.armors.size() > 0) {
                    int n;
                    int i;
                    credits.add("Armor texture support is based on https://github.com/Ancientkingg/fancyPants");
                    credits.add("");
                    ArrayList<ArmorData> list = new ArrayList<ArmorData>();
                    boolean bl = true;
                    HashMap<Integer, String> armorDataMap = new HashMap<Integer, String>();
                    for (PolymerArmorModel entry : this.armors) {
                        armorDataMap.put(entry.color(), CommonImplUtils.shortId((class_2960)entry.modelPath()));
                        try {
                            BufferedImage[] images = new BufferedImage[2];
                            ArmorTextureMetadata[] armorTextureMetadataArray = new ArmorTextureMetadata[2];
                            for (i = 0; i <= 1; ++i) {
                                BufferedImage bi = null;
                                Object path = "assets/" + entry.modelPath().method_12836() + "/textures/models/armor/" + entry.modelPath().method_12832() + "_layer_" + (i + 1) + ".png";
                                byte[] data = this.fileMap.get(path);
                                if (data == null) {
                                    try {
                                        InputStream stream = this.getVanillaStream((String)path);
                                        if (stream != null) {
                                            bi = ImageIO.read(stream);
                                        }
                                    }
                                    catch (Exception stream) {}
                                } else {
                                    bi = ImageIO.read(new ByteArrayInputStream(data));
                                }
                                images[i] = bi;
                                path = AssetPaths.armorTexturePolymerMetadata(entry.modelPath(), i + 1);
                                data = this.fileMap.get(path);
                                if (data != null) {
                                    int finalI = i;
                                    ArmorTextureMetadata.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)new String(data))).result().ifPresentOrElse(r -> {
                                        metadata[finalI] = (ArmorTextureMetadata)r.getFirst();
                                    }, () -> {
                                        metadata[finalI] = ArmorTextureMetadata.DEFAULT;
                                    });
                                } else {
                                    armorTextureMetadataArray[i] = ArmorTextureMetadata.DEFAULT;
                                }
                                double scaleTest1 = (double)n / (double)armorTextureMetadataArray[i].scale();
                                if (scaleTest1 == Math.floor(scaleTest1)) continue;
                                double scaleTest2 = (double)armorTextureMetadataArray[i].scale() / (double)n;
                                if (scaleTest2 != Math.floor(scaleTest2)) {
                                    n *= armorTextureMetadataArray[i].scale();
                                    continue;
                                }
                                n = armorTextureMetadataArray[i].scale();
                            }
                            list.add(new ArmorData(entry.modelPath(), entry.color(), images, armorTextureMetadataArray));
                        }
                        catch (Throwable e3) {
                            CommonImpl.LOGGER.error("Error occurred when creating " + entry.modelPath() + " armor texture!");
                            e3.printStackTrace();
                        }
                    }
                    list.sort(Comparator.comparing(e -> -e.color()));
                    this.fileMap.put("assets/polymer/armors.json", GSON.toJson(armorDataMap).getBytes(StandardCharsets.UTF_8));
                    this.fileMap.put(AssetPaths.armorTexture(this.vId("vanilla_leather"), 1), this.getVanillaData(AssetPaths.armorTexture(new class_2960("leather"), 1)));
                    this.fileMap.put(AssetPaths.armorOverlayTexture(this.vId("vanilla_leather"), 1), this.getVanillaData(AssetPaths.armorOverlayTexture(this.vId("leather"), 1)));
                    this.fileMap.put(AssetPaths.armorTexture(this.vId("vanilla_leather"), 2), this.getVanillaData(AssetPaths.armorTexture(new class_2960("leather"), 2)));
                    this.fileMap.put(AssetPaths.armorOverlayTexture(this.vId("vanilla_leather"), 2), this.getVanillaData(AssetPaths.armorOverlayTexture(this.vId("leather"), 2)));
                    int[] nArray = new int[]{64 * n, 64 * n};
                    int[] height = new int[]{32 * n, 32 * n};
                    for (ArmorData armorData : new ArrayList(list)) {
                        for (i = 0; i <= 1; ++i) {
                            BufferedImage image = armorData.images()[i];
                            ArmorTextureMetadata metadata = armorData.metadata()[i];
                            if (image == null) continue;
                            int scale = n / metadata.scale();
                            int newHeight = image.getHeight() * scale;
                            int newWidth = image.getWidth() * scale;
                            double check = (double)newWidth / (double)(64 * n);
                            if (check != Math.floor(check)) {
                                CommonImpl.LOGGER.warn("Invalid texture size for armor " + armorData.identifier() + " (" + i + ")! Skipping...");
                                list.remove(armorData);
                                continue;
                            }
                            height[i] = Math.max(height[i], newHeight);
                            int n2 = i;
                            nArray[n2] = nArray[n2] + newWidth;
                        }
                    }
                    BufferedImage[] image = new BufferedImage[]{new BufferedImage(nArray[0], height[0], 2), new BufferedImage(nArray[1], height[1], 2)};
                    int[] nArray2 = new int[]{64 * n, 64 * n};
                    Graphics[] graphics = new Graphics[]{image[0].getGraphics(), image[1].getGraphics()};
                    try {
                        for (int i2 = 0; i2 <= 1; ++i2) {
                            BufferedImage tex = ImageIO.read(this.getVanillaStream(AssetPaths.armorTexture(this.vId("leather"), i2 + 1)));
                            graphics[i2].drawImage(tex, 0, 0, tex.getWidth() * n, tex.getHeight() * n, null);
                            tex = ImageIO.read(this.getVanillaStream(AssetPaths.armorOverlayTexture(this.vId("leather"), i2 + 1)));
                            graphics[i2].drawImage(tex, 0, 0, tex.getWidth() * n, tex.getHeight() * n, null);
                            graphics[i2].setColor(Color.WHITE);
                            graphics[i2].drawRect(0, 1, 0, 0);
                        }
                        for (ArmorData entry : list) {
                            for (int i3 = 0; i3 <= 1; ++i3) {
                                ArmorTextureMetadata metadata = entry.metadata()[i3];
                                int scale = n / metadata.scale();
                                BufferedImage tmpImage = entry.images()[i3];
                                if (tmpImage == null) continue;
                                graphics[i3].drawImage(tmpImage, nArray2[i3], 0, tmpImage.getWidth() * scale, tmpImage.getHeight() * scale, null);
                                graphics[i3].setColor(new Color(entry.color() | 0xFF000000));
                                graphics[i3].drawRect(nArray2[i3], 0, 0, 0);
                                if (metadata.frames() != 0 && metadata.animationSpeed() != 0 || metadata.interpolate()) {
                                    graphics[i3].setColor(new Color(metadata.frames(), metadata.animationSpeed(), metadata.interpolate() ? 1 : 0));
                                    graphics[i3].drawRect(nArray2[i3] + 1, 0, 0, 0);
                                }
                                if (metadata.emissivity() != 0) {
                                    graphics[i3].setColor(new Color(metadata.emissivity(), 0, 0));
                                    graphics[i3].drawRect(nArray2[i3] + 2, 0, 0, 0);
                                }
                                int n3 = i3;
                                nArray2[n3] = nArray2[n3] + tmpImage.getWidth() * scale;
                            }
                        }
                        for (int i4 = 0; i4 <= 1; ++i4) {
                            graphics[i4].dispose();
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            ImageIO.write((RenderedImage)image[i4], "png", out);
                            this.fileMap.put(AssetPaths.armorTexture(this.vId("leather"), i4 + 1), out.toByteArray());
                            out = new ByteArrayOutputStream();
                            ImageIO.write((RenderedImage)new BufferedImage(1, 1, 2), "png", out);
                            this.fileMap.put(AssetPaths.armorOverlayTexture(this.vId("leather"), i4 + 1), out.toByteArray());
                        }
                    }
                    catch (Throwable e4) {
                        CommonImpl.LOGGER.error("Error occurred when creating armor texture!");
                        e4.printStackTrace();
                    }
                    for (String string : new String[]{"fsh", "json", "vsh"}) {
                        this.fileMap.put("assets/minecraft/shaders/core/rendertype_armor_cutout_no_cull." + string, Files.readString(DefaultRPBuilder.getSelfPath("base-armor/rendertype_armor_cutout_no_cull." + string)).replace("${polymer_texture_resolution}", "" + 16 * n).getBytes(StandardCharsets.UTF_8));
                    }
                }
                if (!this.fileMap.containsKey(AssetPaths.PACK_METADATA)) {
                    this.fileMap.put(AssetPaths.PACK_METADATA, "{\n   \"pack\":{\n      \"pack_format\":15,\n      \"description\":\"Server resource pack\"\n   }\n}\n".getBytes(StandardCharsets.UTF_8));
                }
                if (!this.fileMap.containsKey(AssetPaths.PACK_ICON)) {
                    Path filePath = FabricLoader.getInstance().getGameDir().resolve("server-icon.png");
                    if (filePath.toFile().exists()) {
                        this.fileMap.put(AssetPaths.PACK_ICON, Files.readAllBytes(filePath));
                    } else {
                        this.fileMap.put(AssetPaths.PACK_ICON, Files.readAllBytes(DefaultRPBuilder.getSelfPath("assets/icon.png")));
                    }
                }
                this.fileMap.put("polymer-about.txt", String.join((CharSequence)"\n", credits).getBytes(StandardCharsets.UTF_8));
                Object outputStream = new ZipOutputStream(new FileOutputStream(this.outputPath.toFile()));
                String[] stringArray = this.fileMap.keySet().toArray(new String[0]);
                int n = stringArray.length;
                boolean bl = false;
                while (var6_30 < n) {
                    String path = stringArray[var6_30];
                    ArrayList<String> split = new ArrayList<String>(List.of(path.split("/")));
                    while (split.size() > 1) {
                        split.remove(split.size() - 1);
                        this.fileMap.put(String.join((CharSequence)"/", split) + "/", null);
                    }
                    ++var6_30;
                }
                ArrayList<Map.Entry<String, byte[]>> arrayList2 = new ArrayList<Map.Entry<String, byte[]>>(this.fileMap.entrySet());
                arrayList2.sort(Comparator.comparing(e -> (String)e.getKey()));
                for (Map.Entry<String, byte[]> entry : arrayList2) {
                    ZipEntry zipEntry = new ZipEntry(entry.getKey());
                    zipEntry.setTime(0L);
                    ((ZipOutputStream)outputStream).putNextEntry(zipEntry);
                    byte[] value = entry.getValue();
                    if (value != null) {
                        ((FilterOutputStream)outputStream).write(entry.getValue());
                    }
                    ((ZipOutputStream)outputStream).closeEntry();
                }
                ((ZipOutputStream)outputStream).close();
                outputStream = bool;
                return outputStream;
            }
            catch (Exception e5) {
                CommonImpl.LOGGER.error("Something went wrong while creating resource pack!");
                e5.printStackTrace();
                Boolean bl = false;
                return bl;
            }
            finally {
                if (this.clientJar != null) {
                    try {
                        this.clientJar.close();
                    }
                    catch (Throwable e6) {
                        e6.printStackTrace();
                    }
                }
            }
        });
    }

    private class_2960 vId(String path) {
        return new class_2960(path);
    }

    public static enum OverridePlace {
        BEFORE_EXISTING,
        EXISTING,
        BEFORE_CUSTOM_MODEL_DATA,
        CUSTOM_MODEL_DATA,
        END;

    }

    private record ArmorData(class_2960 identifier, int color, BufferedImage[] images, ArmorTextureMetadata[] metadata) {
    }
}

