/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.resourcepack.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.pb4.polymer.common.api.events.SimpleEvent;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.resourcepack.api.PolymerArmorModel;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.polymer.resourcepack.api.model.ItemOverride;
import eu.pb4.polymer.resourcepack.impl.generation.DefaultRPBuilder;
import eu.pb4.polymer.resourcepack.impl.generation.PolymerArmorModelImpl;
import eu.pb4.polymer.resourcepack.impl.generation.PolymerModelDataImpl;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class ResourcePackCreator {
    public final SimpleEvent<Consumer<ResourcePackBuilder>> creationEvent = new SimpleEvent();
    public final SimpleEvent<Runnable> finishedEvent = new SimpleEvent();
    public final SimpleEvent<Consumer<ResourcePackBuilder>> afterInitialCreationEvent = new SimpleEvent();
    private final Map<class_1792, List<PolymerModelData>> items = new Object2ObjectOpenCustomHashMap(class_156.method_655());
    private final Object2IntMap<class_1792> itemIds = new Object2IntOpenCustomHashMap(class_156.method_655());
    private final Map<class_1792, Map<class_2960, PolymerModelData>> itemModels = new Object2ObjectOpenCustomHashMap(class_156.method_655());
    private final Map<class_1792, List<ItemOverride>> itemOverrides = new Object2ObjectOpenCustomHashMap(class_156.method_655());
    private final Set<String> modIds = new HashSet<String>();
    private final IntSet takenArmorColors = new IntOpenHashSet();
    private final Map<class_2960, PolymerArmorModel> armorModelMap = new HashMap<class_2960, PolymerArmorModel>();
    private final int cmdOffset;
    private int armorColor = 0;
    private class_2561 packDescription = null;
    private byte[] packIcon = null;
    private Set<Path> sourcePaths = new HashSet<Path>();

    public static ResourcePackCreator create() {
        return new ResourcePackCreator(0);
    }

    protected ResourcePackCreator(int cmdOffset) {
        this.cmdOffset = cmdOffset;
        this.itemIds.defaultReturnValue(1);
    }

    public PolymerModelData requestModel(class_1792 vanillaItem, class_2960 modelPath) {
        Map map = this.itemModels.computeIfAbsent(vanillaItem, x -> new Object2ObjectOpenHashMap());
        if (map.containsKey(modelPath)) {
            return (PolymerModelData)map.get(modelPath);
        }
        return this.forceDefineModel(vanillaItem, this.itemIds.getInt((Object)vanillaItem), modelPath, true);
    }

    public void defineOverride(class_1792 item, ItemOverride override) {
        this.itemOverrides.computeIfAbsent(item, x -> new ArrayList()).add(override);
    }

    @ApiStatus.Experimental
    public PolymerModelData forceDefineModel(class_1792 vanillaItem, int customModelData, class_2960 modelPath, boolean respectOffset) {
        Map map = this.itemModels.computeIfAbsent(vanillaItem, x -> new Object2ObjectOpenHashMap());
        List cmdInfoList = this.items.computeIfAbsent(vanillaItem, x -> new ArrayList());
        PolymerModelDataImpl cmdInfo = new PolymerModelDataImpl(vanillaItem, customModelData + (respectOffset ? this.cmdOffset : 0), modelPath);
        cmdInfoList.add(cmdInfo);
        this.itemIds.put((Object)vanillaItem, Math.max(this.itemIds.getInt((Object)vanillaItem), customModelData + 1));
        map.put(modelPath, cmdInfo);
        return cmdInfo;
    }

    public PolymerArmorModel requestArmor(class_2960 modelPath) {
        if (this.armorModelMap.containsKey(modelPath)) {
            return this.armorModelMap.get(modelPath);
        }
        ++this.armorColor;
        int color = 0xFFFFFF - this.armorColor * 2 + 1;
        PolymerArmorModelImpl model = new PolymerArmorModelImpl(color, modelPath);
        this.armorModelMap.put(modelPath, model);
        this.takenArmorColors.add(color);
        return model;
    }

    public boolean addAssetSource(String modId) {
        if (CommonImpl.isModLoaded((String)modId)) {
            this.modIds.add(modId);
            return true;
        }
        return false;
    }

    public boolean addAssetSource(Path sourcePath) {
        return this.sourcePaths.add(sourcePath);
    }

    public boolean isColorTaken(int color) {
        return this.takenArmorColors.contains(color & 0xFFFFFF);
    }

    public List<PolymerModelData> getModelsFor(class_1792 item) {
        return Collections.unmodifiableList(this.items.getOrDefault(item, Collections.emptyList()));
    }

    public void setPackDescription(String description) {
        this.packDescription = class_2561.method_43470((String)description);
    }

    public void setPackDescription(class_2561 description) {
        this.packDescription = description;
    }

    @Nullable
    public class_2561 getPackDescription() {
        return this.packDescription;
    }

    public void setPackIcon(byte[] packIcon) {
        this.packIcon = packIcon;
    }

    @Nullable
    public byte[] getPackIcon() {
        return this.packIcon;
    }

    public boolean isEmpty() {
        return this.items.isEmpty() && this.modIds.isEmpty() && this.armorModelMap.isEmpty() && this.creationEvent.isEmpty();
    }

    public boolean build(Path output) throws ExecutionException, InterruptedException {
        return this.build(output, s -> {});
    }

    public boolean build(Path output, Consumer<String> status) throws ExecutionException, InterruptedException {
        boolean successful = true;
        DefaultRPBuilder builder = new DefaultRPBuilder(output);
        status.accept("action:created_builder");
        if (this.packDescription != null) {
            JsonObject obj = new JsonObject();
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("pack_format", (Number)15);
            jsonObject.add("description", class_2561.class_2562.method_10868((class_2561)this.packDescription));
            obj.add("pack", (JsonElement)jsonObject);
            builder.addData("pack.mcmeta", obj.toString().getBytes(StandardCharsets.UTF_8));
        }
        if (this.packIcon != null) {
            builder.addData("pack.png", this.packIcon);
        }
        status.accept("action:creation_event_start");
        this.creationEvent.invoke(x -> x.accept(builder));
        status.accept("action:creation_event_finish");
        for (Path path : this.sourcePaths) {
            status.accept("action:copy_path_start/" + path);
            successful = builder.copyFromPath(path) && successful;
            status.accept("action:copy_path_end/" + path);
        }
        for (String string : this.modIds) {
            status.accept("action:copy_mod_start/" + string);
            successful = builder.copyAssets(string) && successful;
            status.accept("action:copy_mod_end/" + string);
        }
        status.accept("action:copy_overrides_start");
        for (Map.Entry entry : this.itemOverrides.entrySet()) {
            JsonArray x2 = builder.getCustomModels((class_1792)entry.getKey(), DefaultRPBuilder.OverridePlace.BEFORE_CUSTOM_MODEL_DATA);
            ((List)entry.getValue()).forEach(a -> x2.add((JsonElement)a.toJson()));
        }
        status.accept("action:copy_overrides_finish");
        for (List list : this.items.values()) {
            status.accept("action:custom_model_data_start");
            for (PolymerModelData cmdInfo : list) {
                builder.addCustomModelData(cmdInfo);
            }
            status.accept("action:add_custom_model_data_finish");
        }
        status.accept("action:custom_armors_start");
        for (PolymerArmorModel polymerArmorModel : this.armorModelMap.values()) {
            builder.addArmorModel(polymerArmorModel);
        }
        status.accept("action:custom_armors_finish");
        status.accept("action:late_creation_event_start");
        this.afterInitialCreationEvent.invoke(x -> x.accept(builder));
        status.accept("action:late_creation_event_finish");
        status.accept("action:build");
        successful = builder.buildResourcePack().get() != false && successful;
        status.accept("action:done");
        this.finishedEvent.invoke(Runnable::run);
        return successful;
    }
}

