/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.resourcepack.api;

import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.common.api.events.SimpleEvent;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.common.impl.CommonResourcePackInfoHolder;
import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.resourcepack.api.PolymerArmorModel;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.polymer.resourcepack.api.ResourcePackCreator;
import eu.pb4.polymer.resourcepack.impl.PolymerResourcePackImpl;
import eu.pb4.polymer.resourcepack.impl.compat.polymc.PolyMcHelpers;
import eu.pb4.polymer.resourcepack.impl.generation.DefaultRPBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public final class PolymerResourcePackUtils {
    public static final Path DEFAULT_PATH = FabricLoader.getInstance().getGameDir().resolve("polymer-resourcepack.zip").toAbsolutePath().normalize();
    private static final ResourcePackCreator INSTANCE = new ResourcePackCreator(PolymerResourcePackImpl.USE_OFFSET ? PolymerResourcePackImpl.OFFSET_VALUES : 1);
    public static final SimpleEvent<Consumer<ResourcePackBuilder>> RESOURCE_PACK_CREATION_EVENT = PolymerResourcePackUtils.INSTANCE.creationEvent;
    public static final SimpleEvent<Consumer<ResourcePackBuilder>> RESOURCE_PACK_AFTER_INITIAL_CREATION_EVENT = PolymerResourcePackUtils.INSTANCE.afterInitialCreationEvent;
    public static final SimpleEvent<Runnable> RESOURCE_PACK_FINISHED_EVENT = PolymerResourcePackUtils.INSTANCE.finishedEvent;
    private static boolean REQUIRED = PolymerResourcePackImpl.FORCE_REQUIRE;
    private static boolean DEFAULT_CHECK = true;

    private PolymerResourcePackUtils() {
    }

    public static PolymerModelData requestModel(class_1792 vanillaItem, class_2960 modelPath) {
        return INSTANCE.requestModel(vanillaItem, modelPath);
    }

    public static PolymerArmorModel requestArmor(class_2960 modelPath) {
        return INSTANCE.requestArmor(modelPath);
    }

    public static boolean addModAssets(String modId) {
        return INSTANCE.addAssetSource(modId);
    }

    public static boolean hasResources() {
        return !INSTANCE.isEmpty();
    }

    public static void markAsRequired() {
        REQUIRED = true;
    }

    public static boolean isRequired() {
        return REQUIRED;
    }

    public static boolean hasPack(@Nullable class_3222 player) {
        return PolymerCommonUtils.hasResourcePack((class_3222)player);
    }

    public static void setPlayerStatus(class_3222 player, boolean status) {
        ((CommonResourcePackInfoHolder)player).polymerCommon$setResourcePack(status);
        if (player.field_13987 != null) {
            ((CommonResourcePackInfoHolder)player.field_13987).polymerCommon$setResourcePack(status);
        }
    }

    public static boolean isColorTaken(int color) {
        return INSTANCE.isColorTaken(color);
    }

    public static List<PolymerModelData> getModelsFor(class_1792 item) {
        return INSTANCE.getModelsFor(item);
    }

    public static void disableDefaultCheck() {
        DEFAULT_CHECK = false;
        CommonImplUtils.disableResourcePackCheck = true;
    }

    public static boolean shouldCheckByDefault() {
        return DEFAULT_CHECK;
    }

    public static void ignoreNextDefaultCheck(class_3222 player) {
        ((CommonResourcePackInfoHolder)player.field_13987).polymerCommon$setIgnoreNextResourcePack();
    }

    public static ResourcePackBuilder createBuilder(Path output) {
        return new DefaultRPBuilder(output);
    }

    public static boolean build() {
        return PolymerResourcePackUtils.build(DEFAULT_PATH);
    }

    public static boolean build(Path output) {
        return PolymerResourcePackUtils.build(output, s -> {});
    }

    public static boolean build(Path output, Consumer<String> status) {
        try {
            return INSTANCE.build(output, status);
        }
        catch (Exception e) {
            CommonImpl.LOGGER.error("Couldn't create resource pack!");
            e.printStackTrace();
            return false;
        }
    }

    public static ResourcePackCreator getInstance() {
        return INSTANCE;
    }

    static {
        PolymerResourcePackUtils.INSTANCE.creationEvent.register(builder -> {
            Path path = CommonImpl.getGameDir().resolve("polymer/source_assets");
            if (Files.isDirectory(path, new LinkOption[0])) {
                builder.copyFromPath(path);
            }
            if (CompatStatus.POLYMC) {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                    PolyMcHelpers.importPolyMcResources(builder);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        PolymerResourcePackUtils.INSTANCE.afterInitialCreationEvent.register(builder -> {
            Path path = CommonImpl.getGameDir().resolve("polymer/override_assets");
            if (Files.isDirectory(path, new LinkOption[0])) {
                builder.copyFromPath(path);
            }
        });
    }
}

