/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.networking.impl.client;

import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.networking.api.PolymerServerNetworking;
import eu.pb4.polymer.networking.api.client.PolymerClientNetworking;
import eu.pb4.polymer.networking.api.client.PolymerClientPacketHandler;
import eu.pb4.polymer.networking.impl.ClientPackets;
import eu.pb4.polymer.networking.impl.ServerPacketRegistry;
import eu.pb4.polymer.networking.impl.ServerPackets;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ClientPacketRegistry {
    public static final HashMap<class_2960, PolymerClientPacketHandler> PACKETS = new HashMap();
    public static final Object2IntMap<class_2960> CLIENT_PROTOCOL = new Object2IntOpenHashMap();
    public static final Map<class_2960, class_2520> SERVER_METADATA = new HashMap<class_2960, class_2520>();
    public static final Map<class_2960, class_2520> METADATA = new HashMap<class_2960, class_2520>();
    public static String lastVersion;

    public static boolean handle(class_634 handler, class_2658 packet) {
        boolean versionRead = false;
        int version = -1;
        class_2960 identifier = packet.method_11456();
        PolymerClientPacketHandler packetHandler = PACKETS.get(identifier);
        if (packetHandler != null) {
            class_2540 buf = packet.method_11458();
            try {
                version = buf.method_10816();
                versionRead = true;
                packetHandler.onPacket(handler, version, buf);
                return true;
            }
            catch (Throwable e) {
                CommonImpl.LOGGER.error(String.format("Invalid %s (%s) packet received from server!", identifier, versionRead ? Integer.valueOf(version) : "Unknown"), e);
                try {
                    buf.release();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return true;
            }
        }
        return false;
    }

    public static void clear() {
        lastVersion = "";
        CLIENT_PROTOCOL.clear();
        SERVER_METADATA.clear();
        PolymerClientNetworking.AFTER_DISABLE.invoke(Runnable::run);
    }

    public static void handleMetadata(class_634 handler, int version, class_2540 buf) {
        if (version > -1) {
            try {
                ServerPacketRegistry.decodeMetadata(buf, SERVER_METADATA::put);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void handleHandshake(class_634 handler, int version, class_2540 buf) {
        if (version > -1) {
            lastVersion = buf.method_10800(64);
            CLIENT_PROTOCOL.clear();
            int size = buf.method_10816();
            for (int i = 0; i < size; ++i) {
                class_2960 id = buf.method_10810();
                int size2 = buf.method_10816();
                IntArrayList list = new IntArrayList();
                for (int i2 = 0; i2 < size2; ++i2) {
                    list.add(buf.method_10816());
                }
                CLIENT_PROTOCOL.put((Object)id, ClientPackets.getBestSupported(id, list.elements()));
            }
            PolymerClientNetworking.AFTER_HANDSHAKE_RECEIVED.invoke(Runnable::run);
            if (CLIENT_PROTOCOL.getOrDefault((Object)ClientPackets.METADATA, -1) != -1) {
                ClientPacketRegistry.sendMetadata(handler);
            }
        }
    }

    private static void sendMetadata(class_634 handler) {
        try {
            PolymerClientNetworking.BEFORE_METADATA_SYNC.invoke(Runnable::run);
            class_2540 buf = PolymerServerNetworking.buf(1);
            ServerPacketRegistry.encodeMetadata(buf, METADATA);
            handler.method_2883((class_2596)new class_2817(ClientPackets.METADATA, buf));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void handleDisable(class_634 handler, int version, class_2540 buf) {
        if (version > -1) {
            class_310.method_1551().execute(() -> ClientPacketRegistry.clear());
        }
    }

    public static void sendHandshake(class_634 handler) {
        class_2540 buf = PolymerServerNetworking.buf(0);
        buf.method_10814(CommonImpl.VERSION);
        buf.method_10804(ServerPackets.REGISTRY.size());
        for (class_2960 id : ServerPackets.REGISTRY.keySet()) {
            buf.method_10812(id);
            int[] entry = ServerPackets.REGISTRY.get(id);
            buf.method_10804(entry.length);
            for (int i : entry) {
                buf.method_10804(i);
            }
        }
        handler.method_2883((class_2596)new class_2817(ClientPackets.HANDSHAKE, buf));
    }

    static {
        PACKETS.put(ServerPackets.HANDSHAKE, ClientPacketRegistry::handleHandshake);
        PACKETS.put(ServerPackets.DISABLE, ClientPacketRegistry::handleDisable);
        PACKETS.put(ServerPackets.METADATA, ClientPacketRegistry::handleMetadata);
    }
}

