/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.networking.impl;

import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.networking.api.PolymerHandshakeHandler;
import eu.pb4.polymer.networking.api.PolymerServerNetworking;
import eu.pb4.polymer.networking.api.PolymerServerPacketHandler;
import eu.pb4.polymer.networking.impl.ClientPackets;
import eu.pb4.polymer.networking.impl.ServerPackets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_2505;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import net.minecraft.class_4614;
import net.minecraft.class_4615;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ServerPacketRegistry {
    public static final HashMap<class_2960, PolymerServerPacketHandler> PACKETS = new HashMap();
    public static final HashMap<class_2960, class_2520> METADATA = new HashMap();

    public static boolean handle(class_3244 handler, class_2960 identifier, class_2540 buf) {
        boolean versionRead = false;
        int version = -1;
        PolymerServerPacketHandler packetHandler = PACKETS.get(identifier);
        if (packetHandler != null) {
            try {
                version = buf.method_10816();
                versionRead = true;
                packetHandler.onPacket(handler, version, buf);
            }
            catch (Throwable e) {
                CommonImpl.LOGGER.error(String.format("Invalid %s (%s) packet received from client %s (%s)!", identifier, versionRead ? Integer.valueOf(version) : "Unknown", handler.method_32311().method_5477().getString(), handler.method_32311().method_5845()), e);
            }
            return true;
        }
        return false;
    }

    public static void handleHandshake(PolymerHandshakeHandler handler, int version, class_2540 buf) {
        if (version > -1 && !handler.isPolymer()) {
            String polymerVersion = buf.method_10800(64);
            Object2IntOpenHashMap versionMap = new Object2IntOpenHashMap();
            int size = buf.method_10816();
            for (int i = 0; i < size; ++i) {
                class_2960 id = buf.method_10810();
                int size2 = buf.method_10816();
                IntArrayList list = new IntArrayList();
                for (int i2 = 0; i2 < size2; ++i2) {
                    list.add(buf.method_10816());
                }
                versionMap.put((Object)id, ServerPackets.getBestSupported(id, list.elements()));
            }
            handler.getServer().execute(() -> {
                handler.set(polymerVersion, (Object2IntMap<class_2960>)versionMap);
                handler.setLastPacketTime(ClientPackets.HANDSHAKE);
                ServerPacketRegistry.sendHandshake(handler);
                if (handler.getSupportedProtocol(ServerPackets.METADATA) > -1) {
                    ServerPacketRegistry.sendMetadata(handler);
                }
            });
        }
    }

    public static void sendHandshake(PolymerHandshakeHandler handler) {
        class_2540 buf = PolymerServerNetworking.buf(0);
        buf.method_10814(CommonImpl.VERSION);
        buf.method_10804(ClientPackets.REGISTRY.size());
        for (class_2960 id : ClientPackets.REGISTRY.keySet()) {
            buf.method_10812(id);
            int[] entry = ClientPackets.REGISTRY.get(id);
            buf.method_10804(entry.length);
            for (int i : entry) {
                buf.method_10804(i);
            }
        }
        handler.sendPacket((class_2596<?>)new class_2658(ServerPackets.HANDSHAKE, buf));
    }

    private static void sendMetadata(PolymerHandshakeHandler handler) {
        try {
            class_2540 buf = PolymerServerNetworking.buf(1);
            ServerPacketRegistry.encodeMetadata(buf, METADATA);
            handler.sendPacket((class_2596<?>)new class_2658(ServerPackets.METADATA, buf));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void handleMetadata(PolymerHandshakeHandler handler, int version, class_2540 buf) {
        if (version > -1) {
            try {
                ServerPacketRegistry.decodeMetadata(buf, handler::setMetadataValue);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void decodeMetadata(class_2540 buf, BiConsumer<class_2960, class_2520> map) throws Exception {
        int size = buf.method_10816();
        ByteBufInputStream str = new ByteBufInputStream((ByteBuf)buf);
        for (int i = 0; i < size; ++i) {
            class_2960 id = buf.method_10810();
            class_4614 type = class_4615.method_23265((int)buf.readByte());
            class_2520 data = type.method_23262((DataInput)str, 0, class_2505.field_11556);
            map.accept(id, data);
        }
    }

    public static void encodeMetadata(class_2540 buf, Map<class_2960, class_2520> map) throws Exception {
        buf.method_10804(map.size());
        ByteBufOutputStream str = new ByteBufOutputStream((ByteBuf)buf);
        for (Map.Entry<class_2960, class_2520> e : map.entrySet()) {
            buf.method_10812(e.getKey());
            buf.writeByte((int)e.getValue().method_10711());
            e.getValue().method_10713((DataOutput)str);
        }
    }

    static {
        PACKETS.put(ClientPackets.HANDSHAKE, (handler, version, buf) -> ServerPacketRegistry.handleHandshake(PolymerHandshakeHandler.of(handler), version, buf));
        PACKETS.put(ClientPackets.METADATA, (handler, version, buf) -> ServerPacketRegistry.handleMetadata(PolymerHandshakeHandler.of(handler), version, buf));
    }
}

