/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.networking.api;

import eu.pb4.polymer.common.api.events.SimpleEvent;
import eu.pb4.polymer.networking.api.PolymerHandshakeHandler;
import eu.pb4.polymer.networking.api.PolymerServerPacketHandler;
import eu.pb4.polymer.networking.api.ServerPacketWriter;
import eu.pb4.polymer.networking.impl.ClientPackets;
import eu.pb4.polymer.networking.impl.NetworkHandlerExtension;
import eu.pb4.polymer.networking.impl.ServerPacketRegistry;
import eu.pb4.polymer.networking.impl.ServerPackets;
import io.netty.buffer.Unpooled;
import java.util.function.BiConsumer;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import net.minecraft.class_4614;
import org.jetbrains.annotations.Nullable;

public final class PolymerServerNetworking {
    public static final SimpleEvent<BiConsumer<class_3244, PolymerHandshakeHandler>> AFTER_HANDSHAKE_APPLY = new SimpleEvent();

    private PolymerServerNetworking() {
    }

    public static class_2540 buf(int version) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        return buf.method_10804(version);
    }

    public static boolean send(class_3244 handler, class_2960 identifier, ServerPacketWriter packet) {
        handler.method_14364(packet.toPacket(identifier));
        return true;
    }

    public static boolean sendDirect(class_3244 handler, class_2960 identifier, class_2540 packetByteBuf) {
        handler.method_14364((class_2596)new class_2658(identifier, packetByteBuf));
        return true;
    }

    @Nullable
    public static <T extends class_2520> T getMetadata(class_3244 handler, class_2960 identifier, class_4614<T> type) {
        class_2520 x = (class_2520)((NetworkHandlerExtension)handler).polymerNet$getMetadataMap().get((Object)identifier);
        if (x != null && x.method_23258() == type) {
            return (T)x;
        }
        return null;
    }

    public static void setServerMetadata(class_2960 identifier, @Nullable class_2520 nbtElement) {
        if (nbtElement == null) {
            ServerPacketRegistry.METADATA.remove(identifier);
        } else {
            ServerPacketRegistry.METADATA.put(identifier, nbtElement);
        }
    }

    public static boolean registerPacketHandler(class_2960 identifier, PolymerServerPacketHandler handler, int ... supportedVersions) {
        if (!ServerPacketRegistry.PACKETS.containsKey(identifier)) {
            ClientPackets.register(identifier, supportedVersions);
            ServerPacketRegistry.PACKETS.put(identifier, handler);
            return true;
        }
        return false;
    }

    public static boolean registerSendPacket(class_2960 identifier, int ... supportedVersions) {
        ServerPackets.register(identifier, supportedVersions);
        return true;
    }

    public static int getSupportedVersion(class_3244 handler, class_2960 serverPacket) {
        return ((NetworkHandlerExtension)handler).polymerNet$getSupportedVersion(serverPacket);
    }

    public static long getLastPacketReceivedTime(class_3244 handler, class_2960 identifier) {
        return ((NetworkHandlerExtension)handler).polymerNet$lastPacketUpdate(identifier);
    }

    static {
        ClientPackets.register();
        ServerPackets.register();
    }
}

