/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.mixin.block;

import eu.pb4.polymer.core.api.block.PolymerBlock;
import eu.pb4.polymer.core.api.block.PolymerBlockUtils;
import eu.pb4.polymer.core.api.item.PolymerItem;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2596;
import net.minecraft.class_2620;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_2718;
import net.minecraft.class_2783;
import net.minecraft.class_2846;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_4770;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3225.class})
public abstract class ServerPlayerInteractionManagerMixin {
    @Shadow
    protected class_3222 field_14008;
    @Shadow
    protected class_3218 field_14007;
    @Shadow
    private int field_14000;
    @Shadow
    private int field_20326;
    @Unique
    private int polymer$sequence = 0;
    @Unique
    private int polymer$blockBreakingCooldown;
    @Unique
    private boolean polymer$hasMiningFatigue;

    @Shadow
    public abstract void method_21717(class_2338 var1, int var2, String var3);

    @Inject(method={"continueMining"}, at={@At(value="TAIL")})
    private void polymer_breakIfTakingTooLong(class_2680 state, class_2338 pos, int i, CallbackInfoReturnable<Float> cir) {
        if (this.polymer$shouldMineServerSide(pos, state)) {
            int j = this.field_14000 - i;
            float f = state.method_26165((class_1657)this.field_14008, (class_1922)this.field_14008.method_37908(), pos) * (float)j;
            if (this.polymer$blockBreakingCooldown > 0) {
                --this.polymer$blockBreakingCooldown;
            }
            if (f >= 1.0f) {
                this.polymer$blockBreakingCooldown = 5;
                this.field_14008.field_13987.method_14364((class_2596)new class_2620(-1, pos, -1));
                this.method_21717(pos, this.polymer$sequence, "destroyed");
                if (!(state.method_26204() instanceof class_4770)) {
                    this.field_14007.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
                }
            }
        } else if (this.polymer$hasMiningFatigue) {
            this.polymer$clearMiningEffect();
        }
    }

    @Inject(method={"continueMining"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;setBlockBreakingInfo(ILnet/minecraft/util/math/BlockPos;I)V")})
    private void polymer$onUpdateBreakStatus(class_2680 state, class_2338 pos, int i, CallbackInfoReturnable<Float> cir) {
        if (this.polymer$shouldMineServerSide(pos, state)) {
            int j = this.field_14000 - i;
            float f = state.method_26165((class_1657)this.field_14008, (class_1922)this.field_14008.method_37908(), pos) * (float)(j + 1);
            int k = (int)(f * 10.0f);
            this.field_14008.field_13987.method_14364((class_2596)new class_2620(-1, pos, k));
            PolymerBlockUtils.BREAKING_PROGRESS_UPDATE.invoke(x -> x.onBreakingProgressUpdate(this.field_14008, pos, state, k));
        } else if (this.polymer$hasMiningFatigue) {
            this.polymer$clearMiningEffect();
        }
    }

    @Inject(method={"processBlockBreakingAction"}, at={@At(value="HEAD")})
    private void polymer_packetReceivedInject(class_2338 pos, class_2846.class_2847 action, class_2350 direction, int worldHeight, int sequence, CallbackInfo ci) {
        this.polymer$sequence = sequence;
        class_2680 state = this.field_14008.method_37908().method_8320(pos);
        if (this.polymer$shouldMineServerSide(pos, state)) {
            if (action == class_2846.class_2847.field_12968) {
                float delta;
                float ogDelta = state.method_26165((class_1657)this.field_14008, (class_1922)this.field_14007, pos);
                class_2248 class_22482 = state.method_26204();
                if (class_22482 instanceof PolymerBlock) {
                    PolymerBlock virtualBlock = (PolymerBlock)class_22482;
                    state = PolymerBlockUtils.getBlockStateSafely(virtualBlock, state);
                }
                if ((delta = state.method_26165((class_1657)this.field_14008, (class_1922)this.field_14007, pos)) >= 1.0f && ogDelta < 1.0f) {
                    this.field_14008.field_13987.method_14364((class_2596)new class_2626(pos, state));
                }
                if (ogDelta < 1.0f) {
                    this.polymer$sendMiningFatigue();
                }
            } else if (action == class_2846.class_2847.field_12971) {
                if (this.polymer$hasMiningFatigue) {
                    this.polymer$clearMiningEffect();
                }
                this.field_14008.field_13987.method_14364((class_2596)new class_2620(-1, pos, -1));
                class_2680 finalState = state;
                PolymerBlockUtils.BREAKING_PROGRESS_UPDATE.invoke(x -> x.onBreakingProgressUpdate(this.field_14008, pos, finalState, -1));
            }
        } else if (this.polymer$hasMiningFatigue) {
            this.polymer$clearMiningEffect();
        }
    }

    @Inject(method={"processBlockBreakingAction"}, at={@At(value="TAIL")})
    private void polymer$enforceBlockBreakingCooldown(class_2338 pos, class_2846.class_2847 action, class_2350 direction, int worldHeight, int sequence, CallbackInfo ci) {
        if (this.polymer$shouldMineServerSide(pos, this.field_14008.method_37908().method_8320(pos))) {
            if (action == class_2846.class_2847.field_12968) {
                this.field_20326 += this.polymer$blockBreakingCooldown;
            }
        } else if (this.polymer$hasMiningFatigue) {
            this.polymer$clearMiningEffect();
        }
    }

    @Inject(method={"finishMining"}, at={@At(value="HEAD")})
    private void polymer$clearEffects(class_2338 pos, int sequence, String reason, CallbackInfo ci) {
        this.polymer$clearMiningEffect();
    }

    @Unique
    private boolean polymer$shouldMineServerSide(class_2338 pos, class_2680 state) {
        PolymerItem item;
        PolymerBlock block;
        class_2248 class_22482 = state.method_26204();
        return class_22482 instanceof PolymerBlock && (block = (PolymerBlock)class_22482).handleMiningOnServer(this.field_14008.method_6047(), state, pos, this.field_14008) || (class_22482 = this.field_14008.method_6047().method_7909()) instanceof PolymerItem && (item = (PolymerItem)class_22482).handleMiningOnServer(this.field_14008.method_6047(), state, pos, this.field_14008) || PolymerBlockUtils.SERVER_SIDE_MINING_CHECK.invoke(x -> x.onBlockMine(state, pos, this.field_14008));
    }

    @Unique
    private void polymer$sendMiningFatigue() {
        this.polymer$hasMiningFatigue = true;
        this.field_14008.field_13987.method_14364((class_2596)new class_2783(this.field_14008.method_5628(), new class_1293(class_1294.field_5901, 20, -1, true, false)));
    }

    @Unique
    private void polymer$clearMiningEffect() {
        this.polymer$hasMiningFatigue = false;
        this.field_14008.field_13987.method_14364((class_2596)new class_2718(this.field_14008.method_5628(), class_1294.field_5901));
        if (this.field_14008.method_6059(class_1294.field_5901)) {
            class_1293 effectInstance = this.field_14008.method_6112(class_1294.field_5901);
            this.field_14008.field_13987.method_14364((class_2596)new class_2783(this.field_14008.method_5628(), effectInstance));
        }
    }

    @Redirect(method={"processBlockBreakingAction"}, at=@At(value="INVOKE", target="Lorg/slf4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V"), require=0)
    private void polymer$noOneCaresAboutMismatch(Logger instance, String s, Object o, Object o2) {
    }
}

