/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.mixin.block;

import eu.pb4.polymer.core.api.block.PolymerBlockUtils;
import eu.pb4.polymer.core.impl.PolymerImpl;
import eu.pb4.polymer.core.impl.interfaces.PolymerBlockPosStorage;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.minecraft.class_1944;
import net.minecraft.class_2596;
import net.minecraft.class_2676;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3227;
import net.minecraft.class_3568;
import net.minecraft.class_3898;
import net.minecraft.class_4076;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3215.class})
public abstract class ServerChunkManagerMixin {
    @Shadow
    @Final
    public class_3898 field_17254;
    @Shadow
    @Final
    private class_3218 field_13945;
    @Shadow
    @Final
    private class_3227 field_13921;
    @Unique
    private final Object2LongMap<class_4076> polymer$lastUpdates = new Object2LongArrayMap();

    @Shadow
    @Nullable
    public abstract class_2818 method_21730(int var1, int var2);

    @Shadow
    public abstract class_3227 method_17293();

    @Inject(method={"tickChunks"}, at={@At(value="TAIL")})
    private void polymer$sendChunkUpdates(CallbackInfo ci) {
        this.field_13945.method_8503().execute(() -> {
            if (this.polymer$lastUpdates.size() != 0) {
                int t = this.field_13945.method_8503().method_3780();
                for (Object2LongMap.Entry entry : new ArrayList(this.polymer$lastUpdates.object2LongEntrySet())) {
                    class_4076 pos = (class_4076)entry.getKey();
                    long time = entry.getLongValue();
                    if ((long)t - time <= (long)PolymerImpl.LIGHT_UPDATE_TICK_DELAY) continue;
                    BitSet bitSet = new BitSet();
                    int i = this.field_13921.method_31929();
                    int j = this.field_13921.method_31930();
                    int y = pos.method_18683();
                    if (y >= i && y <= j) {
                        bitSet.set(y - i);
                    }
                    class_2676 packet = new class_2676(pos.method_18692(), (class_3568)this.method_17293(), new BitSet(this.field_13945.method_31597() + 2), bitSet);
                    List players = this.field_17254.method_17210(pos.method_18692(), false);
                    if (players.size() > 0) {
                        for (class_3222 player : players) {
                            player.field_13987.method_14364((class_2596)packet);
                        }
                    }
                    this.polymer$lastUpdates.removeLong((Object)pos);
                }
            }
        });
    }

    @Inject(method={"onLightUpdate"}, at={@At(value="TAIL")})
    private void polymer$scheduleChunkUpdates(class_1944 type, class_4076 pos, CallbackInfo ci) {
        if (type == class_1944.field_9282) {
            this.field_13945.method_8503().execute(() -> {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        class_2818 chunk = this.method_21730(pos.method_10263() + x, pos.method_10260() + z);
                        if (chunk == null) continue;
                        class_2826[] sections = chunk.method_12006();
                        int max = Math.min(chunk.method_31603(pos.method_18683() + 1), sections.length - 1);
                        for (int i = Math.max(0, chunk.method_31603(pos.method_18683() - 1)); i <= max; ++i) {
                            class_2826 section = sections[i];
                            if (section == null || section.method_38292() || !((PolymerBlockPosStorage)section).polymer$requireLights()) continue;
                            this.polymer$lastUpdates.put((Object)pos, (long)this.field_13945.method_8503().method_3780());
                            ((PolymerBlockPosStorage)section).polymer$setRequireLights(false);
                            return;
                        }
                    }
                }
                if (PolymerBlockUtils.SEND_LIGHT_UPDATE_PACKET.invoke(c -> c.test(this.field_13945, pos))) {
                    this.polymer$lastUpdates.put((Object)pos, (long)this.field_13945.method_8503().method_3780());
                }
            });
        }
    }
}

