/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.impl.other;

import eu.pb4.polymer.core.api.utils.PolymerRegistry;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ImplPolymerRegistry<T>
implements PolymerRegistry<T> {
    private final Map<class_2960, T> entryMap = new Object2ObjectOpenHashMap();
    private final Int2ObjectMap<T> rawIdMap = new Int2ObjectOpenHashMap();
    private final Object2IntMap<T> entryIdMap = new Object2IntOpenHashMap();
    private final Map<T, class_2960> identifierMap = new Object2ObjectOpenHashMap();
    private final Map<class_2960, Set<T>> tags = new Object2ObjectOpenHashMap();
    private final T defaultValue;
    private final class_2960 defaultIdentifier;
    private final String name;
    private final String shortName;
    private int currentId = 0;
    private Map<T, Set<class_2960>> entryTags = new Object2ObjectOpenHashMap();

    public ImplPolymerRegistry(String name, String shortName) {
        this(name, shortName, null, null);
    }

    public ImplPolymerRegistry(String name, String shortName, @Nullable class_2960 defaultIdentifier, @Nullable T defaultValue) {
        this.name = name;
        this.shortName = shortName;
        this.defaultValue = defaultValue;
        this.defaultIdentifier = defaultIdentifier;
        this.rawIdMap.defaultReturnValue(this.defaultValue);
        this.entryIdMap.defaultReturnValue(-1);
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    @Override
    public T get(class_2960 identifier) {
        return this.entryMap.getOrDefault(identifier, this.defaultValue);
    }

    @Override
    public T method_10200(int id) {
        return (T)this.rawIdMap.get(id);
    }

    @Override
    @Nullable
    public T getDirect(class_2960 identifier) {
        return this.entryMap.get(identifier);
    }

    @Override
    public class_2960 getId(T entry) {
        return this.identifierMap.getOrDefault(entry, this.defaultIdentifier);
    }

    @Override
    public int method_10206(T entry) {
        return this.entryIdMap.getInt(entry);
    }

    @Override
    public int method_10204() {
        return this.entryMap.size();
    }

    @Override
    public boolean contains(class_2960 id) {
        return this.entryMap.containsKey(id);
    }

    @Override
    public boolean containsEntry(T entry) {
        return this.entryIdMap.containsKey(entry);
    }

    @Override
    public Stream<T> stream() {
        return this.entryMap.values().stream();
    }

    public void set(class_2960 identifier, int rawId, T entry) {
        this.entryMap.put(identifier, entry);
        this.identifierMap.put(entry, identifier);
        this.rawIdMap.put(rawId, entry);
        this.entryIdMap.put(entry, rawId);
        this.currentId = Math.max(this.currentId, rawId) + 1;
    }

    public void set(class_2960 identifier, T entry) {
        this.set(identifier, this.currentId, entry);
    }

    public void clear() {
        this.rawIdMap.clear();
        this.identifierMap.clear();
        this.entryMap.clear();
        this.entryIdMap.clear();
        this.currentId = 0;
    }

    @NotNull
    public Iterator<T> iterator() {
        return this.rawIdMap.values().iterator();
    }

    @Override
    public Iterable<class_2960> ids() {
        return () -> this.identifierMap.values().iterator();
    }

    @Override
    public Iterable<Map.Entry<class_2960, T>> entries() {
        return () -> this.entryMap.entrySet().iterator();
    }

    @Override
    public Set<T> getTag(class_2960 tag) {
        Set<T> x = this.tags.get(tag);
        return x != null ? x : Collections.emptySet();
    }

    @Override
    public Collection<class_2960> getTags() {
        return this.tags.keySet();
    }

    @Override
    public Collection<class_2960> getTagsOf(T entry) {
        Set<class_2960> list = this.entryTags.get(entry);
        return list == null ? Collections.emptySet() : list;
    }

    public void createTag(class_2960 tag, IntList ids) {
        HashSet set = new HashSet();
        ids.forEach(id -> {
            Object obj = this.rawIdMap.get(id);
            if (obj != null) {
                set.add(obj);
                this.entryTags.computeIfAbsent(obj, x -> new HashSet()).add(tag);
            }
        });
        this.tags.put(tag, set);
    }

    public void remove(T entry) {
        if (this.identifierMap.containsKey(entry)) {
            class_2960 id = this.identifierMap.get(entry);
            int rawId = this.entryIdMap.getInt(entry);
            this.rawIdMap.remove(rawId);
            this.entryMap.remove(id);
            this.entryIdMap.removeInt(entry);
            this.identifierMap.remove(entry);
            this.entryTags.remove(entry);
        }
    }

    public void removeIf(Predicate<T> removePredicate) {
        for (Object x : new ArrayList(this.rawIdMap.values())) {
            if (!removePredicate.test(x)) continue;
            this.remove(x);
        }
    }
}

