/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.impl.networking;

import eu.pb4.polymer.core.api.utils.PolymerSyncUtils;
import eu.pb4.polymer.core.api.utils.PolymerUtils;
import eu.pb4.polymer.core.impl.interfaces.PolymerNetworkHandlerExtension;
import eu.pb4.polymer.core.impl.networking.ClientPackets;
import eu.pb4.polymer.core.impl.networking.PolymerServerProtocol;
import eu.pb4.polymer.core.impl.networking.ServerPackets;
import eu.pb4.polymer.networking.api.PolymerServerNetworking;
import eu.pb4.polymer.networking.impl.TempPlayerLoginAttachments;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1809;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2680;
import net.minecraft.class_2735;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PolymerServerProtocolHandler {
    public static void register() {
        PolymerServerNetworking.registerPacketHandler((class_2960)ClientPackets.SYNC_REQUEST, PolymerServerProtocolHandler::handleSyncRequest, (int[])new int[]{0});
        PolymerServerNetworking.registerPacketHandler((class_2960)ClientPackets.WORLD_PICK_BLOCK, PolymerServerProtocolHandler::handlePickBlock, (int[])new int[]{0});
        PolymerServerNetworking.registerPacketHandler((class_2960)ClientPackets.WORLD_PICK_ENTITY, PolymerServerProtocolHandler::handlePickEntity, (int[])new int[]{0});
        PolymerServerNetworking.registerPacketHandler((class_2960)ClientPackets.CHANGE_TOOLTIP, PolymerServerProtocolHandler::handleTooltipChange, (int[])new int[]{0});
        PolymerServerNetworking.AFTER_HANDSHAKE_APPLY.register((handler, x) -> PolymerServerProtocol.sendSyncPackets(handler, false));
        ServerPackets.SYNC_ENCHANTMENT.method_12836();
    }

    private static void handleTooltipChange(class_3244 handler, int version, class_2540 buf) {
        if (version > -1) {
            boolean tooltip = buf.readBoolean();
            handler.method_32311().method_5682().execute(() -> {
                PolymerNetworkHandlerExtension.of(handler).polymer$setAdvancedTooltip(tooltip);
                if (PolymerServerNetworking.getLastPacketReceivedTime((class_3244)handler, (class_2960)ClientPackets.CHANGE_TOOLTIP) + 1000L < System.currentTimeMillis()) {
                    PolymerSyncUtils.synchronizeCreativeTabs(handler);
                    PolymerUtils.reloadInventory(handler.field_14140);
                }
            });
        }
    }

    private static void handleSyncRequest(class_3244 handler, int version, class_2540 buf) {
        long lastPacketUpdate = PolymerServerNetworking.getLastPacketReceivedTime((class_3244)handler, (class_2960)ClientPackets.SYNC_REQUEST);
        if (version > -1 && System.currentTimeMillis() - lastPacketUpdate > 20000L) {
            handler.method_32311().method_5682().execute(() -> {
                PolymerServerProtocol.sendSyncPackets(handler, true);
                if (handler.method_32311() != null && ((TempPlayerLoginAttachments)handler.method_32311()).polymerNet$getWorldReload()) {
                    ((TempPlayerLoginAttachments)handler.method_32311()).polymerNet$setWorldReload(false);
                    PolymerUtils.reloadWorld(handler.method_32311());
                }
            });
        }
    }

    private static void handlePickBlock(class_3244 handler, int version, class_2540 buf) {
        if (version == 0) {
            class_2338 pos = buf.method_10811();
            boolean ctr = buf.readBoolean();
            handler.method_32311().method_5682().execute(() -> {
                boolean isCreative = handler.method_32311().method_7337();
                if (pos.method_19455((class_2382)handler.field_14140.method_24515()) <= 32) {
                    class_2680 blockState = handler.field_14140.method_37908().method_8320(pos);
                    if (blockState.method_26215()) {
                        return;
                    }
                    class_2248 block = blockState.method_26204();
                    class_1799 itemStack = block.method_9574((class_1922)handler.field_14140.method_37908(), pos, blockState);
                    if (itemStack.method_7960()) {
                        return;
                    }
                    class_2586 blockEntity = null;
                    if (isCreative && ctr && blockState.method_31709()) {
                        blockEntity = handler.field_14140.method_37908().method_8321(pos);
                    }
                    class_1661 playerInventory = handler.field_14140.method_31548();
                    if (blockEntity != null) {
                        PolymerServerProtocolHandler.addBlockEntityNbt(itemStack, blockEntity);
                    }
                    int i = playerInventory.method_7395(itemStack);
                    if (isCreative) {
                        playerInventory.method_7374(itemStack);
                        handler.method_14364((class_2596)new class_2735(playerInventory.field_7545));
                    } else if (i != -1) {
                        if (class_1661.method_7380((int)i)) {
                            playerInventory.field_7545 = i;
                        } else {
                            handler.field_14140.method_31548().method_7365(i);
                            handler.method_14364((class_2596)new class_2653(-2, 0, playerInventory.field_7545, playerInventory.method_5438(playerInventory.field_7545)));
                            handler.method_14364((class_2596)new class_2653(-2, 0, i, playerInventory.method_5438(i)));
                        }
                        handler.method_14364((class_2596)new class_2735(playerInventory.field_7545));
                    }
                }
            });
        }
    }

    private static void handlePickEntity(class_3244 handler, int version, class_2540 buf) {
        if (version == 0) {
            boolean isCreative = handler.method_32311().method_7337();
            int id = buf.method_10816();
            handler.method_32311().method_5682().execute(() -> {
                class_1799 itemStack;
                class_1297 entity = handler.field_14140.method_51469().method_8469(id);
                if (entity != null && entity.method_19538().method_1035(handler.field_14140.method_19538()).method_1027() < 1024.0 && (itemStack = entity.method_31480()) != null && !itemStack.method_7960()) {
                    class_1661 playerInventory = handler.field_14140.method_31548();
                    int i = playerInventory.method_7395(itemStack);
                    if (isCreative) {
                        playerInventory.method_7374(itemStack);
                        handler.method_14364((class_2596)new class_2735(playerInventory.field_7545));
                    } else if (i != -1) {
                        if (class_1661.method_7380((int)i)) {
                            playerInventory.field_7545 = i;
                        } else {
                            handler.field_14140.method_31548().method_7365(i);
                            handler.method_14364((class_2596)new class_2653(-2, 0, playerInventory.field_7545, playerInventory.method_5438(playerInventory.field_7545)));
                            handler.method_14364((class_2596)new class_2653(-2, 0, i, playerInventory.method_5438(i)));
                        }
                        handler.method_14364((class_2596)new class_2735(playerInventory.field_7545));
                    }
                }
            });
        }
    }

    private static void addBlockEntityNbt(class_1799 stack, class_2586 blockEntity) {
        class_2487 nbtCompound = blockEntity.method_38243();
        if (stack.method_7909() instanceof class_1809 && nbtCompound.method_10545("SkullOwner")) {
            class_2487 nbtCompound3 = nbtCompound.method_10562("SkullOwner");
            stack.method_7948().method_10566("SkullOwner", (class_2520)nbtCompound3);
        } else {
            stack.method_7959("BlockEntityTag", (class_2520)nbtCompound);
            class_2487 nbtCompound3 = new class_2487();
            class_2499 nbtList = new class_2499();
            nbtList.add((Object)class_2519.method_23256((String)"\"(+NBT)\""));
            nbtCompound3.method_10566("Lore", (class_2520)nbtList);
            stack.method_7959("display", (class_2520)nbtCompound3);
        }
    }
}

