/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.impl.client.rendering;

import com.google.gson.JsonParser;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.polymer.core.impl.ArmorTextureMetadata;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.class_1011;
import net.minecraft.class_1049;
import net.minecraft.class_1061;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class PolymerArmorResourceTexture
extends class_1049
implements class_1061 {
    public int width = -1;
    public int height = -1;
    public int index = 0;
    private ArmorTextureMetadata metadata = ArmorTextureMetadata.DEFAULT;
    private class_1011 baseTexture;
    private class_1011 altTexture;
    private boolean animation;
    private int nextIndex;
    private long startingTime;

    public PolymerArmorResourceTexture(class_2960 location) {
        super(location);
    }

    public void method_4625(class_3300 manager) throws IOException {
        class_1011 nativeImage;
        Optional val;
        class_1049.class_4006 textureData = this.method_18153(manager);
        textureData.method_18158();
        class_2960 id = new class_2960(this.field_5224.method_12836(), this.field_5224.method_12832().substring(0, this.field_5224.method_12832().length() - 3) + "polymer.json");
        Optional res = manager.method_14486(id);
        if (res.isPresent() && (val = ArmorTextureMetadata.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)new String(((class_3298)res.get()).method_14482().readAllBytes()))).result()).isPresent()) {
            this.metadata = (ArmorTextureMetadata)((Pair)val.get()).getFirst();
        }
        this.width = 64 * this.metadata.scale();
        this.height = 32 * this.metadata.scale();
        this.animation = this.metadata.frames() > 1;
        this.baseTexture = nativeImage = textureData.method_18157();
        if (this.metadata.interpolate()) {
            this.altTexture = new class_1011(this.width, this.height, false);
        }
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> this.upload(nativeImage));
        } else {
            this.upload(nativeImage);
        }
    }

    private void upload(class_1011 nativeImage) {
        TextureUtil.prepareImage((int)this.method_4624(), (int)0, (int)this.width, (int)this.height);
        nativeImage.method_22619(0, 0, 0, 0, 0, this.width, this.height, false, false, false, false);
    }

    private void update(class_1011 nativeImage, int index) {
        nativeImage.method_22619(0, 0, 0, 0, index * this.height, this.width, this.height, false, false, false, false);
    }

    public void baseAnimationTick() {
        int delta;
        long currentTime = System.currentTimeMillis();
        if (this.startingTime == 0L) {
            this.startingTime = currentTime;
        }
        if ((delta = (int)(currentTime - this.startingTime)) >= 40) {
            this.tickAnimation(currentTime);
        }
    }

    public void tickAnimation(long currentTime) {
        long timeDiff = currentTime - this.startingTime;
        int frameTime = 40 * this.metadata.animationSpeed();
        if (timeDiff > (long)frameTime) {
            ++this.index;
            this.startingTime = currentTime;
            timeDiff = 0L;
            if (this.index >= this.metadata.frames()) {
                this.index = 0;
            }
            this.nextIndex = this.index + 1;
            if (this.nextIndex >= this.metadata.frames()) {
                this.nextIndex = 0;
            }
            if (!this.metadata.interpolate()) {
                this.method_23207();
                this.update(this.baseTexture, this.index);
            }
        }
        if (this.metadata.interpolate()) {
            double delta = Math.min((double)timeDiff / (double)frameTime, 1.0);
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    int base = this.baseTexture.method_4315(x, y + this.index * this.height);
                    int next = this.baseTexture.method_4315(x, y + this.nextIndex * this.height);
                    int r = this.lerp(delta, next >> 16 & 0xFF, base >> 16 & 0xFF);
                    int g = this.lerp(delta, next >> 8 & 0xFF, base >> 8 & 0xFF);
                    int b = this.lerp(delta, next & 0xFF, base & 0xFF);
                    this.altTexture.method_4305(x, y, base & 0xFF000000 | r << 16 | g << 8 | b);
                }
            }
            this.method_23207();
            this.update(this.altTexture, 0);
        }
    }

    private int lerp(double delta, int to, int from) {
        return (int)(delta * (double)to + (1.0 - delta) * (double)from);
    }

    public void method_4622() {
        if (this.animation) {
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(this::baseAnimationTick);
            } else {
                this.baseAnimationTick();
            }
        }
    }

    public void close() {
        super.close();
        this.baseTexture.close();
        if (this.altTexture != null) {
            this.altTexture.close();
        }
    }
}

