/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.impl.client.networking;

import com.mojang.brigadier.StringReader;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.core.api.client.ClientPolymerBlock;
import eu.pb4.polymer.core.api.client.ClientPolymerEntityType;
import eu.pb4.polymer.core.api.client.ClientPolymerEntry;
import eu.pb4.polymer.core.api.client.ClientPolymerItem;
import eu.pb4.polymer.core.api.client.PolymerClientUtils;
import eu.pb4.polymer.core.api.utils.PolymerClientDecoded;
import eu.pb4.polymer.core.impl.PolymerImplUtils;
import eu.pb4.polymer.core.impl.PolymerMetadataKeys;
import eu.pb4.polymer.core.impl.client.InternalClientRegistry;
import eu.pb4.polymer.core.impl.client.interfaces.ClientBlockStorageInterface;
import eu.pb4.polymer.core.impl.client.interfaces.ClientEntityExtension;
import eu.pb4.polymer.core.impl.client.interfaces.ClientItemGroupExtension;
import eu.pb4.polymer.core.impl.networking.ServerPackets;
import eu.pb4.polymer.core.impl.networking.packets.DebugBlockStateEntry;
import eu.pb4.polymer.core.impl.networking.packets.IdValueEntry;
import eu.pb4.polymer.core.impl.networking.packets.PolymerBlockEntry;
import eu.pb4.polymer.core.impl.networking.packets.PolymerBlockStateEntry;
import eu.pb4.polymer.core.impl.networking.packets.PolymerEntityEntry;
import eu.pb4.polymer.core.impl.networking.packets.PolymerItemEntry;
import eu.pb4.polymer.core.impl.networking.packets.PolymerTagEntry;
import eu.pb4.polymer.core.impl.other.EventRunners;
import eu.pb4.polymer.core.impl.other.ImplPolymerRegistry;
import eu.pb4.polymer.core.mixin.other.ItemGroupsAccessor;
import eu.pb4.polymer.networking.api.client.PolymerClientNetworking;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_338;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public class PolymerClientProtocolHandler {
    public static void register() {
        PolymerClientNetworking.registerPacketHandler((class_2960)ServerPackets.WORLD_SET_BLOCK_UPDATE, PolymerClientProtocolHandler::handleSetBlock);
        PolymerClientNetworking.registerPacketHandler((class_2960)ServerPackets.WORLD_CHUNK_SECTION_UPDATE, PolymerClientProtocolHandler::handleWorldSectionUpdate);
        PolymerClientNetworking.registerPacketHandler((class_2960)ServerPackets.WORLD_ENTITY, PolymerClientProtocolHandler::handleEntity);
        PolymerClientNetworking.registerPacketHandler((class_2960)ServerPackets.SYNC_STARTED, (handler, version, buf) -> PolymerClientUtils.ON_SYNC_STARTED.invoke(EventRunners.RUN));
        PolymerClientNetworking.registerPacketHandler((class_2960)ServerPackets.SYNC_INFO, PolymerClientProtocolHandler::handleSyncInfo);
        PolymerClientNetworking.registerPacketHandler((class_2960)ServerPackets.SYNC_FINISHED, (handler, version, buf) -> PolymerClientUtils.ON_SYNC_FINISHED.invoke(EventRunners.RUN));
        PolymerClientNetworking.registerPacketHandler((class_2960)ServerPackets.SYNC_BLOCK, (handler, version, buf) -> PolymerClientProtocolHandler.handleGenericSync(handler, version, buf, PolymerBlockEntry::read, entry -> InternalClientRegistry.BLOCKS.set(entry.identifier(), entry.numId(), new ClientPolymerBlock(entry.identifier(), entry.numId(), entry.text(), entry.visual(), (class_2248)class_7923.field_41175.method_10223(entry.identifier())))));
        PolymerClientNetworking.registerPacketHandler((class_2960)ServerPackets.SYNC_ITEM, (handler, version, buf) -> PolymerClientProtocolHandler.handleGenericSync(handler, version, buf, PolymerItemEntry::read, entry -> {
            Optional regEntry = class_7923.field_41178.method_40264(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)entry.identifier()));
            InternalClientRegistry.ITEMS.set(entry.identifier(), entry.numId(), new ClientPolymerItem(entry.identifier(), entry.representation(), entry.foodLevels(), entry.saturation(), entry.miningTool(), entry.miningLevel(), entry.stackSize(), regEntry.isPresent() ? (class_1792)((class_6880.class_6883)regEntry.get()).comp_349() : null));
        }));
        PolymerClientNetworking.registerPacketHandler((class_2960)ServerPackets.SYNC_BLOCKSTATE, (handler, version, buf) -> PolymerClientProtocolHandler.handleGenericSync(handler, version, buf, PolymerBlockStateEntry::read, entry -> InternalClientRegistry.BLOCK_STATES.method_10203((Object)new ClientPolymerBlock.State(entry.states(), InternalClientRegistry.BLOCKS.method_10200(entry.blockId()), PolymerClientProtocolHandler.blockStateOrNull(entry.states(), InternalClientRegistry.BLOCKS.method_10200(entry.blockId()))), entry.numId())));
        PolymerClientNetworking.registerPacketHandler((class_2960)ServerPackets.SYNC_ENTITY, (handler, version, buf) -> PolymerClientProtocolHandler.handleGenericSync(handler, version, buf, PolymerEntityEntry::read, entry -> InternalClientRegistry.ENTITY_TYPES.set(entry.identifier(), entry.rawId(), new ClientPolymerEntityType(entry.identifier(), entry.name(), (class_1299)class_7923.field_41177.method_10223(entry.identifier())))));
        PolymerClientProtocolHandler.registerGenericHandler(ServerPackets.SYNC_VILLAGER_PROFESSION, InternalClientRegistry.VILLAGER_PROFESSIONS, class_7923.field_41195);
        PolymerClientProtocolHandler.registerGenericHandler(ServerPackets.SYNC_BLOCK_ENTITY, InternalClientRegistry.BLOCK_ENTITY, class_7923.field_41181);
        PolymerClientProtocolHandler.registerGenericHandler(ServerPackets.SYNC_STATUS_EFFECT, InternalClientRegistry.STATUS_EFFECT, class_7923.field_41174);
        PolymerClientProtocolHandler.registerGenericHandler(ServerPackets.SYNC_ENCHANTMENT, InternalClientRegistry.ENCHANTMENT, class_7923.field_41176);
        PolymerClientProtocolHandler.registerGenericHandler(ServerPackets.SYNC_FLUID, InternalClientRegistry.FLUID, class_7923.field_41173);
        PolymerClientNetworking.registerPacketHandler((class_2960)ServerPackets.SYNC_TAGS, (handler, version, buf) -> PolymerClientProtocolHandler.handleGenericSync(handler, version, buf, PolymerTagEntry::read, PolymerClientProtocolHandler::registerTag));
        PolymerClientNetworking.registerPacketHandler((class_2960)ServerPackets.SYNC_ITEM_GROUP_DEFINE, (handler, version, buf) -> PolymerClientProtocolHandler.handleItemGroupDefine(handler, version, buf));
        PolymerClientNetworking.registerPacketHandler((class_2960)ServerPackets.SYNC_ITEM_GROUP_CONTENTS_ADD, (handler, version, buf) -> PolymerClientProtocolHandler.handleItemGroupContentsAdd(handler, version, buf));
        PolymerClientNetworking.registerPacketHandler((class_2960)ServerPackets.SYNC_ITEM_GROUP_CONTENTS_CLEAR, (handler, version, buf) -> PolymerClientProtocolHandler.handleItemGroupContentsClear(handler, version, buf));
        PolymerClientNetworking.registerPacketHandler((class_2960)ServerPackets.SYNC_ITEM_GROUP_REMOVE, (handler, version, buf) -> PolymerClientProtocolHandler.handleItemGroupRemove(handler, version, buf));
        PolymerClientNetworking.registerPacketHandler((class_2960)ServerPackets.SYNC_ITEM_GROUP_APPLY_UPDATE, (handler, version, buf) -> PolymerClientProtocolHandler.handleItemGroupApplyUpdates(handler, version, buf));
        PolymerClientNetworking.registerPacketHandler((class_2960)ServerPackets.SYNC_CLEAR, (handler, version, buf) -> InternalClientRegistry.clear());
        PolymerClientNetworking.registerPacketHandler((class_2960)ServerPackets.DEBUG_VALIDATE_STATES, (handler, version, buf) -> PolymerClientProtocolHandler.handleGenericSync(handler, version, buf, DebugBlockStateEntry::read, PolymerClientProtocolHandler::handleDebugValidateStates));
        PolymerClientNetworking.AFTER_HANDSHAKE_RECEIVED.register(() -> InternalClientRegistry.setVersion(PolymerClientNetworking.getServerVersion()));
        PolymerClientNetworking.AFTER_DISABLE.register(InternalClientRegistry::disable);
        PolymerClientNetworking.BEFORE_METADATA_SYNC.register(() -> PolymerClientNetworking.setClientMetadata((class_2960)PolymerMetadataKeys.BLOCKSTATE_BITS, (class_2520)class_2497.method_23247((int)class_3532.method_15342((int)class_2248.field_10651.method_10204()))));
    }

    private static <T> void registerGenericHandler(class_2960 identifier, ImplPolymerRegistry<ClientPolymerEntry<T>> polymerRegistry, class_2378<T> registry) {
        PolymerClientNetworking.registerPacketHandler((class_2960)identifier, (handler, version, buf) -> PolymerClientProtocolHandler.handleGenericSync(handler, version, buf, IdValueEntry::read, entry -> polymerRegistry.set(entry.id(), entry.rawId(), ClientPolymerEntry.of(entry.id(), registry.method_10223(entry.id())))));
    }

    private static void registerTag(PolymerTagEntry tagEntry) {
        ImplPolymerRegistry<ClientPolymerEntry<?>> reg = InternalClientRegistry.BY_VANILLA_ID.get(tagEntry.registry());
        if (reg != null) {
            for (PolymerTagEntry.TagData tag : tagEntry.tags()) {
                reg.createTag(tag.id(), tag.ids());
            }
        }
    }

    private static void handleDebugValidateStates(DebugBlockStateEntry entry) {
        if (CommonImpl.DEVELOPER_MODE) {
            class_338 chat = class_310.method_1551().field_1705.method_1743();
            class_2680 state = (class_2680)class_2248.field_10651.method_10200(entry.numId());
            if (state == null) {
                chat.method_1812((class_2561)class_2561.method_43470((String)("Missing BlockState! | " + entry.numId() + " | Server: " + entry.asString())));
            } else {
                DebugBlockStateEntry debug = DebugBlockStateEntry.of(state, null, 0);
                if (!debug.equals(entry)) {
                    chat.method_1812((class_2561)class_2561.method_43470((String)("Mismatched BlockState! | " + entry.numId() + " | Server: " + entry.asString() + " | Client: " + debug.asString())));
                }
            }
        }
    }

    private static boolean handleSyncInfo(class_634 handler, int version, class_2540 buf) {
        return true;
    }

    @Nullable
    private static class_2680 blockStateOrNull(Map<String, String> states, ClientPolymerBlock clientPolymerBlock) {
        if (clientPolymerBlock.registryEntry() != null) {
            StringBuilder path = new StringBuilder(clientPolymerBlock.identifier().toString());
            if (!states.isEmpty()) {
                path.append("[");
                Iterator<Map.Entry<String, String>> iterator = states.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> entry = iterator.next();
                    path.append(entry.getKey()).append("=").append(entry.getValue());
                    if (!iterator.hasNext()) continue;
                    path.append(",");
                }
                path.append("]");
            }
            try {
                class_2259.class_7211 parsed = class_2259.method_41955((class_7225)class_7923.field_41175.method_46771(), (StringReader)new StringReader(path.toString()), (boolean)false);
                return parsed.comp_622();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean handleItemGroupApplyUpdates(class_634 handler, int version, class_2540 buf) {
        if (version > -1) {
            class_310.method_1551().execute(() -> {
                if (ItemGroupsAccessor.getDisplayContext() != null) {
                    ItemGroupsAccessor.callUpdateEntries(ItemGroupsAccessor.getDisplayContext());
                }
                PolymerClientUtils.ON_SEARCH_REBUILD.invoke(EventRunners.RUN);
            });
            return true;
        }
        return false;
    }

    private static boolean handleItemGroupDefine(class_634 handler, int version, class_2540 buf) {
        if (version > -1) {
            class_2960 id = buf.method_10810();
            class_2561 name = buf.method_10808();
            class_1799 icon = PolymerImplUtils.readStack(buf);
            class_310.method_1551().execute(() -> {
                InternalClientRegistry.clearTabs(t -> t.getIdentifier().equals((Object)id));
                InternalClientRegistry.createItemGroup(id, name, icon);
            });
            return true;
        }
        return false;
    }

    private static boolean handleItemGroupRemove(class_634 handler, int version, class_2540 buf) {
        if (version > -1) {
            class_2960 id = buf.method_10810();
            class_310.method_1551().execute(() -> InternalClientRegistry.clearTabs(x -> x.getIdentifier().equals((Object)id)));
            return true;
        }
        return false;
    }

    private static boolean handleItemGroupContentsAdd(class_634 handler, int version, class_2540 buf) {
        if (version > -1) {
            class_1799 stack;
            int i;
            class_2960 id = buf.method_10810();
            int size = buf.method_10816();
            ArrayList<class_1799> groupList = new ArrayList<class_1799>();
            ArrayList<class_1799> searchList = new ArrayList<class_1799>();
            for (i = 0; i < size; ++i) {
                stack = PolymerImplUtils.readStack(buf);
                if (stack.method_7960()) continue;
                stack = stack.method_7972();
                stack.method_7939(1);
                groupList.add(stack);
            }
            size = buf.method_10816();
            for (i = 0; i < size; ++i) {
                stack = PolymerImplUtils.readStack(buf);
                if (stack.method_7960()) continue;
                stack = stack.method_7972();
                stack.method_7939(1);
                searchList.add(stack);
            }
            class_310.method_1551().execute(() -> {
                class_1761 group = InternalClientRegistry.getItemGroup(id);
                if (group != null) {
                    ClientItemGroupExtension groupAccess = (ClientItemGroupExtension)group;
                    for (class_1799 stack : groupList) {
                        groupAccess.polymer$addStackGroup(stack);
                    }
                    for (class_1799 stack : searchList) {
                        groupAccess.polymer$addStackSearch(stack);
                    }
                }
            });
            return true;
        }
        return false;
    }

    private static boolean handleItemGroupContentsClear(class_634 handler, int version, class_2540 buf) {
        if (version > -1) {
            class_2960 id = buf.method_10810();
            class_310.method_1551().execute(() -> {
                class_1761 group = InternalClientRegistry.getItemGroup(id);
                if (group != null) {
                    ClientItemGroupExtension groupAccess = (ClientItemGroupExtension)group;
                    groupAccess.polymer$clearStacks();
                }
            });
            return true;
        }
        return false;
    }

    private static boolean handleEntity(class_634 handler, int version, class_2540 buf) {
        if (version > -1) {
            int id = buf.method_10816();
            class_2960 polymerId = buf.method_10810();
            class_310.method_1551().execute(() -> {
                class_1297 entity = handler.method_2890().method_8469(id);
                if (entity != null) {
                    ((ClientEntityExtension)entity).polymer$setId(polymerId);
                }
            });
            return true;
        }
        return false;
    }

    private static boolean handleSetBlock(class_634 handler, int version, class_2540 buf) {
        if (version == 2) {
            class_2338 pos = buf.method_10811();
            int id = buf.method_10816();
            ClientPolymerBlock.State block = (ClientPolymerBlock.State)InternalClientRegistry.BLOCK_STATES.method_10200(id);
            if (block != null) {
                class_310.method_1551().execute(() -> {
                    class_2818 chunk = class_310.method_1551().field_1687.method_2935().method_2857(class_4076.method_18675((int)pos.method_10263()), class_4076.method_18675((int)pos.method_10260()), class_2806.field_12803, false);
                    if (chunk != null) {
                        ((ClientBlockStorageInterface)chunk).polymer$setClientBlock(pos.method_10263(), pos.method_10264(), pos.method_10260(), block);
                        PolymerClientUtils.ON_BLOCK_UPDATE.invoke(c -> c.accept(pos, block));
                        if (block.blockState() != null && PolymerClientDecoded.checkDecode(block.blockState().method_26204())) {
                            chunk.method_12010(pos, block.blockState(), false);
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }

    private static boolean handleWorldSectionUpdate(class_634 handler, int version, class_2540 buf) {
        if (version == 2) {
            class_4076 sectionPos = buf.method_19456();
            int size = buf.method_10816();
            short[] blockPos = new short[size];
            ClientPolymerBlock.State[] states = new ClientPolymerBlock.State[size];
            for (int i = 0; i < size; ++i) {
                long value = buf.method_10792();
                blockPos[i] = (short)(value & 0xFFFL);
                states[i] = (ClientPolymerBlock.State)InternalClientRegistry.BLOCK_STATES.method_10200((int)(value >>> 12));
            }
            class_310.method_1551().execute(() -> {
                class_2826 section;
                class_2818 chunk = class_310.method_1551().field_1687.method_2935().method_2857(sectionPos.method_10263(), sectionPos.method_10260(), class_2806.field_12803, false);
                if (chunk != null && (section = chunk.method_38259(chunk.method_31603(sectionPos.method_10264()))) instanceof ClientBlockStorageInterface) {
                    ClientBlockStorageInterface storage = (ClientBlockStorageInterface)section;
                    class_2338.class_2339 mutableBlockPos = new class_2338.class_2339(0, 0, 0);
                    for (int i = 0; i < size; ++i) {
                        short pos = blockPos[i];
                        ClientPolymerBlock.State block = states[i];
                        if (block == null) continue;
                        int x = class_4076.method_30551((short)pos);
                        int y = class_4076.method_30552((short)pos);
                        int z = class_4076.method_30553((short)pos);
                        mutableBlockPos.method_10103(sectionPos.method_19527() + x, sectionPos.method_19527() + y, sectionPos.method_19527() + z);
                        PolymerClientUtils.ON_BLOCK_UPDATE.invoke(c -> c.accept(mutableBlockPos, block));
                        storage.polymer$setClientBlock(x, y, z, block);
                        if (block.blockState() == null || !PolymerClientDecoded.checkDecode(block.blockState().method_26204())) continue;
                        section.method_16675(x, y, z, block.blockState());
                    }
                }
            });
            return true;
        }
        return false;
    }

    private static <T> boolean handleGenericSync(class_634 handler, int version, class_2540 buf, EntryReader<T> reader, Consumer<T> entryConsumer) {
        int size = buf.method_10816();
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < size; ++i) {
            Object entry = reader.read(buf, version);
            if (entry == null) continue;
            list.add(entry);
        }
        for (Object entry : list) {
            entryConsumer.accept(entry);
        }
        return true;
    }

    static interface EntryReader<T> {
        @Nullable
        public T read(class_2540 var1, int var2);
    }
}

