/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.impl.client.compat;

import eu.pb4.polymer.core.api.client.ClientPolymerBlock;
import eu.pb4.polymer.core.api.client.ClientPolymerEntityType;
import eu.pb4.polymer.core.api.client.PolymerClientUtils;
import eu.pb4.polymer.core.impl.PolymerImpl;
import eu.pb4.polymer.core.impl.client.InternalClientRegistry;
import eu.pb4.polymer.core.impl.client.compat.CompatUtils;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1809;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import org.jetbrains.annotations.ApiStatus;
import snownee.jade.addon.core.RegistryNameProvider;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.ItemStackElement;
import snownee.jade.util.ModIdentification;

@ApiStatus.Internal
public class JadeCompatibility
implements IWailaPlugin {
    public void registerClient(IWailaClientRegistration registrar) {
        if (PolymerImpl.IS_CLIENT) {
            registrar.registerBlockComponent((IBlockComponentProvider)BlockOverride.INSTANCE, class_2248.class);
            registrar.registerEntityComponent((IEntityComponentProvider)EntityOverride.INSTANCE, class_1297.class);
            registrar.addItemModNameCallback(CompatUtils::getModName);
        }
    }

    private static class BlockOverride
    implements IBlockComponentProvider {
        public static final BlockOverride INSTANCE = new BlockOverride();
        private static final class_2960 ID = class_2960.method_12829((String)"polymer:blockstate");

        private BlockOverride() {
        }

        public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
            try {
                ClientPolymerBlock.State block = InternalClientRegistry.getBlockAt(accessor.getPosition());
                if (block != ClientPolymerBlock.NONE_STATE) {
                    class_2487 nbtCompound;
                    class_2586 blockEntity;
                    class_2680 state = accessor.getLevel().method_8320(accessor.getPosition());
                    class_1799 itemStack = state.method_26204().method_9574((class_1922)accessor.getLevel(), accessor.getPosition(), state);
                    if (!itemStack.method_7960() && state.method_31709() && itemStack.method_7909() instanceof class_1809 && (blockEntity = accessor.getLevel().method_8321(accessor.getPosition())) != null && (nbtCompound = blockEntity.method_38244()).method_10545("SkullOwner")) {
                        itemStack.method_7948().method_10566("SkullOwner", (class_2520)nbtCompound.method_10562("SkullOwner"));
                    }
                    return ItemStackElement.of((class_1799)itemStack);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }

        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            block14: {
                try {
                    ClientPolymerBlock.State block = InternalClientRegistry.getBlockAt(accessor.getPosition());
                    if (block == ClientPolymerBlock.NONE_STATE) break block14;
                    IWailaConfig.IConfigFormatting formatting = config.getWailaConfig().getFormatting();
                    tooltip.clear();
                    try {
                        tooltip.add(formatting.title((Object)block.block().name().getString()), Identifiers.CORE_OBJECT_NAME);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        RegistryNameProvider.Mode mode = (RegistryNameProvider.Mode)config.getEnum(Identifiers.CORE_REGISTRY_NAME);
                        if (mode != RegistryNameProvider.Mode.OFF && (mode != RegistryNameProvider.Mode.ADVANCED_TOOLTIPS || class_310.method_1551().field_1690.field_1827)) {
                            tooltip.add(config.getWailaConfig().getFormatting().registryName(block.block().identifier().toString()));
                        }
                    }
                    catch (Throwable mode) {
                        // empty catch block
                    }
                    try {
                        if (config.get(Identifiers.MC_BLOCK_STATES)) {
                            IElementHelper helper = tooltip.getElementHelper();
                            ITooltip box = helper.tooltip();
                            block.states().entrySet().forEach(p -> {
                                class_5250 valueText = class_2561.method_43470((String)(" " + (String)p.getValue())).method_27695(new class_124[0]);
                                if (((String)p.getValue()).equals("true") || ((String)p.getValue()).equals("false")) {
                                    valueText = valueText.method_27692(((String)p.getValue()).equals("true") ? class_124.field_1060 : class_124.field_1061);
                                }
                                box.add((class_2561)class_2561.method_43470((String)((String)p.getKey() + ":")).method_10852((class_2561)valueText));
                            });
                            tooltip.add(helper.box(box));
                        }
                    }
                    catch (Throwable helper) {
                        // empty catch block
                    }
                    try {
                        if (config.get(Identifiers.CORE_MOD_NAME)) {
                            String modName = ModIdentification.getModName((class_2960)block.block().identifier());
                            if (modName == null || modName.isEmpty() || modName.equals("Minecraft")) {
                                modName = "Server";
                            }
                            tooltip.add((class_2561)class_2561.method_43470((String)String.format(formatting.getModName(), modName)), Identifiers.CORE_MOD_NAME);
                        }
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public class_2960 getUid() {
            return ID;
        }

        public int getDefaultPriority() {
            return 99999;
        }

        public boolean isRequired() {
            return true;
        }
    }

    private static final class EntityOverride
    implements IEntityComponentProvider {
        public static final EntityOverride INSTANCE = new EntityOverride();
        private static final class_2960 ID = class_2960.method_12829((String)"polymer:entities");

        private EntityOverride() {
        }

        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
            block11: {
                try {
                    class_1297 entity = accessor.getEntity();
                    ClientPolymerEntityType type = PolymerClientUtils.getEntityType(entity);
                    if (type == null) break block11;
                    tooltip.clear();
                    if (type == null) break block11;
                    IWailaConfig.IConfigFormatting formatting = config.getWailaConfig().getFormatting();
                    try {
                        tooltip.add(formatting.title((Object)entity.method_5476().getString()), Identifiers.CORE_OBJECT_NAME);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    RegistryNameProvider.Mode mode = (RegistryNameProvider.Mode)config.getEnum(Identifiers.CORE_REGISTRY_NAME);
                    try {
                        if (mode != RegistryNameProvider.Mode.OFF && (mode != RegistryNameProvider.Mode.ADVANCED_TOOLTIPS || class_310.method_1551().field_1690.field_1827)) {
                            tooltip.add(config.getWailaConfig().getFormatting().registryName(type.identifier().toString()));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        if (config.get(Identifiers.CORE_MOD_NAME)) {
                            String modName = ModIdentification.getModName((class_2960)type.identifier());
                            if (modName == null || modName.isEmpty() || modName.equals("Minecraft")) {
                                modName = "Server";
                            }
                            tooltip.add((class_2561)class_2561.method_43470((String)String.format(formatting.getModName(), modName)), Identifiers.CORE_MOD_NAME);
                        }
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public class_2960 getUid() {
            return ID;
        }

        public int getDefaultPriority() {
            return 999999;
        }

        public boolean isRequired() {
            return true;
        }
    }
}

