/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.impl.client.compat;

import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.stack.EmiStack;
import eu.pb4.polymer.core.impl.PolymerImpl;
import eu.pb4.polymer.core.impl.PolymerImplUtils;
import eu.pb4.polymer.core.impl.client.compat.CompatUtils;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.Version;
import net.minecraft.class_1799;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class EmiCompatibility
implements EmiPlugin {
    public static final boolean IS_1_0_0 = FabricLoader.getInstance().getModContainer("emi").map(x -> {
        try {
            return x.getMetadata().getVersion().compareTo((Object)Version.parse((String)"1.0.0-")) >= 0;
        }
        catch (Throwable e) {
            return false;
        }
    }).orElse(false);
    private static final Predicate<EmiStack> SHOULD_REMOVE = stack -> PolymerImplUtils.isPolymerControlled(stack.getItemStack());

    private static void tryReloading() {
        try {
            Class.forName(IS_1_0_0 ? "dev.emi.emi.runtime.EmiReloadManager" : "dev.emi.emi.EmiReloadManager").getMethod("reload", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void register(EmiRegistry registry) {
        if (PolymerImpl.IS_CLIENT) {
            EmiCompatibility.update(registry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void update(EmiRegistry registry) {
        if (registry == null) {
            return;
        }
        EmiRegistry emiRegistry = registry;
        synchronized (emiRegistry) {
            try {
                ((List)Class.forName(IS_1_0_0 ? "dev.emi.emi.registry.EmiStackList" : "dev.emi.emi.EmiStackList").getField("stacks").get(null)).removeIf(SHOULD_REMOVE);
                CompatUtils.iterateItems(stack -> registry.addEmiStack(EmiStack.of((class_1799)stack)));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    static {
        CompatUtils.registerSyncReload(EmiCompatibility::tryReloading);
    }
}

