/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.impl;

import com.google.common.collect.UnmodifiableIterator;
import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.core.api.block.PolymerBlock;
import eu.pb4.polymer.core.api.client.ClientPolymerBlock;
import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import eu.pb4.polymer.core.api.utils.PolymerUtils;
import eu.pb4.polymer.core.impl.InternalServerRegistry;
import eu.pb4.polymer.core.impl.PolymerImpl;
import eu.pb4.polymer.core.impl.client.InternalClientRegistry;
import eu.pb4.polymer.core.impl.compat.ServerTranslationUtils;
import eu.pb4.polymer.core.impl.compat.polymc.PolyMcUtils;
import eu.pb4.polymer.core.impl.interfaces.PolymerIdList;
import eu.pb4.polymer.core.impl.interfaces.PolymerNetworkHandlerExtension;
import eu.pb4.polymer.core.impl.other.ImplPolymerRegistry;
import eu.pb4.polymer.core.impl.other.PolymerTooltipContext;
import eu.pb4.polymer.rsm.impl.RegistrySyncExtension;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryAttributeHolder;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class PolymerImplUtils {
    public static final Collection<class_2680> POLYMER_STATES = ((PolymerIdList)class_2248.field_10651).polymer$getPolymerEntries();

    public static class_2960 id(String path) {
        return new class_2960("polymer", path);
    }

    public static class_1799 readStack(class_2540 buf) {
        if (!buf.readBoolean()) {
            return class_1799.field_8037;
        }
        int i = buf.method_10816();
        byte j = buf.readByte();
        class_1792 dec = PolymerImplUtils.decodeItem(i);
        if (dec == null || dec == class_1802.field_8162) {
            buf.method_10798();
            return class_1799.field_8037;
        }
        class_1799 itemStack = new class_1799((class_1935)dec, (int)j);
        itemStack.method_7980(buf.method_10798());
        return itemStack;
    }

    public static class_1792 decodeItem(int rawId) {
        if (PolymerImpl.IS_CLIENT) {
            return InternalClientRegistry.decodeItem(rawId);
        }
        return class_1792.method_7875((int)rawId);
    }

    public static void writeStack(class_2540 buf, class_1799 stack) {
        if (stack.method_7960()) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            class_1792 item = stack.method_7909();
            buf.method_10804(class_1792.method_7880((class_1792)item));
            buf.writeByte(stack.method_7947());
            buf.method_10794(stack.method_7969());
        }
    }

    public static String getAsString(class_2680 state) {
        StringBuilder builder = new StringBuilder();
        builder.append(class_7923.field_41175.method_10221((Object)state.method_26204()));
        if (!state.method_11656().isEmpty()) {
            builder.append("[");
            UnmodifiableIterator iterator = state.method_11656().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                builder.append(((class_2769)entry.getKey()).method_11899());
                builder.append("=");
                builder.append(((class_2769)entry.getKey()).method_11901((Comparable)entry.getValue()));
                if (!iterator.hasNext()) continue;
                builder.append(",");
            }
            builder.append("]");
        }
        return builder.toString();
    }

    @Nullable
    public static String dumpRegistry() {
        BufferedWriter writer = null;
        try {
            String path = "./polymer-dump-" + FabricLoader.getInstance().getEnvironmentType().name().toLowerCase(Locale.ROOT) + ".txt";
            BufferedWriter finalWriter = writer = new BufferedWriter(new FileWriter(path));
            Consumer<String> msg = str -> {
                try {
                    finalWriter.write((String)str);
                    finalWriter.newLine();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            };
            msg.accept("== Vanilla Registries");
            for (class_2378 reg : class_7923.field_41167) {
                msg.accept("");
                msg.accept("== Registry: " + class_7923.field_41167.method_10221((Object)reg).toString());
                msg.accept("");
                if (reg instanceof RegistrySyncExtension) {
                    RegistrySyncExtension regEx = (RegistrySyncExtension)reg;
                    msg.accept("= Status: " + regEx.polymer_registry_sync$getStatus().name());
                    msg.accept("");
                }
                if (CompatStatus.FABRIC_SYNC) {
                    msg.accept("= Synced: " + RegistryAttributeHolder.get((class_2378)reg).hasAttribute(RegistryAttribute.SYNCED));
                    msg.accept("");
                }
                for (Object entry : reg) {
                    msg.accept(reg.method_10206(entry) + " | " + reg.method_10221(entry).toString() + " | Polymer? " + PolymerUtils.isServerOnly(entry));
                }
            }
            msg.accept("");
            msg.accept("== BlockStates");
            msg.accept("");
            msg.accept("= Polymer Starts: " + PolymerImplUtils.getBlockStateOffset());
            msg.accept("");
            msg.accept("= Vanilla ChunkDeltaUpdateS2CPacket broken: " + (PolymerImplUtils.getBlockStateOffset() >= 524288));
            msg.accept("");
            for (class_2680 state : class_2248.field_10651) {
                msg.accept(class_2248.field_10651.method_10206((Object)state) + " | " + PolymerImplUtils.getAsString(state) + " | Polymer? " + (state.method_26204() instanceof PolymerBlock));
            }
            msg.accept("");
            msg.accept("== Server/Local Polymer Item Groups");
            msg.accept("");
            Iterator<Object> iterator = InternalServerRegistry.ITEM_GROUPS.iterator();
            while (iterator.hasNext()) {
                Object entry = iterator.next();
                msg.accept(InternalServerRegistry.ITEM_GROUPS.getId((class_1761)entry).toString());
            }
            msg.accept("");
            msg.accept("== Polymer Registries");
            msg.accept("");
            if (PolymerImpl.IS_CLIENT) {
                for (ImplPolymerRegistry reg2 : (Collection)InternalClientRegistry.REGISTRIES) {
                    msg.accept("");
                    msg.accept("== Registry: " + reg2.getName() + " (Client)");
                    msg.accept("");
                    Iterator<Object> iterator2 = reg2.iterator();
                    while (iterator2.hasNext()) {
                        Object entry;
                        entry = iterator2.next();
                        msg.accept(reg2.method_10206(entry) + " | " + reg2.getId(entry));
                    }
                    msg.accept("");
                    msg.accept("=== Tags:");
                    msg.accept("");
                    for (class_2960 tag : reg2.getTags()) {
                        msg.accept(tag + " | :");
                        for (Object entry : reg2.getTag(tag)) {
                            msg.accept("  " + reg2.getId(entry));
                        }
                    }
                }
                msg.accept("");
                msg.accept("== Registry: BlockState (Client)");
                msg.accept("");
                for (Object entry : InternalClientRegistry.BLOCK_STATES) {
                    msg.accept(InternalClientRegistry.BLOCK_STATES.method_10206(entry) + " | " + ((ClientPolymerBlock.State)entry).block().identifier());
                }
            }
            try {
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return path;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static int getBlockStateOffset() {
        return ((PolymerIdList)class_2248.field_10651).polymer$getOffset();
    }

    public static void setStateIdsLock(boolean value) {
        ((PolymerIdList)class_2248.field_10651).polymer$setReorderLock(value);
    }

    public static boolean getStateIdsLock(boolean value) {
        return ((PolymerIdList)class_2248.field_10651).polymer$getReorderLock();
    }

    public static boolean shouldSkipStateInitialization(Stream<StackWalker.StackFrame> s) {
        if (CompatStatus.QUILT_REGISTRY) {
            Optional<StackWalker.StackFrame> x = s.skip(3L).findFirst();
            return x.isPresent() && x.get().getMethodName().contains("lambda$onInit");
        }
        return false;
    }

    public static boolean shouldLogStateRebuild(StackTraceElement[] trace) {
        return trace.length <= 4 || !trace[4].getClassName().startsWith("org.quiltmc.qsl.registry.impl.sync");
    }

    public static boolean isPolymerControlled(class_1799 stack) {
        return PolymerItemUtils.isPolymerServerItem(stack) || PolymerItemUtils.getServerIdentifier(stack) != null || PolymerUtils.isServerOnly(stack);
    }

    public static PolymerTooltipContext getTooltipContext(class_3222 player) {
        PolymerNetworkHandlerExtension h;
        class_3244 class_32442;
        return player != null && (class_32442 = player.field_13987) instanceof PolymerNetworkHandlerExtension && (h = (PolymerNetworkHandlerExtension)class_32442).polymer$advancedTooltip() ? PolymerTooltipContext.ADVANCED : PolymerTooltipContext.BASIC;
    }

    public static boolean isServerSideSyncableEntry(class_2378 reg, Object obj) {
        return PolymerUtils.isServerOnly(obj) || PolymerImpl.SYNC_MODDED_ENTRIES_POLYMC && !reg.method_10221(obj).method_12836().equals("minecraft");
    }

    public static class_1799 convertStack(class_1799 representation, class_3222 player) {
        return PolymerImplUtils.convertStack(representation, player, PolymerUtils.getTooltipContext(player));
    }

    public static class_1799 convertStack(class_1799 representation, class_3222 player, class_1836 context) {
        return ServerTranslationUtils.parseFor(player.field_13987, PolyMcUtils.toVanilla(PolymerItemUtils.getPolymerItemStack(representation, context, player), player));
    }
}

