/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.impl;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.common.impl.CommonResourcePackInfoHolder;
import eu.pb4.polymer.core.api.block.BlockMapper;
import eu.pb4.polymer.core.api.item.PolymerItemGroupUtils;
import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import eu.pb4.polymer.core.api.other.PolymerStat;
import eu.pb4.polymer.core.api.utils.PolymerSyncUtils;
import eu.pb4.polymer.core.api.utils.PolymerUtils;
import eu.pb4.polymer.core.impl.PolymerImplUtils;
import eu.pb4.polymer.core.impl.compat.ServerTranslationUtils;
import eu.pb4.polymer.core.impl.networking.PolymerServerProtocol;
import eu.pb4.polymer.core.impl.ui.CreativeTabListUi;
import eu.pb4.polymer.core.impl.ui.CreativeTabUi;
import eu.pb4.polymer.core.impl.ui.PotionUi;
import eu.pb4.polymer.core.mixin.block.PalettedContainerAccessor;
import eu.pb4.polymer.networking.impl.NetworkHandlerExtension;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3908;
import net.minecraft.class_3916;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5628;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class Commands {
    public static void register(LiteralArgumentBuilder<class_2168> command, class_7157 access) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"stats").requires(CommonImplUtils.permission((String)"command.stats", (int)0))).executes(Commands::statsGeneral)).then(class_2170.method_9244((String)"type", (ArgumentType)class_7733.method_45603((class_7157)access, (class_5321)class_7924.field_41226)).executes(Commands::stats)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"effects").requires(CommonImplUtils.permission((String)"command.effects", (int)0))).executes(Commands::effects))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"client-item").requires(CommonImplUtils.permission((String)"command.client-item", (int)3))).executes(Commands::displayClientItem)).then(class_2170.method_9247((String)"get").executes(Commands::getClientItem)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"export-registry").requires(CommonImplUtils.permission((String)"command.export-registry", (int)3))).executes(Commands::dumpRegistries))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"target-block").requires(CommonImplUtils.permission((String)"command.target-block", (int)3))).executes(Commands::targetBlock))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"creative").requires(CommonImplUtils.permission((String)"command.creative", (int)0))).then(class_2170.method_9244((String)"itemGroup", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> {
            String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
            List<class_1761> groups = PolymerItemGroupUtils.getItemGroups(((class_2168)context.getSource()).method_9207());
            class_2172.method_9268(groups, (String)remaining, arg_0 -> ((class_2378)class_7923.field_44687).method_10221(arg_0), group -> builder.suggest(class_7923.field_44687.method_10221(group).toString(), (Message)group.method_7737()));
            return builder.buildFuture();
        }).executes(Commands::creativeTab))).executes(Commands::creativeTab));
    }

    public static void registerDev(LiteralArgumentBuilder<class_2168> dev) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)dev.then(class_2170.method_9247((String)"reload-world").executes(ctx -> {
            PolymerUtils.reloadWorld(((class_2168)ctx.getSource()).method_44023());
            return 0;
        }))).then(class_2170.method_9247((String)"get-mapper").executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)BlockMapper.getFrom(((class_2168)ctx.getSource()).method_44023()).getMapperName()), false);
            return 0;
        }))).then(class_2170.method_9247((String)"reset-mapper").executes(ctx -> {
            BlockMapper.resetMapper(((class_2168)ctx.getSource()).method_44023());
            return 0;
        }))).then(class_2170.method_9247((String)"run-sync").executes(ctx -> {
            PolymerSyncUtils.synchronizePolymerRegistries(((class_2168)ctx.getSource()).method_44023().field_13987);
            return 0;
        }))).then(class_2170.method_9247((String)"protocol-info").executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Protocol supported by your client:"), false);
            for (Object2IntMap.Entry entry : NetworkHandlerExtension.of((class_3244)((class_2168)ctx.getSource()).method_44023().field_13987).polymerNet$getSupportMap().object2IntEntrySet()) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("- " + entry.getKey() + " = " + entry.getIntValue())), false);
            }
            return 0;
        }))).then(class_2170.method_9247((String)"validate_states").executes(ctx -> {
            PolymerServerProtocol.sendDebugValidateStatesPackets(((class_2168)ctx.getSource()).method_44023().field_13987);
            return 0;
        }))).then(class_2170.method_9247((String)"set-pack-status").then(class_2170.method_9244((String)"status", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            Boolean status = (Boolean)ctx.getArgument("status", Boolean.class);
            ((CommonResourcePackInfoHolder)((class_2168)ctx.getSource()).method_44023()).polymerCommon$setResourcePack(status.booleanValue());
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("New resource pack status: " + status)), false);
            return 0;
        })))).then(class_2170.method_9247((String)"get-pack-status").executes(ctx -> {
            boolean status = PolymerUtils.hasResourcePack(((class_2168)ctx.getSource()).method_44023());
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Resource pack status: " + status)), false);
            return 0;
        }))).then(class_2170.method_9247((String)"chunk_section_info").executes(ctx -> {
            class_2791 chunk = ((class_2168)ctx.getSource()).method_9225().method_22350(((class_2168)ctx.getSource()).method_44023().method_24515());
            class_2826 s = chunk.method_38259(((class_2168)ctx.getSource()).method_9225().method_31602(((class_2168)ctx.getSource()).method_44023().method_31478()));
            class_2841.class_6561<?> a = ((PalettedContainerAccessor)s.method_12265()).getData();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Chunk: " + chunk.method_12004() + " Palette: " + a.comp_119() + " |  Storage: " + a.comp_118() + " | Bits: " + a.comp_118().method_34896())), false);
            return 0;
        }));
    }

    private static int targetBlock(CommandContext<class_2168> context) {
        class_3965 raycast = (class_3965)((class_2168)context.getSource()).method_44023().method_5745(10.0, 0.0f, true);
        StringBuilder builder = new StringBuilder();
        class_2680 state = ((class_2168)context.getSource()).method_9225().method_8320(raycast.method_17777());
        builder.append(class_7923.field_41175.method_10221((Object)state.method_26204()));
        if (!state.method_26204().method_9595().method_11659().isEmpty()) {
            builder.append("[");
            Iterator iterator = state.method_26204().method_9595().method_11659().iterator();
            while (iterator.hasNext()) {
                class_2769 property = (class_2769)iterator.next();
                builder.append(property.method_11899());
                builder.append("=");
                builder.append(property.method_11901(state.method_11654(property)));
                if (!iterator.hasNext()) continue;
                builder.append(",");
            }
            builder.append("]");
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)builder.toString()), false);
        return 0;
    }

    private static int dumpRegistries(CommandContext<class_2168> context) {
        String path = PolymerImplUtils.dumpRegistry();
        if (path != null) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Exported registry state as " + path)), false);
        } else {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Couldn't export registry!"));
        }
        return 0;
    }

    private static int effects(CommandContext<class_2168> context) throws CommandSyntaxException {
        new PotionUi(((class_2168)context.getSource()).method_44023());
        return 1;
    }

    private static int statsGeneral(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        class_2499 list = new class_2499();
        int line = 0;
        class_5250 text = null;
        for (class_3448 statType : class_7923.field_41193) {
            if (text == null) {
                text = class_2561.method_43470((String)"");
            }
            text.method_10852((class_2561)class_2561.method_43473().method_27693(class_7923.field_41193.method_10221((Object)statType).toString()).method_27693("\n").method_27694(x -> x.method_30938(Boolean.valueOf(true)).method_10977(class_124.field_1078).method_10958(new class_2558(class_2558.class_2559.field_11750, "/polymer stats " + class_7923.field_41193.method_10221((Object)statType)))));
            if (++line != 13) continue;
            list.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)text)));
            text = null;
            line = 0;
        }
        if (text != null) {
            list.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867(text)));
        }
        final class_1799 stack = new class_1799((class_1935)class_1802.field_8360);
        stack.method_7948().method_10566("pages", (class_2520)list);
        stack.method_7948().method_10582("title", "/polymer starts");
        stack.method_7948().method_10582("author", player.method_7334().getName());
        player.method_17355(new class_3908(){

            public class_2561 method_5476() {
                return class_2561.method_43473();
            }

            @Nullable
            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                class_3916 lectern = new class_3916(syncId){

                    public boolean method_7613(class_1799 stack, class_1735 slot) {
                        return false;
                    }

                    public boolean method_7615(class_1735 slot) {
                        return false;
                    }

                    public boolean method_7604(class_1657 player, int id) {
                        if (id == 3) {
                            return false;
                        }
                        return super.method_7604(player, id);
                    }

                    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
                    }
                };
                lectern.method_7611(0).method_48931(stack);
                return lectern;
            }
        });
        return 1;
    }

    private static int stats(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        class_2499 list = new class_2499();
        int line = 0;
        class_5250 text = null;
        class_3448 type = (class_3448)class_7733.method_45602(context, (String)"type", (class_5321)class_7924.field_41226).comp_349();
        for (Object statObj : type.method_14959()) {
            class_2561 title;
            if (!PolymerUtils.isServerOnly(statObj) || !type.method_14958(statObj)) continue;
            class_3445 stat = type.method_14956(statObj);
            if (text == null) {
                text = class_2561.method_43470((String)"");
            }
            int statVal = player.method_14248().method_15025(stat);
            if (statObj instanceof PolymerStat) {
                PolymerStat stat1 = (PolymerStat)statObj;
                title = PolymerStat.getName(stat1);
            } else if (statObj instanceof class_1792) {
                class_1792 item = (class_1792)statObj;
                title = item.method_7848();
            } else if (statObj instanceof class_2248) {
                class_2248 item = (class_2248)statObj;
                title = item.method_9518();
            } else if (statObj instanceof class_1299) {
                class_1299 item = (class_1299)statObj;
                title = item.method_5897();
            } else {
                title = class_2561.method_43471((String)class_156.method_646((String)type.method_14959().method_30517().method_29177().method_12832(), (class_2960)type.method_14959().method_10221(statObj)));
            }
            text.method_10852(title).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(stat.method_14953(statVal) + "\n")).method_27692(class_124.field_1063));
            if (++line != 13) continue;
            list.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)text)));
            text = null;
            line = 0;
        }
        if (text != null) {
            list.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867(text)));
        }
        final class_1799 stack = new class_1799((class_1935)class_1802.field_8360);
        stack.method_7948().method_10566("pages", (class_2520)list);
        stack.method_7948().method_10582("title", "/polymer starts");
        stack.method_7948().method_10582("author", player.method_7334().getName());
        player.method_17355(new class_3908(){

            public class_2561 method_5476() {
                return class_2561.method_43473();
            }

            @Nullable
            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                class_3916 lectern = new class_3916(syncId){

                    public boolean method_7613(class_1799 stack, class_1735 slot) {
                        return false;
                    }

                    public boolean method_7615(class_1735 slot) {
                        return false;
                    }

                    public boolean method_7604(class_1657 player, int id) {
                        if (id == 3) {
                            return false;
                        }
                        return super.method_7604(player, id);
                    }

                    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
                    }
                };
                lectern.method_7611(0).method_48931(stack);
                return lectern;
            }
        });
        return 1;
    }

    private static int creativeTab(CommandContext<class_2168> context) {
        if (((class_2168)context.getSource()).method_44023().method_7337()) {
            try {
                class_2960 id = (class_2960)context.getArgument("itemGroup", class_2960.class);
                class_1761 itemGroup = (class_1761)class_7923.field_44687.method_10223(id);
                if (itemGroup != null) {
                    new CreativeTabUi(((class_2168)context.getSource()).method_44023(), itemGroup);
                    return 2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            new CreativeTabListUi(((class_2168)context.getSource()).method_44023());
            return 1;
        }
        return 0;
    }

    private static int displayClientItem(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        class_1799 stack = PolymerItemUtils.getPolymerItemStack(player.method_6047(), player);
        stack.method_7948().method_10551("Polymer$itemId");
        stack.method_7948().method_10551("Polymer$itemTag");
        ((class_2168)context.getSource()).method_9226(() -> new class_5628("", 3).method_32305((class_2520)ServerTranslationUtils.parseFor(player.field_13987, stack).method_7953(new class_2487())), false);
        return 1;
    }

    private static int getClientItem(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        class_1799 stack = PolymerItemUtils.getPolymerItemStack(player.method_6047(), player);
        stack.method_7948().method_10551("Polymer$itemId");
        stack.method_7948().method_10551("Polymer$itemTag");
        player.method_7270(ServerTranslationUtils.parseFor(player.field_13987, stack));
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Given client representation to player"), true);
        return 1;
    }
}

