/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.api.utils;

import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.common.impl.client.ClientUtils;
import eu.pb4.polymer.core.api.block.PolymerBlockUtils;
import eu.pb4.polymer.core.api.entity.PolymerEntityUtils;
import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import eu.pb4.polymer.core.api.utils.PolymerObject;
import eu.pb4.polymer.core.api.utils.PolymerSyncUtils;
import eu.pb4.polymer.core.impl.PolymerImpl;
import eu.pb4.polymer.core.impl.PolymerImplUtils;
import eu.pb4.polymer.core.impl.interfaces.PolymerNetworkHandlerExtension;
import eu.pb4.polymer.core.mixin.block.packet.ThreadedAnvilChunkStorageAccessor;
import eu.pb4.polymer.core.mixin.entity.ServerWorldAccessor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2649;
import net.minecraft.class_2672;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3215;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3852;
import net.minecraft.class_3898;
import net.minecraft.class_7696;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public final class PolymerUtils {
    private static final Set<class_7696> ENABLED_FEATURE_FLAGS = new HashSet<class_7696>();
    public static final String ID = "polymer";
    public static final String NO_TEXTURE_HEAD_VALUE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNGUyY2UzMzcyYTNhYzk3ZmRkYTU2MzhiZWYyNGIzYmM0OWY0ZmFjZjc1MWZlOWNhZDY0NWYxNWE3ZmI4Mzk3YyJ9fX0=";

    private PolymerUtils() {
    }

    public static String getVersion() {
        return CommonImpl.VERSION;
    }

    @Nullable
    public static class_3222 getPlayerContext() {
        return PolymerCommonUtils.getPlayerContext();
    }

    public static boolean isSingleplayer() {
        if (!PolymerImpl.IS_CLIENT) {
            return false;
        }
        return ClientUtils.isSingleplayer();
    }

    public static boolean isOnClientThread() {
        if (!PolymerImpl.IS_CLIENT) {
            return false;
        }
        return ClientUtils.isClientThread();
    }

    public static boolean isOnPlayerNetworking() {
        if (!PolymerImpl.IS_CLIENT) {
            return PolymerUtils.getPlayerContext() != null;
        }
        return PolymerUtils.getPlayerContext() != null || ClientUtils.isSingleplayer();
    }

    public static void addClientEnabledFeatureFlags(class_7696 ... flags) {
        ENABLED_FEATURE_FLAGS.addAll(List.of(flags));
    }

    public static Collection<class_7696> getClientEnabledFeatureFlags() {
        return ENABLED_FEATURE_FLAGS;
    }

    public static void schedulePacket(class_3244 handler, class_2596<?> packet, int duration) {
        ((PolymerNetworkHandlerExtension)handler).polymer$schedulePacket(packet, duration);
    }

    public static void reloadWorld(class_3222 player) {
        player.field_13995.execute(() -> {
            PolymerSyncUtils.synchronizePolymerRegistries(player.field_13987);
            player.field_13987.method_14364((class_2596)new class_2649(0, 0, player.field_7498.method_7602(), player.field_7498.method_34255()));
            class_1937 world = player.method_37908();
            ThreadedAnvilChunkStorageAccessor tacsAccess = (ThreadedAnvilChunkStorageAccessor)((class_3215)player.method_37908().method_8398()).field_17254;
            int dist = tacsAccess.polymer$getWatchDistance();
            int playerX = player.method_14232().method_10263();
            int playerZ = player.method_14232().method_10260();
            for (class_1297 e : ((ServerWorldAccessor)player.method_37908()).polymer_getEntityManager().method_31841().method_31803()) {
                class_3898.class_3208 tracker = (class_3898.class_3208)tacsAccess.polymer$getEntityTrackers().get(e.method_5628());
                if (tracker == null) continue;
                tracker.method_18733(player);
            }
            ArrayList<class_2818> toSend = new ArrayList<class_2818>();
            for (int x = -dist; x <= dist; ++x) {
                for (int z = -dist; z <= dist; ++z) {
                    class_2818 chunk = (class_2818)world.method_8402(x + playerX, z + playerZ, class_2806.field_12803, false);
                    if (chunk == null) continue;
                    toSend.add(chunk);
                }
            }
            PolymerNetworkHandlerExtension.of(player.field_13987).polymer$delayAction("polymer:reload/send_chunks/0", 1, () -> PolymerUtils.nestedSend(player, 0, toSend));
        });
    }

    private static void nestedSend(class_3222 player, int iteration, List<class_2818> chunks) {
        ThreadedAnvilChunkStorageAccessor tacsAccess = (ThreadedAnvilChunkStorageAccessor)((class_3215)player.method_37908().method_8398()).field_17254;
        ListIterator<class_2818> iterator = chunks.listIterator();
        for (int pos = 0; iterator.hasNext() && pos < 15; ++pos) {
            class_2818 chunk = iterator.next();
            iterator.remove();
            tacsAccess.polymer$sendChunkDataPackets(player, (MutableObject<class_2672>)new MutableObject(), chunk);
        }
        if (chunks.size() != 0) {
            int finalIteration = iteration + 1;
            PolymerNetworkHandlerExtension.of(player.field_13987).polymer$delayAction("polymer:reload/send_chunks/" + finalIteration, 1, () -> PolymerUtils.nestedSend(player, finalIteration, chunks));
        }
    }

    public static void reloadInventory(class_3222 player) {
        player.field_13987.method_14364((class_2596)new class_2649(0, 0, player.field_7498.method_7602(), player.field_7498.method_34255()));
    }

    public static class_1836 getTooltipContext(@Nullable class_3222 player) {
        return PolymerImplUtils.getTooltipContext(player);
    }

    public static class_1836 getCreativeTooltipContext(@Nullable class_3222 player) {
        return PolymerImplUtils.getTooltipContext(player).withCreative();
    }

    public static class_2487 createSkullOwner(String value) {
        class_2487 skullOwner = new class_2487();
        class_2487 properties = new class_2487();
        class_2487 data = new class_2487();
        class_2499 textures = new class_2499();
        textures.method_10533(0, (class_2520)data);
        data.method_10582("Value", value);
        properties.method_10566("textures", (class_2520)textures);
        skullOwner.method_10566("Properties", (class_2520)properties);
        skullOwner.method_10539("Id", new int[]{0, 0, 0, 0});
        return skullOwner;
    }

    public static class_1799 createPlayerHead(String value) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8575);
        stack.method_7948().method_10566("SkullOwner", (class_2520)PolymerUtils.createSkullOwner(value));
        return stack;
    }

    public static void executeWithPlayerContext(class_3222 player, Runnable runnable) {
        PolymerCommonUtils.executeWithPlayerContext((class_3222)player, (Runnable)runnable);
    }

    public static class_1937 getFakeWorld() {
        return PolymerCommonUtils.getFakeWorld();
    }

    @Nullable
    public static Path getClientJar() {
        return PolymerCommonUtils.getClientJar();
    }

    public static boolean isServerOnly(Object obj) {
        class_3852 villagerProfession;
        class_2591 typeBE;
        class_1299 type;
        class_1799 stack;
        return obj instanceof PolymerObject || obj instanceof class_1799 && PolymerItemUtils.isPolymerServerItem(stack = (class_1799)obj) || obj instanceof class_1299 && PolymerEntityUtils.isRegisteredEntityType(type = (class_1299)obj) || obj instanceof class_2591 && PolymerBlockUtils.isPolymerBlockEntityType(typeBE = (class_2591)obj) || obj instanceof class_3852 && PolymerEntityUtils.getPolymerProfession(villagerProfession = (class_3852)obj) != null;
    }

    public static boolean hasResourcePack(@Nullable class_3222 player) {
        return PolymerCommonUtils.hasResourcePack((class_3222)player);
    }
}

