/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.api.item;

import com.google.common.collect.Multimap;
import eu.pb4.polymer.common.api.events.BooleanEvent;
import eu.pb4.polymer.common.api.events.FunctionEvent;
import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.core.api.item.PolymerItem;
import eu.pb4.polymer.core.api.utils.PolymerObject;
import eu.pb4.polymer.core.api.utils.PolymerSyncedObject;
import eu.pb4.polymer.core.api.utils.PolymerUtils;
import eu.pb4.polymer.core.impl.PolymerImpl;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1836;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class PolymerItemUtils {
    public static final String POLYMER_ITEM_ID = "Polymer$itemId";
    public static final String REAL_TAG = "Polymer$itemTag";
    public static final String ITEM_FRAME_NAME_TAG = "Polymer$itemName";
    public static final class_2583 CLEAN_STYLE = class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1068);
    public static final class_2583 NON_ITALIC_STYLE = class_2583.field_24360.method_10978(Boolean.valueOf(false));
    public static final BooleanEvent<Predicate<class_1799>> ITEM_CHECK = new BooleanEvent();
    public static final FunctionEvent<ItemModificationEventHandler, class_1799> ITEM_MODIFICATION_EVENT = new FunctionEvent();
    private static final String[] NBT_TO_COPY = new String[]{"CanDestroy", "CanPlaceOn", "BlockEntityTag", "Trim", "LodestoneDimension", "LodestonePos", "LodestoneTracked"};

    private PolymerItemUtils() {
    }

    public static class_1799 getPolymerItemStack(class_1799 itemStack, @Nullable class_3222 player) {
        return PolymerItemUtils.getPolymerItemStack(itemStack, PolymerUtils.getTooltipContext(player), player);
    }

    public static class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipContext, @Nullable class_3222 player) {
        if (PolymerItemUtils.getPolymerIdentifier(itemStack) != null) {
            return itemStack;
        }
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof PolymerItem) {
            PolymerItem item = (PolymerItem)class_17922;
            return item.getPolymerItemStack(itemStack, tooltipContext, player);
        }
        if (PolymerItemUtils.shouldPolymerConvert(itemStack, player)) {
            return PolymerItemUtils.createItemStack(itemStack, tooltipContext, player);
        }
        if (ITEM_CHECK.invoke(x -> x.test(itemStack))) {
            return PolymerItemUtils.createItemStack(itemStack, player);
        }
        return itemStack;
    }

    public static class_1799 getRealItemStack(class_1799 itemStack) {
        String id;
        class_1799 out = itemStack;
        if (itemStack.method_7985() && (id = itemStack.method_7969().method_10558(POLYMER_ITEM_ID)) != null && !id.isEmpty()) {
            try {
                class_2960 identifier = class_2960.method_12829((String)id);
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(identifier);
                if (item != class_1802.field_8162) {
                    out = new class_1799((class_1935)item, itemStack.method_7947());
                    class_2487 tag = itemStack.method_7941(REAL_TAG);
                    if (tag != null) {
                        out.method_7980(tag);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return out;
    }

    @Nullable
    public static class_2960 getPolymerIdentifier(class_1799 itemStack) {
        if (itemStack.method_7985()) {
            return PolymerItemUtils.getIdentifierFrom(itemStack.method_7969(), POLYMER_ITEM_ID);
        }
        return null;
    }

    @Nullable
    public static class_2960 getServerIdentifier(class_1799 itemStack) {
        if (itemStack.method_7985()) {
            class_2960 id = PolymerItemUtils.getIdentifierFrom(itemStack.method_7969(), POLYMER_ITEM_ID);
            if (id == null) {
                id = PolymerItemUtils.getIdentifierFrom(itemStack.method_7969(), "PolyMcId");
            }
            return id;
        }
        return null;
    }

    @Nullable
    private static class_2960 getIdentifierFrom(class_2487 compound, String nbtKey) {
        String id = compound.method_10558(nbtKey);
        if (id != null && !id.isEmpty()) {
            return class_2960.method_12829((String)id);
        }
        return null;
    }

    @Nullable
    public static class_2487 getPolymerNbt(class_1799 itemStack) {
        if (PolymerItemUtils.getPolymerIdentifier(itemStack) != null && itemStack.method_7969().method_10573(REAL_TAG, 10)) {
            return itemStack.method_7969().method_10562(REAL_TAG);
        }
        return null;
    }

    public static boolean isPolymerServerItem(class_1799 itemStack) {
        return PolymerItemUtils.shouldPolymerConvert(itemStack, null);
    }

    private static boolean shouldPolymerConvert(class_1799 itemStack, @Nullable class_3222 player) {
        if (PolymerItemUtils.getPolymerIdentifier(itemStack) != null) {
            return false;
        }
        if (itemStack.method_7909() instanceof PolymerItem) {
            return true;
        }
        if (itemStack.method_7985()) {
            class_2487 display;
            if (itemStack.method_7942()) {
                for (class_2520 enchantment : itemStack.method_7921()) {
                    id = ((class_2487)enchantment).method_10558("id");
                    ench = (class_1887)class_7923.field_41176.method_10223(class_2960.method_12829((String)id));
                    if (!(ench instanceof PolymerObject) || ench instanceof PolymerSyncedObject && (polymerEnchantment = (PolymerSyncedObject)ench).getPolymerReplacement(player) == ench) continue;
                    return true;
                }
            } else if (itemStack.method_7969().method_10573("StoredEnchantments", 9)) {
                for (class_2520 enchantment : itemStack.method_7969().method_10554("StoredEnchantments", 10)) {
                    id = ((class_2487)enchantment).method_10558("id");
                    ench = (class_1887)class_7923.field_41176.method_10223(class_2960.method_12829((String)id));
                    if (!(ench instanceof PolymerObject) || ench instanceof PolymerSyncedObject && (polymerEnchantment = (PolymerSyncedObject)ench).getPolymerReplacement(player) == ench) continue;
                    return true;
                }
            } else if (itemStack.method_7909() instanceof class_1812) {
                if (class_1844.method_8063((class_1799)itemStack) instanceof PolymerObject) {
                    return true;
                }
                for (class_1293 statusEffectInstance : class_1844.method_8067((class_1799)itemStack)) {
                    if (!(statusEffectInstance.method_5579() instanceof PolymerObject)) continue;
                    return true;
                }
            }
            if (itemStack.method_7969().method_10573("ChargedProjectiles", 9)) {
                for (class_2520 itemNbt : itemStack.method_7969().method_10554("ChargedProjectiles", 10)) {
                    if (!PolymerItemUtils.shouldPolymerConvert(class_1799.method_7915((class_2487)((class_2487)itemNbt)), player)) continue;
                    return true;
                }
            }
            if (itemStack.method_7969().method_10573("Items", 9)) {
                for (class_2520 itemNbt : itemStack.method_7969().method_10554("Items", 10)) {
                    if (!PolymerItemUtils.shouldPolymerConvert(class_1799.method_7915((class_2487)((class_2487)itemNbt)), player)) continue;
                    return true;
                }
            }
            if (CompatStatus.POLYMER_RESOURCE_PACK && (display = itemStack.method_7941("display")) != null && display.method_10573("color", 3)) {
                int color = display.method_10550("color");
                return PolymerResourcePackUtils.isColorTaken((int)color);
            }
        }
        return false;
    }

    public static class_1799 createMinimalItemStack(class_1799 itemStack, @Nullable class_3222 player) {
        class_1792 item = itemStack.method_7909();
        int cmd = -1;
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof PolymerItem) {
            PolymerItem virtualItem = (PolymerItem)class_17922;
            ItemWithMetadata data = PolymerItemUtils.getItemSafely(virtualItem, itemStack, player);
            item = data.item();
            cmd = data.customModelData();
        }
        class_1799 out = new class_1799((class_1935)item, itemStack.method_7947());
        if (itemStack.method_7969() != null) {
            out.method_7948().method_10566(REAL_TAG, (class_2520)itemStack.method_7969());
        }
        out.method_7948().method_10582(POLYMER_ITEM_ID, class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString());
        if (cmd != -1) {
            out.method_7948().method_10569("CustomModelData", cmd);
        }
        return out;
    }

    public static int getSafeColor(int inputColor) {
        if (inputColor % 2 == 1) {
            return Math.max(0, inputColor - 1);
        }
        return inputColor;
    }

    public static class_1799 createItemStack(class_1799 itemStack, @Nullable class_3222 player) {
        return PolymerItemUtils.createItemStack(itemStack, PolymerUtils.getTooltipContext(player), player);
    }

    public static class_1799 createItemStack(class_1799 itemStack, class_1836 tooltipContext, @Nullable class_3222 player) {
        class_2499 lore;
        class_1799 out;
        int color;
        int cmd;
        block41: {
            block40: {
                class_1792 item = itemStack.method_7909();
                cmd = -1;
                color = -1;
                class_1792 class_17922 = itemStack.method_7909();
                if (class_17922 instanceof PolymerItem) {
                    PolymerItem virtualItem = (PolymerItem)class_17922;
                    ItemWithMetadata data = PolymerItemUtils.getItemSafely(virtualItem, itemStack, player);
                    item = data.item();
                    cmd = data.customModelData();
                    color = data.color();
                }
                out = new class_1799((class_1935)item, itemStack.method_7947());
                out.method_7948().method_10582(POLYMER_ITEM_ID, class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString());
                out.method_7969().method_10569("HideFlags", 255);
                lore = new class_2499();
                if (itemStack.method_7969() != null) {
                    block39: {
                        int dmg;
                        class_2487 display;
                        out.method_7969().method_10566(REAL_TAG, (class_2520)itemStack.method_7969());
                        assert (out.method_7969() != null);
                        int n = cmd = cmd == -1 && itemStack.method_7969().method_10545("CustomModelData") ? itemStack.method_7969().method_10550("CustomModelData") : cmd;
                        if (color == -1 && itemStack.method_7969().method_10573("display", 10) && (display = itemStack.method_7941("display")).method_10573("color", 3) && (color = display.method_10550("color")) % 2 == 1) {
                            color = Math.max(0, color - 1);
                        }
                        if ((dmg = itemStack.method_7919()) != 0) {
                            out.method_7969().method_10569("Damage", (int)((double)dmg / (double)itemStack.method_7909().method_7841() * (double)item.method_7841()));
                        }
                        if (itemStack.method_7942()) {
                            list = new class_2499();
                            for (class_2520 enchNbt : itemStack.method_7921()) {
                                class_1887 ench = (class_1887)class_7923.field_41176.method_10223(class_1890.method_37427((class_2487)((class_2487)enchNbt)));
                                if (ench instanceof PolymerSyncedObject) {
                                    PolymerSyncedObject polyEnch = (PolymerSyncedObject)ench;
                                    class_1887 possible = (class_1887)polyEnch.getPolymerReplacement(player);
                                    if (possible == null) continue;
                                    list.add((Object)class_1890.method_37426((class_2960)class_7923.field_41176.method_10221((Object)possible), (int)class_1890.method_37424((class_2487)((class_2487)enchNbt))));
                                    continue;
                                }
                                if (ench instanceof PolymerObject) continue;
                                list.add((Object)enchNbt.method_10707());
                            }
                            if (list.isEmpty()) {
                                list.add((Object)new class_2487());
                            }
                            out.method_7969().method_10566("Enchantments", (class_2520)list);
                        } else if (itemStack.method_7958()) {
                            list = new class_2499();
                            list.add((Object)new class_2487());
                            out.method_7969().method_10566("Enchantments", (class_2520)list);
                        }
                        if (itemStack.method_7909() instanceof class_1812) {
                            out.method_7948().method_10569("CustomPotionColor", class_1844.method_8064((class_1799)itemStack));
                        }
                        for (int i = 0; i < NBT_TO_COPY.length; ++i) {
                            String key = NBT_TO_COPY[i];
                            class_2520 tag = itemStack.method_7969().method_10580(key);
                            if (tag == null) continue;
                            out.method_7969().method_10566(key, tag);
                        }
                        if (class_1764.method_7781((class_1799)itemStack)) {
                            class_1764.method_7782((class_1799)out, (boolean)true);
                        }
                        try {
                            if (itemStack.method_7969().method_10573("ChargedProjectiles", 9)) {
                                class_2499 outList = new class_2499();
                                for (class_2520 itemNbt : itemStack.method_7969().method_10554("ChargedProjectiles", 10)) {
                                    outList.add((Object)PolymerItemUtils.getPolymerItemStack(class_1799.method_7915((class_2487)((class_2487)itemNbt)), tooltipContext, player).method_7953(new class_2487()));
                                }
                                out.method_7969().method_10566("ChargedProjectiles", (class_2520)outList);
                            }
                        }
                        catch (Throwable e) {
                            if (!PolymerImpl.LOG_MORE_ERRORS) break block39;
                            e.printStackTrace();
                        }
                    }
                    try {
                        if (itemStack.method_7969().method_10573("Items", 9)) {
                            class_2499 outList = new class_2499();
                            for (class_2520 itemNbt : itemStack.method_7969().method_10554("Items", 10)) {
                                class_2487 base = new class_2487();
                                class_2520 slot = ((class_2487)itemNbt).method_10580("Slot");
                                if (slot != null) {
                                    base.method_10566("Slot", slot);
                                }
                                outList.add((Object)PolymerItemUtils.getPolymerItemStack(class_1799.method_7915((class_2487)((class_2487)itemNbt)), tooltipContext, player).method_7953(base));
                            }
                            out.method_7969().method_10566("Items", (class_2520)outList);
                        }
                        break block40;
                    }
                    catch (Throwable e) {
                        if (PolymerImpl.LOG_MORE_ERRORS) {
                            e.printStackTrace();
                        }
                        break block40;
                    }
                }
                if (itemStack.method_7958()) {
                    class_2499 list = new class_2499();
                    list.add((Object)new class_2487());
                    out.method_7969().method_10566("Enchantments", (class_2520)list);
                }
            }
            for (class_1304 slot : class_1304.values()) {
                Multimap multimap = itemStack.method_7926(slot);
                for (Map.Entry entry : multimap.entries()) {
                    out.method_7916((class_1320)entry.getKey(), (class_1322)entry.getValue(), slot);
                }
            }
            try {
                List tooltip = itemStack.method_7950((class_1657)player, tooltipContext);
                class_5250 name = (class_5250)tooltip.remove(0);
                if (!out.method_7964().equals(name)) {
                    name.method_10862(name.method_10866().method_27702(NON_ITALIC_STYLE));
                    out.method_7977((class_2561)name);
                }
                if (itemStack.method_7909() instanceof PolymerItem) {
                    ((PolymerItem)itemStack.method_7909()).modifyClientTooltip(tooltip, itemStack, player);
                }
                for (class_2561 t : tooltip) {
                    lore.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)class_2561.method_43473().method_10852(t).method_10862(CLEAN_STYLE))));
                }
            }
            catch (Throwable e) {
                if (PolymerImpl.LOG_MORE_ERRORS) {
                    PolymerImpl.LOGGER.error("Failed to get tooltip of " + itemStack, e);
                }
                try {
                    class_5250 name = itemStack.method_7964().method_27661();
                    if (!out.method_7964().equals(name)) {
                        name.method_10862(name.method_10866().method_27702(NON_ITALIC_STYLE));
                        out.method_7977((class_2561)name);
                    }
                }
                catch (Throwable e2) {
                    if (!PolymerImpl.LOG_MORE_ERRORS) break block41;
                    PolymerImpl.LOGGER.error("Failed for second time. Ignoring.", e2);
                }
            }
        }
        class_2487 outNbt = out.method_7948();
        if (lore.size() > 0) {
            outNbt.method_10562("display").method_10566("Lore", (class_2520)lore);
        }
        if (color != -1) {
            outNbt.method_10562("display").method_10569("color", color);
        }
        if (cmd != -1) {
            outNbt.method_10569("CustomModelData", cmd);
        }
        return (class_1799)ITEM_MODIFICATION_EVENT.invoke(col -> {
            class_1799 custom = out;
            for (ItemModificationEventHandler in : col) {
                custom = in.modifyItem(itemStack, custom, player);
            }
            return custom;
        });
    }

    public static ItemWithMetadata getItemSafely(PolymerItem item, class_1799 stack, @Nullable class_3222 player, int maxDistance) {
        PolymerItem newItem;
        class_1792 out = item.getPolymerItem(stack, player);
        PolymerItem lastVirtual = item;
        for (int req = 0; out instanceof PolymerItem && (newItem = (PolymerItem)out) != item && req < maxDistance; ++req) {
            out = newItem.getPolymerItem(stack, player);
            lastVirtual = newItem;
        }
        return new ItemWithMetadata(out, lastVirtual.getPolymerCustomModelData(stack, player), lastVirtual.getPolymerArmorColor(stack, player));
    }

    public static ItemWithMetadata getItemSafely(PolymerItem item, class_1799 stack, @Nullable class_3222 player) {
        return PolymerItemUtils.getItemSafely(item, stack, player, 32);
    }

    public record ItemWithMetadata(class_1792 item, int customModelData, int color) {
    }

    @FunctionalInterface
    public static interface ItemModificationEventHandler {
        public class_1799 modifyItem(class_1799 var1, class_1799 var2, class_3222 var3);
    }
}

