/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.common.api;

import eu.pb4.polymer.common.api.events.SimpleEvent;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.common.impl.CommonResourcePackInfoHolder;
import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.common.impl.FakeWorld;
import eu.pb4.polymer.common.impl.client.ClientUtils;
import eu.pb4.polymer.common.impl.compat.FloodGateUtils;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public final class PolymerCommonUtils {
    public static final SimpleEvent<ResourcePackChangeCallback> ON_RESOURCE_PACK_STATUS_CHANGE = new SimpleEvent();
    private static final String SAFE_CLIENT_SHA1 = "e575a48efda46cf88111ba05b624ef90c520eef1";
    private static final String SAFE_CLIENT_URL = "https://piston-data.mojang.com/v1/objects/e575a48efda46cf88111ba05b624ef90c520eef1/client.jar";

    private PolymerCommonUtils() {
    }

    @Nullable
    public static Path getClientJar() {
        try {
            URI clientFile;
            Path clientJarPath;
            if (CommonImpl.IS_CLIENT && Files.exists(clientJarPath = Path.of(clientFile = MinecraftServer.class.getProtectionDomain().getCodeSource().getLocation().toURI()), new LinkOption[0])) {
                return clientJarPath;
            }
            Path clientJarPath2 = CommonImpl.getGameDir().resolve("polymer/cached_client_jars/e575a48efda46cf88111ba05b624ef90c520eef1.jar");
            if (!Files.exists(clientJarPath2, new LinkOption[0])) {
                Files.createDirectories(clientJarPath2.getParent(), new FileAttribute[0]);
                CommonImpl.LOGGER.info("Downloading vanilla client jar...");
                URL url = new URL(SAFE_CLIENT_URL);
                URLConnection connection = url.openConnection();
                InputStream is = connection.getInputStream();
                Files.copy(is, clientJarPath2, new CopyOption[0]);
            }
            return clientJarPath2;
        }
        catch (Exception e) {
            CommonImpl.LOGGER.error("Couldn't retrieve client jar!", (Throwable)e);
            return null;
        }
    }

    public static void executeWithPlayerContext(class_3222 player, Runnable runnable) {
        class_3222 oldPlayer = CommonImplUtils.getPlayer();
        class_3222 oldTarget = PacketContext.get().getTarget();
        CommonImplUtils.setPlayer(player);
        PacketContext.setReadContext((class_3244)player.field_13987);
        runnable.run();
        CommonImplUtils.setPlayer(oldPlayer);
        PacketContext.setReadContext((class_3244)(oldTarget != null ? oldTarget.field_13987 : null));
    }

    public static class_1937 getFakeWorld() {
        return FakeWorld.INSTANCE;
    }

    @Nullable
    public static class_3222 getPlayerContext() {
        class_3222 player = PacketContext.get().getTarget();
        if (player == null && (player = CommonImplUtils.getPlayer()) == null && CommonImpl.IS_CLIENT) {
            player = ClientUtils.getPlayer();
        }
        return player;
    }

    public static boolean isBedrockPlayer(class_3222 player) {
        if (CompatStatus.FLOODGATE) {
            return FloodGateUtils.isPlayerBroken(player);
        }
        return false;
    }

    public static boolean hasResourcePack(@Nullable class_3222 player) {
        return CommonImpl.FORCE_RESOURCEPACK_ENABLED_STATE || player != null && ((CommonResourcePackInfoHolder)player).polymerCommon$hasResourcePack() || player != null && ((CommonResourcePackInfoHolder)player).polymerCommon$hasResourcePack() || CommonImpl.IS_CLIENT && ClientUtils.isResourcePackLoaded();
    }

    public static interface ResourcePackChangeCallback {
        public void onResourcePackChange(class_3244 var1, boolean var2, boolean var3);
    }
}

