/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.impl.textparser;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.pb4.placeholders.api.node.LiteralNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.parsers.TextParserV1;
import eu.pb4.placeholders.impl.GeneralUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_2572;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_7417;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class TextParserImpl {
    public static final Pattern STARTING_PATTERN = Pattern.compile("<(?<id>[^<>/]+)(?<data>([:]([']?([^'](\\\\\\\\['])?)+[']?))*)>");
    @Deprecated
    public static final List<GeneralUtils.Pair<String, String>> ESCAPED_CHARS = new ArrayList<GeneralUtils.Pair<String, String>>();
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().registerTypeHierarchyAdapter(class_2583.class, (Object)new class_2583.class_2584()).create();
    public static final TextNode[] CASTER;

    public static TextNode[] parse(String string, TextParserV1.TagParserGetter handlers) {
        return TextParserImpl.recursiveParsing(TextParserImpl.escapeCharacters(string), handlers, null).nodes();
    }

    public static String escapeCharacters(String string) {
        for (GeneralUtils.Pair<String, String> entry : ESCAPED_CHARS) {
            string = string.replace("\\" + entry.left(), entry.right());
        }
        return string;
    }

    public static String removeEscaping(String string) {
        for (GeneralUtils.Pair<String, String> entry : ESCAPED_CHARS) {
            try {
                string = string.replace(entry.right(), entry.left());
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public static String restoreOriginalEscaping(String string) {
        for (GeneralUtils.Pair<String, String> entry : ESCAPED_CHARS) {
            try {
                string = string.replace(entry.right(), "\\" + entry.left());
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public static String cleanArgument(String string) {
        if (string.length() >= 2 && string.startsWith("'") && string.endsWith("'")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static TextParserV1.NodeList recursiveParsing(String input, TextParserV1.TagParserGetter handlers, String endAt) {
        String restOfText;
        int currentEnd;
        if (input.isEmpty()) {
            return new TextParserV1.NodeList(new TextNode[0], 0);
        }
        ArrayList<TextNode> text = new ArrayList<TextNode>();
        Matcher matcher = STARTING_PATTERN.matcher(input);
        Matcher matcherEnd = endAt != null ? Pattern.compile(endAt).matcher(input) : null;
        int currentPos = 0;
        boolean offset = false;
        boolean hasEndTag = endAt != null && matcherEnd.find();
        int n = currentEnd = hasEndTag ? matcherEnd.start() : input.length();
        while (matcher.find() && currentEnd > matcher.start()) {
            String[] entireTag = (matcher.group("id") + matcher.group("data")).split(":", 2);
            String tag = entireTag[0].toLowerCase(Locale.ROOT);
            String data = "";
            if (entireTag.length == 2) {
                data = entireTag[1];
            }
            if (tag.equals("reset") || tag.equals("r")) {
                if (endAt != null) {
                    String restOfText2;
                    currentEnd = matcher.start();
                    if (currentPos < currentEnd && (restOfText2 = TextParserImpl.restoreOriginalEscaping(input.substring(currentPos, currentEnd))).length() != 0) {
                        text.add(new LiteralNode(restOfText2));
                    }
                    return new TextParserV1.NodeList(text.toArray(new TextNode[0]), currentEnd);
                }
                String betweenText = input.substring(currentPos, matcher.start());
                if (betweenText.length() != 0) {
                    text.add(new LiteralNode(TextParserImpl.restoreOriginalEscaping(betweenText)));
                }
                currentPos = matcher.end();
                continue;
            }
            if (tag.startsWith("#")) {
                data = tag;
                tag = "color";
            }
            String end = "</" + tag + ">";
            TextParserV1.TagNodeBuilder handler = handlers.getTagParser(tag);
            if (handler == null) continue;
            String betweenText = input.substring(currentPos, matcher.start());
            if (betweenText.length() != 0) {
                text.add(new LiteralNode(TextParserImpl.restoreOriginalEscaping(betweenText)));
            }
            currentPos = matcher.end();
            try {
                TextParserV1.TagNodeValue pair = handler.parseString(tag, data, input.substring(currentPos), handlers, end);
                if (pair.node() != null) {
                    text.add(pair.node());
                }
                if ((currentPos += pair.length()) >= input.length()) {
                    currentEnd = input.length();
                    break;
                }
                matcher.region(currentPos, input.length());
                if (matcherEnd == null) continue;
                matcherEnd.region(currentPos, input.length());
                if (matcherEnd.find()) {
                    hasEndTag = true;
                    currentEnd = matcherEnd.start();
                    continue;
                }
                hasEndTag = false;
                currentEnd = input.length();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (currentPos < currentEnd && (restOfText = TextParserImpl.restoreOriginalEscaping(input.substring(currentPos, currentEnd))).length() != 0) {
            text.add(new LiteralNode(restOfText));
        }
        currentEnd = hasEndTag ? (currentEnd += endAt.length()) : input.length();
        return new TextParserV1.NodeList(text.toArray(new TextNode[0]), currentEnd);
    }

    @ApiStatus.Experimental
    public static String convertToString(class_2561 text) {
        class_7417 class_74172;
        StringBuilder builder = new StringBuilder();
        String style = GSON.toJson((Object)text.method_10866());
        if (style != null && !style.equals("null")) {
            builder.append("<style:").append(style).append(">");
        }
        if ((class_74172 = text.method_10851()) instanceof class_2585) {
            class_2585 literalText = (class_2585)class_74172;
            builder.append(TextParserImpl.escapeCharacters(literalText.comp_737()));
        } else {
            class_74172 = text.method_10851();
            if (class_74172 instanceof class_2588) {
                class_2588 translatableText = (class_2588)class_74172;
                ArrayList<Object> stringList = new ArrayList<Object>();
                for (Object arg : translatableText.method_11023()) {
                    if (arg instanceof class_2561) {
                        class_2561 text1 = (class_2561)arg;
                        stringList.add("'" + TextParserImpl.escapeCharacters(TextParserImpl.convertToString(text1)) + "'");
                        continue;
                    }
                    stringList.add("'" + TextParserImpl.escapeCharacters(arg.toString()) + "'");
                }
                if (stringList.size() > 0) {
                    stringList.add(0, "");
                }
                String additional = String.join((CharSequence)":", stringList);
                builder.append("<lang:'").append(translatableText.method_11022()).append("'").append(additional).append(">");
            } else {
                class_74172 = text.method_10851();
                if (class_74172 instanceof class_2572) {
                    class_2572 keybindText = (class_2572)class_74172;
                    builder.append("<key:'").append(keybindText.method_10901()).append("'>");
                } else {
                    builder.append("<raw:'").append(TextParserImpl.escapeCharacters(class_2561.class_2562.method_10867((class_2561)text.method_27661()))).append("'>");
                }
            }
        }
        for (class_2561 text1 : text.method_10855()) {
            builder.append(TextParserImpl.convertToString(text1));
        }
        if (style != null && !style.equals("null")) {
            builder.append("</style>");
        }
        return builder.toString();
    }

    static {
        ESCAPED_CHARS.add(new GeneralUtils.Pair<String, String>("\\", "&slsh;\u0002"));
        ESCAPED_CHARS.add(new GeneralUtils.Pair<String, String>("<", "&lt;\u0002"));
        ESCAPED_CHARS.add(new GeneralUtils.Pair<String, String>(">", "&gt;\u0002"));
        ESCAPED_CHARS.add(new GeneralUtils.Pair<String, String>("\"", "&quot;\u0002"));
        ESCAPED_CHARS.add(new GeneralUtils.Pair<String, String>("'", "&pos;\u0002"));
        ESCAPED_CHARS.add(new GeneralUtils.Pair<String, String>(":", "&colon;\u0002"));
        ESCAPED_CHARS.add(new GeneralUtils.Pair<String, String>("&", "&amps;\u0002"));
        ESCAPED_CHARS.add(new GeneralUtils.Pair<String, String>("{", "&openbrac;\u0002"));
        ESCAPED_CHARS.add(new GeneralUtils.Pair<String, String>("}", "&closebrac;\u0002"));
        ESCAPED_CHARS.add(new GeneralUtils.Pair<String, String>("$", "&dolar;\u0002"));
        ESCAPED_CHARS.add(new GeneralUtils.Pair<String, String>("%", "&perc;\u0002"));
        CASTER = new TextNode[0];
    }
}

