/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.impl.placeholder.builtin;

import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.minecraft.class_2960;
import net.minecraft.class_2995;

public class ServerPlaceholders {
    public static void register() {
        Placeholders.register(new class_2960("server", "tps"), (ctx, arg) -> {
            double tps = 1000.0f / Math.max(ctx.server().method_3830(), 50.0f);
            Object format = "%.1f";
            if (arg != null) {
                try {
                    int x = Integer.parseInt(arg);
                    format = "%." + x + "f";
                }
                catch (Exception e) {
                    format = "%.1f";
                }
            }
            return PlaceholderResult.value(String.format((String)format, tps));
        });
        Placeholders.register(new class_2960("server", "tps_colored"), (ctx, arg) -> {
            double tps = 1000.0f / Math.max(ctx.server().method_3830(), 50.0f);
            Object format = "%.1f";
            if (arg != null) {
                try {
                    int x = Integer.parseInt(arg);
                    format = "%." + x + "f";
                }
                catch (Exception e) {
                    format = "%.1f";
                }
            }
            return PlaceholderResult.value((class_2561)class_2561.method_43470((String)String.format((String)format, tps)).method_27692(tps > 19.0 ? class_124.field_1060 : (tps > 16.0 ? class_124.field_1065 : class_124.field_1061)));
        });
        Placeholders.register(new class_2960("server", "mspt"), (ctx, arg) -> PlaceholderResult.value(String.format("%.0f", Float.valueOf(ctx.server().method_3830()))));
        Placeholders.register(new class_2960("server", "mspt_colored"), (ctx, arg) -> {
            float x = ctx.server().method_3830();
            return PlaceholderResult.value((class_2561)class_2561.method_43470((String)String.format("%.0f", Float.valueOf(x))).method_27692(x < 45.0f ? class_124.field_1060 : (x < 51.0f ? class_124.field_1065 : class_124.field_1061)));
        });
        Placeholders.register(new class_2960("server", "time"), (ctx, arg) -> {
            SimpleDateFormat format = new SimpleDateFormat(arg != null ? arg : "HH:mm:ss");
            return PlaceholderResult.value(format.format(new Date(System.currentTimeMillis())));
        });
        Placeholders.register(new class_2960("server", "version"), (ctx, arg) -> PlaceholderResult.value(ctx.server().method_3827()));
        Placeholders.register(new class_2960("server", "mod_version"), (ctx, arg) -> {
            Optional container;
            if (arg != null && (container = FabricLoader.getInstance().getModContainer(arg)).isPresent()) {
                return PlaceholderResult.value((class_2561)class_2561.method_43470((String)((ModContainer)container.get()).getMetadata().getVersion().getFriendlyString()));
            }
            return PlaceholderResult.invalid("Invalid argument");
        });
        Placeholders.register(new class_2960("server", "mod_name"), (ctx, arg) -> {
            Optional container;
            if (arg != null && (container = FabricLoader.getInstance().getModContainer(arg)).isPresent()) {
                return PlaceholderResult.value((class_2561)class_2561.method_43470((String)((ModContainer)container.get()).getMetadata().getName()));
            }
            return PlaceholderResult.invalid("Invalid argument");
        });
        Placeholders.register(new class_2960("server", "mod_description"), (ctx, arg) -> {
            Optional container;
            if (arg != null && (container = FabricLoader.getInstance().getModContainer(arg)).isPresent()) {
                return PlaceholderResult.value((class_2561)class_2561.method_43470((String)((ModContainer)container.get()).getMetadata().getDescription()));
            }
            return PlaceholderResult.invalid("Invalid argument");
        });
        Placeholders.register(new class_2960("server", "name"), (ctx, arg) -> PlaceholderResult.value(ctx.server().method_16898()));
        Placeholders.register(new class_2960("server", "used_ram"), (ctx, arg) -> {
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            MemoryUsage heapUsage = memoryMXBean.getHeapMemoryUsage();
            return PlaceholderResult.value(Objects.equals(arg, "gb") ? String.format("%.1f", Float.valueOf((float)heapUsage.getUsed() / 1.0737418E9f)) : String.format("%d", heapUsage.getUsed() / 0x100000L));
        });
        Placeholders.register(new class_2960("server", "max_ram"), (ctx, arg) -> {
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            MemoryUsage heapUsage = memoryMXBean.getHeapMemoryUsage();
            return PlaceholderResult.value(Objects.equals(arg, "gb") ? String.format("%.1f", Float.valueOf((float)heapUsage.getMax() / 1.0737418E9f)) : String.format("%d", heapUsage.getMax() / 0x100000L));
        });
        Placeholders.register(new class_2960("server", "online"), (ctx, arg) -> PlaceholderResult.value(String.valueOf(ctx.server().method_3760().method_14574())));
        Placeholders.register(new class_2960("server", "max_players"), (ctx, arg) -> PlaceholderResult.value(String.valueOf(ctx.server().method_3760().method_14592())));
        Placeholders.register(new class_2960("server", "objective_name_top"), (ctx, arg) -> {
            String[] args = arg.split(" ");
            if (args.length >= 2) {
                class_2995 scoreboard = ctx.server().method_3845();
                class_266 scoreboardObjective = scoreboard.method_1165(args[0]);
                if (scoreboardObjective == null) {
                    return PlaceholderResult.invalid("Invalid objective!");
                }
                try {
                    int position = Integer.parseInt(args[1]);
                    Collection playerScores = scoreboard.method_1184(scoreboardObjective);
                    class_267 score = ((class_267[])playerScores.toArray(class_267[]::new))[playerScores.size() - position];
                    return PlaceholderResult.value(score.method_1129());
                }
                catch (Exception e) {
                    return PlaceholderResult.invalid("Invalid position!");
                }
            }
            return PlaceholderResult.invalid("Not enough arguments!");
        });
        Placeholders.register(new class_2960("server", "objective_score_top"), (ctx, arg) -> {
            String[] args = arg.split(" ");
            if (args.length >= 2) {
                class_2995 scoreboard = ctx.server().method_3845();
                class_266 scoreboardObjective = scoreboard.method_1165(args[0]);
                if (scoreboardObjective == null) {
                    return PlaceholderResult.invalid("Invalid objective!");
                }
                try {
                    int position = Integer.parseInt(args[1]);
                    Collection playerScores = scoreboard.method_1184(scoreboardObjective);
                    class_267 score = ((class_267[])playerScores.toArray(class_267[]::new))[playerScores.size() - position];
                    return PlaceholderResult.value(String.valueOf(score.method_1126()));
                }
                catch (Exception e) {
                    return PlaceholderResult.invalid("Invalid position!");
                }
            }
            return PlaceholderResult.invalid("Not enough arguments!");
        });
    }
}

