/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.api.node.parent;

import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.parent.ParentNode;
import eu.pb4.placeholders.api.node.parent.ParentTextNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public final class HoverNode<T, H>
extends ParentNode {
    private final Action<T, H> action;
    private final T value;

    public HoverNode(TextNode[] children, Action<T, H> action, T value) {
        super(children);
        this.action = action;
        this.value = value;
    }

    @Override
    protected class_2561 applyFormatting(class_5250 out, ParserContext context) {
        if (this.action == Action.TEXT) {
            return out.method_10862(out.method_10866().method_10949(new class_2568(this.action.vanillaType(), (Object)((TextNode)this.value).toText(context, true))));
        }
        if (this.action == Action.ENTITY) {
            return out.method_10862(out.method_10866().method_10949(new class_2568(this.action.vanillaType(), (Object)((EntityNodeContent)this.value).toVanilla(context))));
        }
        return out.method_10862(out.method_10866().method_10949(new class_2568(this.action.vanillaType(), this.value)));
    }

    @Override
    public ParentTextNode copyWith(TextNode[] children) {
        return new HoverNode<T, H>(children, this.action, this.value);
    }

    @Override
    public ParentTextNode copyWith(TextNode[] children, NodeParser parser) {
        if (this.action == Action.TEXT) {
            return new HoverNode<TextNode, class_2561>(children, Action.TEXT, parser.parseNode((TextNode)this.value));
        }
        if (this.action == Action.ENTITY && ((EntityNodeContent)this.value).name != null) {
            EntityNodeContent val = (EntityNodeContent)this.value;
            return new HoverNode<EntityNodeContent, class_2568.class_5248>(children, Action.ENTITY, new EntityNodeContent(val.entityType, val.uuid, parser.parseNode(val.name)));
        }
        return this.copyWith(children);
    }

    public Action<T, H> action() {
        return this.action;
    }

    public T value() {
        return this.value;
    }

    @Override
    public String toString() {
        return "HoverNode{value=" + this.value + ", children=" + Arrays.toString(this.children) + "}";
    }

    @Override
    public boolean isDynamicNoChildren() {
        return this.action == Action.TEXT && ((TextNode)this.value).isDynamic() || this.action == Action.ENTITY && ((EntityNodeContent)this.value).name.isDynamic();
    }

    public record Action<T, H>(class_2568.class_5247<H> vanillaType) {
        public static final Action<EntityNodeContent, class_2568.class_5248> ENTITY = new Action(class_2568.class_5247.field_24344);
        public static final Action<class_2568.class_5249, class_2568.class_5249> ITEM_STACK = new Action(class_2568.class_5247.field_24343);
        public static final Action<TextNode, class_2561> TEXT = new Action(class_2568.class_5247.field_24342);
    }

    public record EntityNodeContent(class_1299<?> entityType, UUID uuid, @Nullable TextNode name) {
        public class_2568.class_5248 toVanilla(ParserContext context) {
            return new class_2568.class_5248(this.entityType, this.uuid, this.name != null ? this.name.toText(context, true) : null);
        }
    }
}

