/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.api;

import com.mojang.authlib.GameProfile;
import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.impl.placeholder.ViewObjectImpl;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public record PlaceholderContext(MinecraftServer server, class_2168 source, @Nullable class_3218 world, @Nullable class_3222 player, @Nullable class_1297 entity, @Nullable GameProfile gameProfile, ViewObject view) {
    public static ParserContext.Key<PlaceholderContext> KEY = new ParserContext.Key<PlaceholderContext>("placeholder_context", PlaceholderContext.class);

    public PlaceholderContext(MinecraftServer server, class_2168 source, @Nullable class_3218 world, @Nullable class_3222 player, @Nullable class_1297 entity, @Nullable GameProfile gameProfile) {
        this(server, source, world, player, entity, gameProfile, ViewObject.DEFAULT);
    }

    public boolean hasWorld() {
        return this.world != null;
    }

    public boolean hasPlayer() {
        return this.player != null;
    }

    public boolean hasGameProfile() {
        return this.gameProfile != null;
    }

    public boolean hasEntity() {
        return this.entity != null;
    }

    public ParserContext asParserContext() {
        return ParserContext.of(KEY, this);
    }

    public PlaceholderContext withView(ViewObject view) {
        return new PlaceholderContext(this.server, this.source, this.world, this.player, this.entity, this.gameProfile, view);
    }

    public void addToContext(ParserContext context) {
        context.with(KEY, this);
    }

    public static PlaceholderContext of(MinecraftServer server) {
        return PlaceholderContext.of(server, ViewObject.DEFAULT);
    }

    public static PlaceholderContext of(MinecraftServer server, ViewObject view) {
        return new PlaceholderContext(server, server.method_3739(), null, null, null, null, view);
    }

    public static PlaceholderContext of(GameProfile profile, MinecraftServer server) {
        return PlaceholderContext.of(profile, server, ViewObject.DEFAULT);
    }

    public static PlaceholderContext of(GameProfile profile, MinecraftServer server, ViewObject view) {
        String name = profile.getName() != null ? profile.getName() : profile.getId().toString();
        return new PlaceholderContext(server, new class_2168(class_2165.field_17395, class_243.field_1353, class_241.field_1340, server.method_30002(), server.method_3835(profile), name, (class_2561)class_2561.method_43470((String)name), server, null), null, null, null, profile);
    }

    public static PlaceholderContext of(class_3222 player) {
        return PlaceholderContext.of(player, ViewObject.DEFAULT);
    }

    public static PlaceholderContext of(class_3222 player, ViewObject view) {
        return new PlaceholderContext(player.method_5682(), player.method_5671(), player.method_51469(), player, (class_1297)player, player.method_7334(), view);
    }

    public static PlaceholderContext of(class_2168 source) {
        return PlaceholderContext.of(source, ViewObject.DEFAULT);
    }

    public static PlaceholderContext of(class_2168 source, ViewObject view) {
        return new PlaceholderContext(source.method_9211(), source, source.method_9225(), source.method_44023(), source.method_9228(), source.method_44023() != null ? source.method_44023().method_7334() : null, view);
    }

    public static PlaceholderContext of(class_1297 entity) {
        return PlaceholderContext.of(entity, ViewObject.DEFAULT);
    }

    public static PlaceholderContext of(class_1297 entity, ViewObject view) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            return PlaceholderContext.of(player, view);
        }
        return new PlaceholderContext(entity.method_5682(), entity.method_5671(), (class_3218)entity.method_37908(), null, entity, null, view);
    }

    public static interface ViewObject {
        public static final ViewObject DEFAULT = ViewObject.of(new class_2960("placeholder_api", "default"));

        public static ViewObject of(class_2960 identifier) {
            return new ViewObjectImpl(identifier);
        }

        public class_2960 identifier();
    }
}

