/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.mariuszgromada.math.mxparser.CloneCache;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.HeadEqBody;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.SerializationUtils;
import org.mariuszgromada.math.mxparser.StringModel;
import org.mariuszgromada.math.mxparser.StringUtils;

public class Constant
extends PrimitiveElement
implements Serializable {
    private static final int serialClassID = 5;
    private static final long serialVersionUID = SerializationUtils.getSerialVersionUID(5);
    public static final int NOT_FOUND = -1;
    public static final int TYPE_ID = 104;
    public static String TYPE_DESC = "<NA>";
    public static final boolean NO_SYNTAX_ERRORS = true;
    public static final boolean SYNTAX_ERROR = false;
    @Deprecated
    public static final boolean SYNTAX_ERROR_OR_STATUS_UNKNOWN = false;
    private String constantName = "";
    private double constantValue = Double.NaN;
    private String description = "";
    private List<Expression> relatedExpressionsList;
    private boolean syntaxStatus;
    private String errorMessage = "";

    private static String buildErrorMessageInvalidConstantName(String constantName) {
        return StringModel.buildErrorMessagePatternDoesNotMatchWithExamples(constantName, StringModel.STRING_RESOURCES.INVALID_CONSTANT_NAME, "'x', 'x_y', 'x1', 'x_1', 'abc', [abc], ...");
    }

    private static String buildErrorMessageInvalidConstantDefinitionString(String constantDefinitionString) {
        return StringModel.buildErrorMessagePatternDoesNotMatchWithExamples(constantDefinitionString, StringModel.STRING_RESOURCES.INVALID_CONSTANT_DEFINITION, "'x', 'x=5', 'x=5+3/2', '[x]=2*y', ...");
    }

    private void registerNoSyntaxErrorInDefinition() {
        this.syntaxStatus = true;
        this.errorMessage = StringModel.STRING_RESOURCES.NO_ERRORS_DETECTED_IN_CONSTANT_DEFINITION;
    }

    private void registerSyntaxErrorInDefinition(String errorMessage) {
        this.syntaxStatus = false;
        this.errorMessage = errorMessage;
    }

    public Constant(String constantName, double constantValue) {
        super(104);
        this.relatedExpressionsList = new ArrayList<Expression>();
        if (constantName == null) {
            this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_STRING_IS_NULL);
            return;
        }
        String constantNameTrim = constantName.trim();
        if (!StringUtils.regexMatch(constantNameTrim, "((([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))|\\[(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))\\])")) {
            this.registerSyntaxErrorInDefinition(Constant.buildErrorMessageInvalidConstantName(constantNameTrim));
            return;
        }
        this.constantName = constantNameTrim;
        this.constantValue = constantValue;
        this.registerNoSyntaxErrorInDefinition();
    }

    public Constant(String constantName, double constantValue, String description) {
        super(104);
        this.relatedExpressionsList = new ArrayList<Expression>();
        if (constantName == null || description == null) {
            this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_STRING_IS_NULL);
            return;
        }
        String constantNameTrim = constantName.trim();
        if (!StringUtils.regexMatch(constantNameTrim, "((([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))|\\[(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))\\])")) {
            this.registerSyntaxErrorInDefinition(Constant.buildErrorMessageInvalidConstantName(constantNameTrim));
            return;
        }
        this.constantName = constantNameTrim;
        this.constantValue = constantValue;
        this.description = description;
        this.registerNoSyntaxErrorInDefinition();
    }

    public Constant(String constantDefinitionString, PrimitiveElement ... elements) {
        super(104);
        this.relatedExpressionsList = new ArrayList<Expression>();
        if (constantDefinitionString == null) {
            this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_STRING_IS_NULL);
            return;
        }
        if (elements == null) {
            this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_ELEMENTS_ARE_NULL);
            return;
        }
        String constantDefinitionStringTrim = constantDefinitionString.trim();
        if (!StringUtils.regexMatch(constantDefinitionStringTrim, "(\\s)*((([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))|\\[(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))\\])(\\s)*=(\\s)*(.)+(\\s)*")) {
            this.registerSyntaxErrorInDefinition(Constant.buildErrorMessageInvalidConstantDefinitionString(constantDefinitionStringTrim));
            return;
        }
        HeadEqBody headEqBody = new HeadEqBody(constantDefinitionStringTrim);
        this.constantName = headEqBody.headTokens.get((int)0).tokenStr;
        Expression bodyExpression = new Expression(headEqBody.bodyStr, elements);
        this.constantValue = bodyExpression.calculate();
        this.syntaxStatus = bodyExpression.getSyntaxStatus();
        this.errorMessage = bodyExpression.getErrorMessage();
    }

    private Constant(Constant constantToClone) {
        super(104);
        this.constantName = constantToClone.constantName;
        this.constantValue = constantToClone.constantValue;
        this.description = constantToClone.description;
        this.syntaxStatus = constantToClone.syntaxStatus;
        this.errorMessage = constantToClone.errorMessage;
        this.relatedExpressionsList = new ArrayList<Expression>();
    }

    public String getConstantName() {
        return this.constantName;
    }

    public void setConstantName(String constantName) {
        if (constantName == null) {
            if (!this.syntaxStatus) {
                this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_STRING_IS_NULL);
            }
            return;
        }
        String constantNameTrim = constantName.trim();
        if (this.constantName.equals(constantNameTrim)) {
            return;
        }
        if (!StringUtils.regexMatch(constantNameTrim, "((([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))|\\[(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))\\])")) {
            if (!this.syntaxStatus) {
                this.registerSyntaxErrorInDefinition(Constant.buildErrorMessageInvalidConstantName(constantNameTrim));
            }
            return;
        }
        this.constantName = constantNameTrim;
        this.setExpressionModifiedFlags();
        this.registerNoSyntaxErrorInDefinition();
    }

    public void setConstantValue(double constantValue) {
        this.constantValue = constantValue;
    }

    public double getConstantValue() {
        return this.constantValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description == null) {
            return;
        }
        this.description = description;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean getSyntaxStatus() {
        return this.syntaxStatus;
    }

    void addRelatedExpression(Expression expression) {
        if (expression == null) {
            return;
        }
        if (!this.relatedExpressionsList.contains(expression)) {
            this.relatedExpressionsList.add(expression);
        }
    }

    void removeRelatedExpression(Expression expression) {
        if (expression != null) {
            this.relatedExpressionsList.remove(expression);
        }
    }

    void setExpressionModifiedFlags() {
        for (Expression e : this.relatedExpressionsList) {
            e.setExpressionModifiedFlag();
        }
    }

    Constant cloneForThreadSafeInternal(CloneCache cloneCache) {
        Constant constantClone = cloneCache.getConstantClone(this);
        if (constantClone == null) {
            cloneCache.cacheCloneInProgress(this);
            constantClone = new Constant(this);
            cloneCache.clearCloneInProgress(this);
            cloneCache.cacheConstantClone(this, constantClone);
        }
        return constantClone;
    }

    Constant cloneForThreadSafeInternal(Expression relatedExpressionThatInitiatedClone, CloneCache cloneCache) {
        Constant constantClone = this.cloneForThreadSafeInternal(cloneCache);
        constantClone.addRelatedExpression(relatedExpressionThatInitiatedClone);
        return constantClone;
    }

    public Constant cloneForThreadSafe() {
        CloneCache cloneCache = new CloneCache();
        Constant constantClone = this.cloneForThreadSafeInternal(cloneCache);
        cloneCache.addAllAtTheEndElements();
        cloneCache.clearCache();
        return constantClone;
    }
}

