/*
 * Decompiled with CFR 0.152.
 */
package io.github.tropheusj.milk;

import io.github.tropheusj.milk.Milk;
import io.github.tropheusj.milk.MilkFluid;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1746;
import net.minecraft.class_1747;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2480;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3611;
import net.minecraft.class_4970;
import net.minecraft.class_5328;
import net.minecraft.class_5556;
import net.minecraft.class_5620;
import net.minecraft.class_5712;

public class MilkCauldron
extends class_5556 {
    static final Map<class_1792, class_5620> MILK_CAULDRON_BEHAVIOR = class_5620.method_32206();
    static final class_5620 FILL_FROM_BUCKET = (state, world, pos, player, hand, stack) -> class_5620.method_32207((class_1937)world, (class_2338)pos, (class_1657)player, (class_1268)hand, (class_1799)stack, (class_2680)((class_2680)Milk.MILK_CAULDRON.method_9564().method_11657((class_2769)field_27206, (Comparable)Integer.valueOf(3))), (class_3414)class_3417.field_14834);
    static final class_5620 EMPTY_TO_BUCKET = (state, world, pos, player, hand, stack) -> class_5620.method_32210((class_2680)state, (class_1937)world, (class_2338)pos, (class_1657)player, (class_1268)hand, (class_1799)stack, (class_1799)new class_1799((class_1935)class_1802.field_8103), statex -> (Integer)statex.method_11654((class_2769)field_27206) == 3, (class_3414)class_3417.field_15126);
    static final class_5620 MILKIFY_DYEABLE_ITEM = (state, world, pos, player, hand, stack) -> {
        class_1792 item = stack.method_7909();
        if (item instanceof class_1768) {
            class_1768 dyeableItem = (class_1768)item;
            if (!world.field_9236) {
                dyeableItem.method_7799(stack, 0xFFFFFF);
                player.method_7281(class_3468.field_15382);
                class_5556.method_31650((class_2680)state, (class_1937)world, (class_2338)pos);
            }
            return class_1269.method_29236((boolean)world.field_9236);
        }
        return class_1269.field_5811;
    };
    static final class_5620 MILKIFY_SHULKER_BOX = (state, world, pos, player, hand, stack) -> {
        class_2248 block = class_2248.method_9503((class_1792)stack.method_7909());
        if (block instanceof class_2480) {
            if (!world.field_9236) {
                class_1799 itemStack = new class_1799((class_1935)class_2246.field_10199);
                if (stack.method_7985()) {
                    itemStack.method_7980(stack.method_7969().method_10553());
                }
                player.method_6122(hand, itemStack);
                player.method_7281(class_3468.field_15398);
                class_5556.method_31650((class_2680)state, (class_1937)world, (class_2338)pos);
            }
            return class_1269.method_29236((boolean)world.field_9236);
        }
        return class_1269.field_5811;
    };
    static final class_5620 MILKIFY_BANNER = (state, world, pos, player, hand, stack) -> {
        if (!world.method_8608()) {
            class_1799 itemStack = new class_1799((class_1935)class_1802.field_8539);
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            if (stack.method_7960()) {
                player.method_6122(hand, itemStack);
            } else if (player.method_31548().method_7394(itemStack)) {
                player.field_7498.method_34252();
            } else {
                player.method_7328(itemStack, false);
            }
            player.method_7281(class_3468.field_15390);
            class_5556.method_31650((class_2680)state, (class_1937)world, (class_2338)pos);
        }
        return class_1269.method_29236((boolean)world.method_8608());
    };

    public MilkCauldron(class_4970.class_2251 settings) {
        super(settings, precipitation -> false, MilkCauldron.getMilkCauldronBehaviors());
    }

    private static Map<class_1792, class_5620> getMilkCauldronBehaviors() {
        for (Field field : class_1802.class.getDeclaredFields()) {
            try {
                class_1747 blockItem;
                Object obj;
                if (!Modifier.isStatic(field.getModifiers()) || !((obj = field.get(null)) instanceof class_1792)) continue;
                class_1792 item = (class_1792)obj;
                if (item instanceof class_1768) {
                    MILK_CAULDRON_BEHAVIOR.put(item, MILKIFY_DYEABLE_ITEM);
                    continue;
                }
                if (item instanceof class_1746) {
                    MILK_CAULDRON_BEHAVIOR.put(item, MILKIFY_BANNER);
                    continue;
                }
                if (!(item instanceof class_1747) || !((blockItem = (class_1747)item).method_7711() instanceof class_2480)) continue;
                MILK_CAULDRON_BEHAVIOR.put(item, MILKIFY_SHULKER_BOX);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        MILK_CAULDRON_BEHAVIOR.put(class_1802.field_8103, FILL_FROM_BUCKET);
        MILK_CAULDRON_BEHAVIOR.put(class_1802.field_8550, EMPTY_TO_BUCKET);
        return MILK_CAULDRON_BEHAVIOR;
    }

    protected boolean method_32765(class_3611 fluid) {
        return fluid instanceof MilkFluid;
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (!world.field_9236 && this.method_31616(state, pos, entity) && entity.method_36971(world, pos)) {
            boolean shouldDrain = false;
            if (entity.method_5809()) {
                entity.method_5646();
                shouldDrain = true;
            }
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                shouldDrain = Milk.tryRemoveRandomEffect(livingEntity);
            }
            if (shouldDrain) {
                MilkCauldron.method_31650((class_2680)state, (class_1937)world, (class_2338)pos);
            }
        }
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return class_1802.field_8638.method_7854();
    }

    public static class_5620 addBehavior(class_5620 behavior, class_1792 ... items) {
        for (class_1792 item : items) {
            MILK_CAULDRON_BEHAVIOR.put(item, behavior);
        }
        return behavior;
    }

    public static class_5620 addInputToCauldronExchange(class_1799 toEmpty, class_1799 emptied, boolean ignoreNbt) {
        class_1792 emptyItem = toEmpty.method_7909();
        class_5620 b = MilkCauldron.addBehavior(new InputToCauldronCauldronBehavior(toEmpty, emptied, ignoreNbt), emptyItem);
        class_5620.field_27775.put(emptyItem, b);
        return b;
    }

    public static class_5620 addOutputToItemExchange(class_1799 toFill, class_1799 filled, boolean ignoreNbt) {
        return MilkCauldron.addBehavior(new OutputToItemCauldronBehavior(toFill, filled, ignoreNbt), toFill.method_7909());
    }

    private static boolean typeAndDataEqual(class_1799 stack1, class_1799 stack2, boolean ignoreNbt) {
        boolean itemsEqual = class_1799.method_7984((class_1799)stack1, (class_1799)stack2);
        if (ignoreNbt) {
            return itemsEqual;
        }
        boolean nbtEqual = stack1.method_7985() ? stack1.method_7969().equals((Object)stack2.method_7969()) : stack2.method_7985();
        return itemsEqual && nbtEqual;
    }

    public record InputToCauldronCauldronBehavior(class_1799 toEmpty, class_1799 emptied, boolean ignoreNbt) implements class_5620
    {
        public class_1269 interact(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 stack) {
            class_2248 block = state.method_26204();
            if (!(block != class_2246.field_10593 && block != Milk.MILK_CAULDRON || state.method_28498((class_2769)class_5556.field_27206) && (Integer)state.method_11654((class_2769)class_5556.field_27206) == 3 || !MilkCauldron.typeAndDataEqual(stack, this.toEmpty, this.ignoreNbt))) {
                if (!world.field_9236) {
                    player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)this.emptied.method_7972()));
                    player.method_7281(class_3468.field_15373);
                    player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
                    if (block == class_2246.field_10593) {
                        world.method_8501(pos, (class_2680)Milk.MILK_CAULDRON.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(1)));
                    } else {
                        world.method_8501(pos, (class_2680)state.method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)class_5556.field_27206) + 1)));
                    }
                    world.method_8396(null, pos, class_3417.field_14826, class_3419.field_15245, 1.0f, 1.0f);
                    world.method_33596(null, class_5712.field_28166, pos);
                }
                return class_1269.method_29236((boolean)world.field_9236);
            }
            return class_1269.field_5811;
        }
    }

    public record OutputToItemCauldronBehavior(class_1799 toFill, class_1799 filled, boolean ignoreNbt) implements class_5620
    {
        public class_1269 interact(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 held) {
            if (!world.field_9236 && MilkCauldron.typeAndDataEqual(held, this.toFill, this.ignoreNbt)) {
                class_1792 item = held.method_7909();
                player.method_6122(hand, class_5328.method_30012((class_1799)held, (class_1657)player, (class_1799)this.filled.method_7972()));
                player.method_7281(class_3468.field_15373);
                player.method_7259(class_3468.field_15372.method_14956((Object)item));
                class_5556.method_31650((class_2680)state, (class_1937)world, (class_2338)pos);
                world.method_8396(null, pos, class_3417.field_14779, class_3419.field_15245, 1.0f, 1.0f);
                world.method_33596(null, class_5712.field_28167, pos);
            }
            return class_1269.method_29236((boolean)world.field_9236);
        }
    }
}

