/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.common.economy.impl;

import com.mojang.authlib.GameProfile;
import eu.pb4.common.economy.api.EconomyAccount;
import eu.pb4.common.economy.api.EconomyCurrency;
import eu.pb4.common.economy.api.EconomyProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class EconomyImpl {
    private static final Map<String, EconomyProvider> PROVIDERS_BY_ID = new HashMap<String, EconomyProvider>();
    private static final Map<EconomyProvider, String> ID_BY_PROVIDERS = new HashMap<EconomyProvider, String>();
    private static final Set<EconomyProvider> PROVIDERS = new HashSet<EconomyProvider>();
    public static final class_2583 WHITE_NON_ITALIC_STYLE = class_2583.field_24360.method_27706(class_124.field_1068).method_10978(Boolean.valueOf(false));

    public static String getId(EconomyProvider provider) {
        return ID_BY_PROVIDERS.get(provider);
    }

    public static EconomyAccount get(MinecraftServer server, GameProfile profile, class_2960 account) {
        EconomyProvider provider = EconomyImpl.getProvider(account.method_12836());
        if (provider != null) {
            return provider.getAccount(server, profile, account.method_12832());
        }
        return null;
    }

    public static Collection<EconomyAccount> getAll(MinecraftServer server, GameProfile profile) {
        ArrayList<EconomyAccount> list = new ArrayList<EconomyAccount>();
        for (EconomyProvider provider : PROVIDERS) {
            list.addAll(provider.getAccounts(server, profile));
        }
        return list;
    }

    public static Collection<EconomyAccount> getAll(MinecraftServer server, GameProfile profile, EconomyCurrency currency) {
        ArrayList<EconomyAccount> list = new ArrayList<EconomyAccount>();
        for (EconomyProvider provider : PROVIDERS) {
            list.addAll(provider.getAccounts(server, profile, currency));
        }
        return list;
    }

    public static EconomyCurrency getCurrency(MinecraftServer server, class_2960 account) {
        EconomyProvider provider = EconomyImpl.getProvider(account.method_12836());
        if (provider != null) {
            return provider.getCurrency(server, account.method_12832());
        }
        return null;
    }

    public static Collection<EconomyCurrency> getCurrencies(MinecraftServer server) {
        ArrayList<EconomyCurrency> list = new ArrayList<EconomyCurrency>();
        for (EconomyProvider provider : PROVIDERS) {
            list.addAll(provider.getCurrencies(server));
        }
        return list;
    }

    public static EconomyProvider getProvider(String id) {
        return PROVIDERS_BY_ID.get(id);
    }

    public static EconomyProvider register(String providerId, EconomyProvider provider) {
        if (PROVIDERS_BY_ID.containsKey(providerId)) {
            throw new IllegalArgumentException("Provider '" + providerId + "' already exists!");
        }
        for (int i = 0; i < providerId.length(); ++i) {
            if (EconomyImpl.isNamespaceCharacterValid(providerId.charAt(i))) continue;
            throw new IllegalArgumentException("Provider id '" + providerId + "' contains invalid characters!");
        }
        PROVIDERS_BY_ID.put(providerId, provider);
        ID_BY_PROVIDERS.put(provider, providerId);
        PROVIDERS.add(provider);
        return provider;
    }

    public static Collection<EconomyProvider> providers() {
        return Collections.unmodifiableSet(PROVIDERS);
    }

    private static boolean isNamespaceCharacterValid(char character) {
        return character == '_' || character == '-' || character >= 'a' && character <= 'z' || character >= '0' && character <= '9' || character == '.';
    }
}

