/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.yabn.elements;

import com.teamresourceful.yabn.elements.YabnElement;
import com.teamresourceful.yabn.elements.YabnPrimitive;
import com.teamresourceful.yabn.elements.YabnType;
import com.teamresourceful.yabn.utils.ByteArrayUtils;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public record YabnObject(Map<String, YabnElement> elements) implements YabnElement
{
    public YabnObject() {
        this(new LinkedHashMap<String, YabnElement>());
    }

    public YabnObject put(String key, @Nullable YabnElement element) {
        this.elements.put(key, element == null ? YabnPrimitive.ofNull() : element);
        return this;
    }

    public YabnElement get(String key) {
        return this.elements.get(key);
    }

    @Override
    public byte[] toData() {
        byte[] data = new byte[]{};
        if (this.elements.isEmpty()) {
            return data;
        }
        for (Map.Entry<String, YabnElement> entry : this.elements.entrySet()) {
            YabnElement element = entry.getValue();
            byte[] dataEntry = ByteArrayUtils.add(new byte[]{element.getType().id}, entry.getKey().getBytes(StandardCharsets.UTF_8));
            dataEntry = ByteArrayUtils.add(dataEntry, 0);
            dataEntry = ByteArrayUtils.add(dataEntry, element.toData());
            data = ByteArrayUtils.add(data, dataEntry);
        }
        return ByteArrayUtils.add(data, 0);
    }

    @Override
    public YabnType getType() {
        return this.elements.isEmpty() ? YabnType.EMPTY_OBJECT : YabnType.OBJECT;
    }
}

