/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.map;

import com.google.common.base.Preconditions;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.map.MapCursor;

public final class CraftMapCursor {

    public static final class CraftType {
        public static MapCursor.Type minecraftToBukkit(MapDecorationType minecraft) {
            Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
            net.minecraft.core.Registry registry = CraftRegistry.getMinecraftRegistry(Registries.MAP_DECORATION_TYPE);
            MapCursor.Type bukkit = (MapCursor.Type)Registry.MAP_DECORATION_TYPE.get(CraftNamespacedKey.fromMinecraft(registry.getResourceKey(minecraft).orElseThrow().location()));
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return bukkit;
        }

        public static MapCursor.Type minecraftHolderToBukkit(Holder<MapDecorationType> minecraft) {
            return CraftType.minecraftToBukkit(minecraft.value());
        }

        public static MapDecorationType bukkitToMinecraft(MapCursor.Type bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return (MapDecorationType)CraftRegistry.getMinecraftRegistry(Registries.MAP_DECORATION_TYPE).getOptional(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
        }

        public static Holder<MapDecorationType> bukkitToMinecraftHolder(MapCursor.Type bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            net.minecraft.core.Registry registry = CraftRegistry.getMinecraftRegistry(Registries.MAP_DECORATION_TYPE);
            Holder<MapDecorationType> holder = registry.wrapAsHolder(CraftType.bukkitToMinecraft(bukkit));
            if (holder instanceof Holder.Reference) {
                Holder.Reference holder2 = (Holder.Reference)holder;
                return holder2;
            }
            throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own map cursor type without properly registering it.");
        }
    }
}

